/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.google.gson.annotations.JsonAdapter;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldHelper;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.report.ExcludeDates;
import com.nuix.automate.workflow.core.execution.options.report.ReportView;
import com.nuix.automate.workflow.core.execution.options.report.ReportViewFieldType;
import com.nuix.automate.workflow.core.execution.options.report.ReportViewSummarizeBy;
import com.nuix.automate.workflow.core.execution.options.report.SizeMethod;
import com.nuix.automate.workflow.core.execution.options.report.TemplateWorksheetName;
import com.nuix.automate.workflow.core.execution.serialization.ReportProcessingStagesAdapter;
import com.nuix.automate.workflow.core.execution.serialization.ReportViewsAdapter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

@OperationMetadata(alias=OperationAlias.REPORT, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"REPORTING"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class ProcessingReportOperation
extends Operation {
    protected final transient String defaultReportLocation = "{case_folder}/Reports/{case_name} - Processing Report {date_time}.xlsx";
    @FormField(required=false)
    public String scope = "";
    @FormField(required=false)
    public String customReportTemplatePath;
    @FormField
    public String reportLocation = "{case_folder}/Reports/{case_name} - Processing Report {date_time}.xlsx";
    @JsonAdapter(value=ReportProcessingStagesAdapter.class)
    @FormField(columnFields={@FormFieldColumn(label="stageName"), @FormFieldColumn(label="query", required=false), @FormFieldColumn(label="computeSizeByMethod", componentType=FieldComponentType.DROPDOWN, enumClass=SizeMethod.class), @FormFieldColumn(label="excludeFromOverview", componentType=FieldComponentType.CHECKBOX)})
    public List<Object[]> processingStages;
    @JsonAdapter(value=ReportViewsAdapter.class)
    @FormField(componentType=FieldComponentType.OBJECT_LIST, columnFields={@FormFieldColumn(label="viewName"), @FormFieldColumn(label="options", fieldClass=ReportView.class)})
    public List<Object[]> reportViews;
    @FormField(required=false, columnFields={@FormFieldColumn(label="locations")}, helpers={@FormFieldHelper(location="#_processing-report-multiple-cases")})
    public List<Object[]> additionalCasesLocations = new ArrayList<Object[]>();

    public ProcessingReportOperation() {
        this.processingStages = new ArrayList<Object[]>();
        this.processingStages.add(new Object[]{this.iu.getString("ProcessingReportOperation.ProcessingStage.SourceData"), "flag:physical_file", SizeMethod.FILE_SISE, false});
        this.processingStages.add(new Object[]{this.iu.getString("ProcessingReportOperation.ProcessingStage.Extracted"), "flag:( NOT physical_file OR audited )", SizeMethod.AUDITED_SIZE, false});
        this.processingStages.add(new Object[]{this.iu.getString("ProcessingReportOperation.ProcessingStage.Material"), "flag:audited", SizeMethod.AUDITED_SIZE, false});
        this.processingStages.add(new Object[]{this.iu.getString("ProcessingReportOperation.ProcessingStage.PostExclusions"), "flag:audited has-exclusion:0", SizeMethod.AUDITED_SIZE, false});
        this.processingStages.add(new Object[]{this.iu.getString("ProcessingReportOperation.ProcessingStage.PostDeduplication"), "is-item-original:1", SizeMethod.AUDITED_SIZE, false});
        this.processingStages.add(new Object[]{this.iu.getString("ProcessingReportOperation.ProcessingStage.Export"), "has-production-set:1", SizeMethod.AUDITED_ATTACHMENTS_2X, false});
        this.reportViews = new ArrayList<Object[]>();
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.ProcessingOverview"), new ReportView(null, ReportViewFieldType.EVIDENCE_CONTAINER, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.PROCESSING_STAGE, new HashMap<String, String>(), ReportViewSummarizeBy.COUNT_AND_SIZE, false, TemplateWorksheetName.TEMPLATE_2D_COUNT_SIZE_CHART.toString())});
        int currentYear = Calendar.getInstance().get(1);
        int currentMonth = Calendar.getInstance().get(2) + 1;
        HashMap<String, String> yearProperties = new HashMap<String, String>();
        yearProperties.put("Start", "2010");
        yearProperties.put("End", "2030");
        yearProperties.put("Exclude", ExcludeDates.EDGE_DATES_WITH_NO_VALUES.name());
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.MaterialItemsByCustodian"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Material"), ReportViewFieldType.CUSTODIAN, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.CATEGORY, new HashMap<String, String>(), ReportViewSummarizeBy.COUNT_AND_SIZE, true, TemplateWorksheetName.TEMPLATE_2D_COUNT_SIZE_CHART_PIE.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.ExportItemsByCustodian"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Export"), ReportViewFieldType.CUSTODIAN, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.CATEGORY, new HashMap<String, String>(), ReportViewSummarizeBy.COUNT_AND_SIZE, false, TemplateWorksheetName.TEMPLATE_2D_COUNT_SIZE_CHART_PIE.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.MaterialItemsByYear"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Material"), ReportViewFieldType.CUSTODIAN, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.TOP_LEVEL_YEAR, yearProperties, ReportViewSummarizeBy.COUNT, false, TemplateWorksheetName.TEMPLATE_2D_COUNT_CHART.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.ExportItemsByYear"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Export"), ReportViewFieldType.CUSTODIAN, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.TOP_LEVEL_YEAR, yearProperties, ReportViewSummarizeBy.COUNT, false, TemplateWorksheetName.TEMPLATE_2D_COUNT_CHART.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.MaterialItemsByType"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Material"), ReportViewFieldType.KIND_AND_TYPE, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.NONE, null, ReportViewSummarizeBy.COUNT_AND_SIZE, true, TemplateWorksheetName.TEMPLATE_SINGLE_COUNT_SIZE.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.ExportItemsByType"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Export"), ReportViewFieldType.KIND_AND_TYPE, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.NONE, null, ReportViewSummarizeBy.COUNT_AND_SIZE, true, TemplateWorksheetName.TEMPLATE_SINGLE_COUNT_SIZE.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.MaterialItemsByExtension"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Material"), ReportViewFieldType.KIND_AND_FILE_EXTENSION, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.NONE, null, ReportViewSummarizeBy.COUNT_AND_SIZE, true, TemplateWorksheetName.TEMPLATE_SINGLE_COUNT_SIZE.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.ExportItemsByExtension"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Export"), ReportViewFieldType.KIND_AND_FILE_EXTENSION, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.NONE, null, ReportViewSummarizeBy.COUNT_AND_SIZE, true, TemplateWorksheetName.TEMPLATE_SINGLE_COUNT_SIZE.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.MaterialImagesByDimensions"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Material"), ReportViewFieldType.IMAGE_HEIGHT, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.IMAGE_WIDTH, new HashMap<String, String>(), ReportViewSummarizeBy.COUNT, true, TemplateWorksheetName.TEMPLATE_2D_COUNT.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.ExportImagesByDimensions"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Export"), ReportViewFieldType.IMAGE_HEIGHT, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.IMAGE_WIDTH, new HashMap<String, String>(), ReportViewSummarizeBy.COUNT, true, TemplateWorksheetName.TEMPLATE_2D_COUNT.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.IrregularItems"), new ReportView(null, ReportViewFieldType.IRREGULAR_AND_TYPE, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.PROCESSING_STAGE, new HashMap<String, String>(), ReportViewSummarizeBy.COUNT, true, TemplateWorksheetName.TEMPLATE_2D_COUNT.toString())});
        this.reportViews.add(new Object[]{this.iu.getString("ProcessingReportOperation.Report.ExclusionByType"), new ReportView(this.iu.getString("ProcessingReportOperation.ProcessingStage.Material"), ReportViewFieldType.EXCLUSION_AND_TYPE, new HashMap<String, String>(), ReportViewFieldType.NONE, new HashMap<String, String>(), ReportViewFieldType.NONE, null, ReportViewSummarizeBy.COUNT_AND_SIZE, true, TemplateWorksheetName.TEMPLATE_SINGLE_COUNT_SIZE.toString())});
        this.validateNamesUnique(this.reportViews, "Custom view");
        this.customReportTemplatePath = "";
        this.modifiesNuixCase = false;
        this.normalize();
    }

    public boolean validateNamesUnique(List<Object[]> list, String defaultValue) {
        boolean originalDataValid = true;
        HashSet<String> usedProcessingStagesNames = new HashSet<String>();
        for (Object[] objects : list) {
            String name = objects[0].toString();
            if (name.length() == 0) {
                name = defaultValue;
                originalDataValid = false;
                objects[0] = name;
            }
            int maxNameLength = 31;
            Object correctedName = name.substring(0, Math.min(name.length(), maxNameLength)).trim();
            if (usedProcessingStagesNames.contains(name) || name.length() == 0) {
                int counter = 2;
                while (usedProcessingStagesNames.contains(correctedName = name.substring(0, Math.min(name.length(), maxNameLength - String.valueOf(counter).length() - 1)) + " " + counter)) {
                    ++counter;
                }
            }
            usedProcessingStagesNames.add((String)correctedName);
            if (((String)correctedName).equals(name)) continue;
            originalDataValid = false;
            objects[0] = correctedName;
        }
        return originalDataValid;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ProcessingReportOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.REPORT;
    }

    @Override
    public void normalize() {
        super.normalize();
        ArrayList<Object[]> normalizedProcessingStages = new ArrayList<Object[]>();
        for (Object[] processingStage : this.processingStages) {
            Object[] normalizedStage = new Object[4];
            System.arraycopy(processingStage, 0, normalizedStage, 0, 3);
            normalizedStage[3] = processingStage.length == 3 ? Boolean.valueOf(false) : processingStage[3];
            normalizedProcessingStages.add(normalizedStage);
        }
        this.processingStages = normalizedProcessingStages;
        for (Object[] reportViewDetails : this.reportViews) {
            ReportView reportView = (ReportView)reportViewDetails[1];
            reportView.normalize();
            if (reportView.verticalFieldType2 == null) {
                reportView.verticalFieldType2 = ReportViewFieldType.NONE;
            }
            if (reportView.horizontalFieldType == null) {
                reportView.horizontalFieldType = ReportViewFieldType.NONE;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.CASE_NAME_EVIDENCE_CONTAINER) {
                reportView.verticalFieldType = ReportViewFieldType.CASE_NAME;
                reportView.verticalFieldType2 = ReportViewFieldType.EVIDENCE_CONTAINER;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.EVIDENCE_CONTAINER_CUSTODIAN) {
                reportView.verticalFieldType = ReportViewFieldType.EVIDENCE_CONTAINER;
                reportView.verticalFieldType2 = ReportViewFieldType.CUSTODIAN;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.TOP_LEVEL_YEAR_AND_MONTH) {
                reportView.verticalFieldType = ReportViewFieldType.TOP_LEVEL_YEAR_MONTH;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.KIND_AND_TYPE) {
                reportView.verticalFieldType = ReportViewFieldType.KIND;
                reportView.verticalFieldType2 = ReportViewFieldType.TYPE;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.KIND_AND_FILE_EXTENSION) {
                reportView.verticalFieldType = ReportViewFieldType.KIND;
                reportView.verticalFieldType2 = ReportViewFieldType.FILE_EXTENSION;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.KIND_AND_TYPE_FILE_EXTENSION) {
                reportView.verticalFieldType = ReportViewFieldType.KIND;
                reportView.verticalFieldType2 = ReportViewFieldType.TYPE_FILE_EXTENSION;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.IRREGULAR_AND_TYPE) {
                reportView.verticalFieldType = ReportViewFieldType.IRREGULAR;
                reportView.verticalFieldType2 = ReportViewFieldType.TYPE;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.IRREGULAR_AND_TYPE_FILE_EXTENSION) {
                reportView.verticalFieldType = ReportViewFieldType.IRREGULAR;
                reportView.verticalFieldType2 = ReportViewFieldType.TYPE_FILE_EXTENSION;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.ITEMSET_ORIGINALS_AND_DUPLICATES) {
                reportView.verticalFieldType = ReportViewFieldType.ITEMSET;
                reportView.verticalFieldType2 = ReportViewFieldType.ITEMSET_ORIGINALS_DUPLICATES;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.EXCLUSION_AND_TYPE) {
                reportView.verticalFieldType = ReportViewFieldType.EXCLUSION;
                reportView.verticalFieldType2 = ReportViewFieldType.TYPE;
            }
            if (reportView.verticalFieldType == ReportViewFieldType.EXCLUSION_AND_TYPE_FILE_EXTENSION) {
                reportView.verticalFieldType = ReportViewFieldType.EXCLUSION;
                reportView.verticalFieldType2 = ReportViewFieldType.TYPE_FILE_EXTENSION;
            }
            if (reportView.horizontalFieldType == ReportViewFieldType.PROCESSING_STAGE || reportView.verticalFieldType == ReportViewFieldType.PROCESSING_STAGE) {
                reportView.processingStage = null;
            }
            if (reportView.useCustomViewTemplate || reportView.templateWorksheetName != null && !reportView.templateWorksheetName.equals("")) continue;
            if (reportView.horizontalFieldType == ReportViewFieldType.NONE) {
                if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT) {
                    reportView.templateWorksheetName = TemplateWorksheetName.TEMPLATE_SINGLE_COUNT_CHART.toString();
                } else if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                    reportView.templateWorksheetName = TemplateWorksheetName.TEMPLATE_SINGLE_SIZE_CHART.toString();
                } else if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    reportView.templateWorksheetName = TemplateWorksheetName.TEMPLATE_SINGLE_COUNT_SIZE_CHART.toString();
                }
            } else if (reportView.verticalFieldType != ReportViewFieldType.PROCESSING_STAGE) {
                if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT) {
                    reportView.templateWorksheetName = TemplateWorksheetName.TEMPLATE_2D_COUNT_CHART.toString();
                } else if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                    reportView.templateWorksheetName = TemplateWorksheetName.TEMPLATE_2D_SIZE_CHART.toString();
                } else if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                    reportView.templateWorksheetName = TemplateWorksheetName.TEMPLATE_2D_COUNT_SIZE_CHART.toString();
                }
            } else if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT) {
                reportView.templateWorksheetName = TemplateWorksheetName.TEMPLATE_2D_COUNT.toString();
            } else if (reportView.summarizeBy == ReportViewSummarizeBy.SIZE) {
                reportView.templateWorksheetName = TemplateWorksheetName.TEMPLATE_2D_SIZE.toString();
            } else if (reportView.summarizeBy == ReportViewSummarizeBy.COUNT_AND_SIZE) {
                reportView.templateWorksheetName = TemplateWorksheetName.TEMPLATE_2D_COUNT_SIZE.toString();
            }
            if (reportView.verticalFieldType != ReportViewFieldType.METADATA) continue;
            reportView.templateWorksheetName = TemplateWorksheetName.TEMPLATE_METADATA.toString();
        }
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.reportLocation.trim().length() == 0) {
            prerequisites.add(this.iu.getString("ProcessingReportOperation.Prerequisites.ReportLocationMustBeSpecified"));
        }
        return prerequisites;
    }
}

