/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.PromoteToDiscoverFileCopier;
import com.nuix.automate.workflow.core.execution.operations.PromoteToDiscoverOperationImplementation;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class PromoteToDiscoverFileshareFileCopier
extends PromoteToDiscoverFileCopier {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PromoteToDiscoverFileshareFileCopier.class);
    String fileshareFolderName;

    public PromoteToDiscoverFileshareFileCopier(PromoteToDiscoverOperationImplementation operation, String fileshareFolderName) {
        this.operation = operation;
        this.fileshareFolderName = fileshareFolderName;
    }

    @Override
    protected void copyFile(String destinationKey, File sourceFile) throws IOException {
        Path destinationPath = Paths.get(this.fileshareFolderName, destinationKey);
        Path parentFolder = destinationPath.getParent();
        try {
            if (!Files.exists(parentFolder, new LinkOption[0])) {
                Files.createDirectories(parentFolder, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot create parent folder " + String.valueOf(parentFolder), (Throwable)e);
        }
        Files.copy(sourceFile.toPath(), destinationPath, new CopyOption[0]);
    }
}

