/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.PromoteToDiscoverFileCopier;
import com.nuix.automate.workflow.core.execution.operations.PromoteToDiscoverOperationImplementation;
import com.nuix.automate.workflow.core.utils.discover.responses.ImportJob;
import java.io.File;
import java.io.IOException;

public class PromoteToDiscoverS3FileCopier
extends PromoteToDiscoverFileCopier {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PromoteToDiscoverS3FileCopier.class);
    private String bucketName;
    private AmazonS3 s3Client;
    private ImportJob importJob;

    public PromoteToDiscoverS3FileCopier(PromoteToDiscoverOperationImplementation operation, ImportJob importJob, String bucketName, AmazonS3 s3Client) {
        this.operation = operation;
        this.bucketName = bucketName;
        this.s3Client = s3Client;
        this.importJob = importJob;
    }

    @Override
    protected void copyFile(String destinationKey, File sourceFile) throws IOException {
        try {
            PutObjectRequest request = new PutObjectRequest(this.bucketName, this.importJob.getFileTransferLocationInformation().getRootPrefix() + "/" + destinationKey, sourceFile);
            this.s3Client.putObject(request);
        }
        catch (SdkClientException e) {
            throw new IOException(e);
        }
    }
}

