/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.graphapi.Site;
import com.nuix.automate.utils.models.internal.purview.DataSource;
import com.nuix.automate.utils.models.internal.purview.DataSourceType;
import com.nuix.automate.utils.models.internal.purview.NonCustodialDataSource;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.PurviewAddNonCustodialDataSourcesOperation;
import com.nuix.automate.workflow.core.execution.options.purview.DataLocationType;
import com.nuix.automate.workflow.core.execution.options.purview.NonCustodialDataSourceSubmission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.Partitioner;
import org.openimaj.util.parallel.partition.RangePartitioner;

public class PurviewAddNonCustodialDataSourcesOperationImplementation
extends PurviewAddNonCustodialDataSourcesOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewAddNonCustodialDataSourcesOperationImplementation.class);
    private transient String stageName;
    private transient double stageId;
    private transient double stageCount;
    private transient long stageItems;
    private transient AtomicLong processedItems;

    @Override
    public void startTriggered() {
        this.stageCount = 2.0;
        this.stageId = 0.0;
        this.runStartTriggeredThread(() -> {
            List<NonCustodialDataSourceSubmission> nonCustodialDataSources;
            this.initialize();
            this.stageName = this.iu.getString("PurviewAddNonCustodialDataSourcesOperation.Stage.PreparingNoneCustodialDataSources");
            if (this.useNonCustodialDataSourcesFile) {
                this.nonCustodialDataSourcesFileLocation = this.executionContext.evalParameters(this.nonCustodialDataSourcesFileLocation, this);
                this.addExecutionLog(this.iu.getFormattedString("PurviewAddNonCustodialDataSourcesOperation.Log.NonCustodialDataSourcesFile", (Object)this.nonCustodialDataSourcesFileLocation));
                nonCustodialDataSources = this.readNonCustodialDataSourcesFile(this.nonCustodialDataSourcesFileLocation);
            } else {
                nonCustodialDataSources = this.nonCustodialDataSources;
            }
            if (nonCustodialDataSources.isEmpty()) {
                this.addWarning(this.iu.getString("PurviewAddNonCustodialDataSourcesOperation.Log.NoNonCustodialDataSources"));
                return;
            }
            ConcurrentHashMap<String, NonCustodialDataSource> existingNonCustodialDataSources = new ConcurrentHashMap<String, NonCustodialDataSource>();
            for (NonCustodialDataSource nonCustodialDataSource : this.purviewRestClient.getNonCustodialDataSources(this.purviewCaseId)) {
                String value;
                DataSource dataSource = nonCustodialDataSource.getDataSource();
                if (dataSource == null || (value = dataSource.getDataSourceValue()) == null) continue;
                existingNonCustodialDataSources.put(value.trim(), nonCustodialDataSource);
            }
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            this.stageId = 0.5;
            this.stageName = this.iu.getString("PurviewAddNonCustodialDataSourcesOperation.Stage.AddingNonCustodialDataSources");
            this.stageItems = nonCustodialDataSources.size();
            this.processedItems = new AtomicLong();
            AtomicLong dataSourcesAddedCount = new AtomicLong();
            AtomicLong dataSourcesExistCount = new AtomicLong();
            AtomicLong dataSourcesInvalidCount = new AtomicLong();
            AtomicLong failedToAddDataSourcesCount = new AtomicLong();
            ConcurrentHashMap.KeySetView scopeNonCustodialDataSourceIds = ConcurrentHashMap.newKeySet();
            ConcurrentHashMap.KeySetView scopeNonCustodialDataSourceODataIds = ConcurrentHashMap.newKeySet();
            HashSet<String> existingDataSourceValues = new HashSet<String>();
            Iterator<NonCustodialDataSourceSubmission> nonCustodialDataSourceIterator = nonCustodialDataSources.iterator();
            int i = 0;
            while (nonCustodialDataSourceIterator.hasNext()) {
                NonCustodialDataSourceSubmission nonCustodialDataSource = nonCustodialDataSourceIterator.next();
                ++i;
                DataLocationType dataLocationType = nonCustodialDataSource.getType();
                String value = nonCustodialDataSource.getValue();
                boolean invalid = false;
                boolean exists = false;
                if (dataLocationType == null) {
                    this.addWarning(this.iu.getFormattedString("PurviewAddNonCustodialDataSourcesOperation.Warning.InvalidNonCustodialDataSourceType", (Object)i));
                    invalid = true;
                }
                if (value == null || value.trim().isEmpty()) {
                    this.addWarning(this.iu.getFormattedString("PurviewAddNonCustodialDataSourcesOperation.Warning.InvalidNonCustodialDataSourceValue", (Object)i));
                    invalid = true;
                }
                if (invalid) {
                    dataSourcesInvalidCount.getAndIncrement();
                } else if (!existingDataSourceValues.add(value.trim())) {
                    exists = true;
                }
                if (exists) {
                    dataSourcesExistCount.getAndIncrement();
                }
                if (!invalid && !exists) continue;
                nonCustodialDataSourceIterator.remove();
            }
            Parallel.forEachPartitioned((Partitioner)new RangePartitioner(nonCustodialDataSources, this.parallelThreads), iterator -> {
                while (iterator.hasNext()) {
                    NonCustodialDataSourceSubmission nonCustodialDataSourceSubmission = (NonCustodialDataSourceSubmission)iterator.next();
                    String value = nonCustodialDataSourceSubmission.getValue();
                    try {
                        value = value.trim();
                        NonCustodialDataSource existingNonCustodialDataSource = (NonCustodialDataSource)existingNonCustodialDataSources.get(value);
                        if (existingNonCustodialDataSource != null) {
                            dataSourcesExistCount.getAndIncrement();
                            scopeNonCustodialDataSourceODataIds.add(existingNonCustodialDataSource.getODataId());
                            scopeNonCustodialDataSourceIds.add(existingNonCustodialDataSource.getId());
                            continue;
                        }
                        switch (nonCustodialDataSourceSubmission.getType()) {
                            case EXCHANGE_LOCATION: {
                                DataSource exchangeSource = new DataSource();
                                exchangeSource.setSourceType(DataSourceType.USER);
                                exchangeSource.setEmail(value);
                                NonCustodialDataSource nonCustodialUserSource = new NonCustodialDataSource();
                                nonCustodialUserSource.setDataSource(exchangeSource);
                                nonCustodialUserSource = this.purviewRestClient.createNonCustodialDataSource(this.purviewCaseId, nonCustodialUserSource);
                                existingNonCustodialDataSources.put(value, nonCustodialUserSource);
                                scopeNonCustodialDataSourceODataIds.add(nonCustodialUserSource.getODataId());
                                scopeNonCustodialDataSourceIds.add(nonCustodialUserSource.getId());
                                break;
                            }
                            case SHAREPOINT_SITE: {
                                Site site = new Site();
                                site.setWebUrl(value);
                                DataSource siteSource = new DataSource();
                                siteSource.setSourceType(DataSourceType.SITE);
                                siteSource.setSite(site);
                                NonCustodialDataSource nonCustodialSiteSource = new NonCustodialDataSource();
                                nonCustodialSiteSource.setDataSource(siteSource);
                                nonCustodialSiteSource = this.purviewRestClient.createNonCustodialDataSource(this.purviewCaseId, nonCustodialSiteSource);
                                existingNonCustodialDataSources.put(value, nonCustodialSiteSource);
                                scopeNonCustodialDataSourceODataIds.add(nonCustodialSiteSource.getODataId());
                                scopeNonCustodialDataSourceIds.add(nonCustodialSiteSource.getId());
                            }
                        }
                        dataSourcesAddedCount.getAndIncrement();
                    }
                    catch (Exception e) {
                        this.addWarning(this.iu.getFormattedString("PurviewAddNonCustodialDataSourcesOperation.Warning.CannotProcessNonCustodialDataSource", new Object[]{value, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                        failedToAddDataSourcesCount.getAndIncrement();
                    }
                    this.processedItems.getAndIncrement();
                }
            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
            this.addExecutionLog(this.iu.getNumeralString("PurviewAddNonCustodialDataSourcesOperation.Log.AddedNonCustodialDataSources", dataSourcesAddedCount.get()));
            if (dataSourcesExistCount.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewAddNonCustodialDataSourcesOperation.Log.SkippedExistingNonCustodialDataSources", dataSourcesExistCount.get()));
            }
            if (dataSourcesInvalidCount.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewAddNonCustodialDataSourcesOperation.Log.SkippedInvalidNonCustodialDataSources", dataSourcesInvalidCount.get()));
            }
            if (failedToAddDataSourcesCount.get() > 0L) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewAddNonCustodialDataSourcesOperation.Log.FailedToAddNonCustodialDataSources", failedToAddDataSourcesCount.get()));
            }
            this.concatenateToCollectionJson("{purview_non_custodial_data_source_odata_ids}", scopeNonCustodialDataSourceODataIds);
            this.concatenateToCollectionJson("{purview_non_custodial_data_source_ids}", scopeNonCustodialDataSourceIds);
        });
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.processedItems != null && this.stageItems > 0L) {
            stageProgress = (double)this.processedItems.get() / (double)this.stageItems;
        }
        stageProgress *= 1.5;
        double percentageComplete = 0.0;
        if (this.stageCount > 0.0) {
            percentageComplete = (stageProgress + this.stageId) / this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && !this.stageName.isEmpty()) {
            result = (String)result + " / " + this.stageName;
        }
        if (this.stageItems > 0L) {
            if (!((String)result).isEmpty()) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("PurviewAddNonCustodialDataSourcesOperation.Progress.ItemsProcessed", this.processedItems.get());
        }
        return result;
    }
}

