/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphObject;
import com.nuix.automate.utils.models.internal.purview.Custodian;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.models.internal.purview.operations.HoldOperation;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.PurviewApplyHoldToCustodiansOperation;
import com.nuix.automate.workflow.core.execution.options.purview.CustodialDataSourceSubmission;
import com.nuix.automate.workflow.core.execution.options.purview.DataSourceInputType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PurviewApplyHoldToCustodiansOperationImplementation
extends PurviewApplyHoldToCustodiansOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            HoldOperation applyHoldOperation;
            this.initialize();
            this.stageName = this.iu.getString("PurviewApplyHoldToCustodiansOperation.Stage.PreparingCustodians");
            this.percentageComplete = 0.0;
            if (this.inputType == DataSourceInputType.ALL_CASE) {
                applyHoldOperation = this.purviewRestClient.applyHoldToCustodians(this.purviewCaseId, null);
                this.addExecutionLog(this.iu.getString("PurviewApplyHoldToCustodiansOperation.Log.AppliedHoldToAllCustodians"));
            } else {
                int custodiansNotFoundCount;
                List<Custodian> caseCustodians = this.purviewRestClient.getCustodians(this.purviewCaseId);
                HashSet<String> custodianIds = new HashSet<String>();
                switch (this.inputType) {
                    case FILE: {
                        Set custodianEmails = this.readCustodialDataSourcesFile(this.custodiansFileLocation).stream().map(CustodialDataSourceSubmission::getCustodianEmail).collect(Collectors.toSet());
                        for (Custodian caseCustodian : caseCustodians) {
                            String custodianEmail = caseCustodian.getEmail();
                            if (custodianEmail == null || !custodianEmails.remove(custodianEmail = custodianEmail.trim())) continue;
                            custodianIds.add(caseCustodian.getId());
                        }
                        custodiansNotFoundCount = custodianEmails.size();
                        break;
                    }
                    case IDS_JSON: {
                        this.custodianIdsJson = this.executionContext.evalParameters(this.custodianIdsJson, this);
                        custodianIds.addAll((Collection)SerializationUtils.fromJson((String)this.custodianIdsJson));
                        int custodianIdsSize = custodianIds.size();
                        Set caseCustodianIds = caseCustodians.stream().map(MicrosoftGraphObject::getId).collect(Collectors.toSet());
                        custodianIds.retainAll(caseCustodianIds);
                        custodiansNotFoundCount = custodianIdsSize - custodianIds.size();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Data source input type not supported");
                    }
                }
                if (custodiansNotFoundCount > 0) {
                    this.addExecutionLog(this.iu.getNumeralString("PurviewApplyHoldToCustodiansOperation.Log.CustodiansNotFound", (long)custodiansNotFoundCount));
                }
                this.consumptionCustodianIds = new HashSet();
                this.consumptionCustodianIds.addAll(custodianIds);
                if (custodianIds.isEmpty()) {
                    this.addWarning(this.iu.getString("PurviewApplyHoldToCustodiansOperation.Log.NoCustodians"));
                    return;
                }
                applyHoldOperation = this.purviewRestClient.applyHoldToCustodians(this.purviewCaseId, custodianIds);
                this.addExecutionLog(this.iu.getNumeralString("PurviewApplyHoldToCustodiansOperation.Log.AppliedHoldToCustodians", (long)custodianIds.size()));
            }
            this.stageName = this.iu.getString("PurviewApplyHoldToCustodiansOperation.Stage.ApplyingHold");
            this.percentageComplete = 0.2;
            if (applyHoldOperation != null) {
                this.addExecutionLog(this.iu.getFormattedString("PurviewApplyHoldToCustodiansOperation.Log.HoldOperationId", (Object)applyHoldOperation.getId()));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_apply_hold_to_custodians_job_id}", applyHoldOperation.getId())));
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                if (this.waitForCompletion) {
                    this.waitForOperationToComplete((CaseOperation)applyHoldOperation);
                }
            } else {
                this.addExecutionLog(this.iu.getString("PurviewApplyHoldToCustodiansOperation.Log.HoldOperationNotCreated"));
            }
        });
    }
}

