/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.PurviewService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyRestException;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.graphapi.User;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryCase;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.PurviewConfigureConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.ThirdPartyServiceOperation;
import com.nuix.automate.workflow.core.utils.thirdparty.ThirdPartyUtils;
import java.util.List;
import java.util.Map;

public class PurviewConfigureConnectionOperationImplementation
extends PurviewConfigureConnectionOperation
implements ThirdPartyServiceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewConfigureConnectionOperation.class);
    private transient Map<String, ThirdPartyService> thirdPartyServices;

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            block3: {
                ThirdPartyUtils.getInstance().verifyThirdPartyServiceSettings(this, this.thirdPartyServices.values(), PurviewService.class.getSimpleName(), ParameterType.PURVIEW_SERVICE);
                this.stageName = this.iu.getString("PurviewConfigureConnectionOperation.Stage.InitializingRestClient");
                this.purviewServiceId = this.executionContext.evalParameters(this.purviewServiceId, this);
                PurviewService purviewService = (PurviewService)this.thirdPartyServices.get(this.purviewServiceId);
                if (purviewService == null) {
                    throw new ThirdPartyRestException(this.iu.getFormattedString("PurviewConfigureConnectionOperation.Prerequisites.MissingPurviewServiceId", new Object[0]));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_service_id}", this.purviewServiceId)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_whitelisted_cert_fingerprints}", SerializationUtils.toJson((Object)purviewService.getWhitelistedCertFingerprints()))));
                this.initializePurviewRestClient();
                this.stageName = this.iu.getString("PurviewConfigureConnectionOperation.Stage.TestingRestClient");
                this.percentageComplete = 0.3;
                try {
                    User delegatedUser = this.purviewRestClient.getDelegatedUser();
                    this.addExecutionLog(this.iu.getFormattedString("PurviewConfigureConnectionOperation.Log.eDiscoveryManager", new Object[]{delegatedUser.getDisplayName(), delegatedUser.getUserPrincipalName()}));
                }
                catch (Exception e) {
                    LOGGER.error("Error querying for delegated user (/me endpoint)", (Throwable)e);
                    ThirdPartyUserCredential userCredential = purviewService.getUserCredential();
                    if (userCredential == null) break block3;
                    this.addExecutionLog(this.iu.getFormattedString("PurviewConfigureConnectionOperation.Log.eDiscoveryManagerUsername", (Object)userCredential.getUsername()));
                }
            }
            this.percentageComplete = 0.6;
            List<EDiscoveryCase> purviewCases = this.purviewRestClient.getCases();
            this.addExecutionLog(this.iu.getNumeralString("PurviewConfigureConnectionOperation.Log.FoundEDiscoveryCases", (long)purviewCases.size()));
        });
    }

    @Override
    public void setThirdPartyServices(Map<String, ThirdPartyService> thirdPartyServices) {
        this.thirdPartyServices = thirdPartyServices;
    }
}

