/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSet;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSetQuery;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.PurviewDeleteReviewSetQueryOperation;
import com.nuix.automate.workflow.core.utils.purview.PurviewObjectDoesNotExistException;
import com.nuix.automate.workflow.core.utils.purview.PurviewOperationException;

public class PurviewDeleteReviewSetQueryOperationImplementation
extends PurviewDeleteReviewSetQueryOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.reviewSetIdentifier = this.executionContext.evalParameters(this.reviewSetIdentifier, this);
            this.reviewSetQueryIdentifier = this.executionContext.evalParameters(this.reviewSetQueryIdentifier, this);
            this.stageName = this.iu.getString("PurviewDeleteReviewSetQueryOperation.Stage.GettingReviewSet");
            this.percentageComplete = 0.1;
            EDiscoveryReviewSet reviewSet = this.getReviewSet(this.reviewSetIdentifierType, this.reviewSetIdentifier);
            this.stageName = this.iu.getString("PurviewDeleteReviewSetQueryOperation.Stage.DeletingQuery");
            this.percentageComplete = 0.4;
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_review_set_query_deleted}", String.valueOf(false))));
            EDiscoveryReviewSetQuery reviewSetQuery = null;
            try {
                switch (this.reviewSetQueryIdentifierType) {
                    case ID: {
                        reviewSetQuery = this.purviewRestClient.getReviewSetQueryForId(this.purviewCaseId, reviewSet.getId(), this.reviewSetQueryIdentifier);
                        break;
                    }
                    case NAME: {
                        reviewSetQuery = this.purviewRestClient.getReviewSetQueryForName(this.purviewCaseId, reviewSet.getId(), this.reviewSetQueryIdentifier);
                        break;
                    }
                    case NAME_REGEX: {
                        reviewSetQuery = this.purviewRestClient.getReviewSetQueryForNameRegex(this.purviewCaseId, reviewSet.getId(), this.reviewSetQueryIdentifier);
                    }
                }
                this.addExecutionLog(this.iu.getFormattedString("PurviewOperation.Log.FoundExistingReviewSetQuery", new Object[]{reviewSetQuery.getDisplayName(), reviewSetQuery.getId()}));
            }
            catch (PurviewObjectDoesNotExistException e) {
                String errorMessage = this.iu.getFormattedString("PurviewOperation.Error.CannotFindReviewSetQueryWith" + this.reviewSetQueryIdentifierType.name(), (Object)this.reviewSetQueryIdentifier);
                throw new PurviewOperationException(errorMessage);
            }
            this.purviewRestClient.deleteReviewSetQuery(this.purviewCaseId, reviewSet.getId(), reviewSetQuery.getId());
            this.addExecutionLog(this.iu.getFormattedString("PurviewDeleteReviewSetQueryOperation.Log.DeletedQuery", new Object[0]));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_review_set_query_deleted}", String.valueOf(true))));
        });
    }
}

