/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.purview.ReviewSetExportStructure;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.PurviewOperation;
import com.nuix.automate.workflow.core.execution.operations.PurviewUseCaseOperation;
import com.nuix.automate.workflow.core.execution.options.purview.PurviewIdentifierType;
import java.util.List;

@FormFieldRow(name="reviewSetIdentifierRow", children={"reviewSetIdentifierType", "reviewSetIdentifier"})
@FormFieldGroup(name="exportOptionsGroup", children={"tags", "text", "originalFiles", "pdfReplacement"})
@OperationMetadata(alias=OperationAlias.PURVIEW_EXPORT_REVIEW_SET, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"MICROSOFT_PURVIEW"}), @OperationTag(name="Category", value={"EXPORT"})})
@OperationLicenseModule(module=ModuleType.PURVIEW_COLLECTIONS)
public class PurviewExportReviewSetOperation
extends PurviewOperation {
    @FormField
    public PurviewIdentifierType reviewSetIdentifierType = PurviewIdentifierType.ID;
    @FormField
    public String reviewSetIdentifier = "{purview_review_set_id}";
    public boolean exportReviewSetQuery = false;
    @FormField
    public String exportName;
    @FormField(componentType=FieldComponentType.TEXTAREA, required=false)
    @ExcludeFromPrintableOptions
    public String exportDescription;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    public ReviewSetExportStructure exportStructure = ReviewSetExportStructure.MSG;
    @FormField
    public boolean tags;
    @FormField(enableOn={@OnField(name="exportStructure", value={"CONDENSED_DIRECTORY", "LOOSE_FILES_AND_PST", "MSG"})})
    public boolean text;
    @FormField(enableOn={@OnField(name="exportStructure", value={"CONDENSED_DIRECTORY", "LOOSE_FILES_AND_PST", "MSG"})})
    public boolean originalFiles;
    @FormField(enableOn={@OnField(name="exportStructure", value={"CONDENSED_DIRECTORY", "LOOSE_FILES_AND_PST", "MSG"})})
    public boolean pdfReplacement;
    @FormField(enableOn={@OnField(name="exportStructure", value={"MSG", "LOOSE_FILES_AND_PST"})})
    public boolean splitSource;
    @FormField(enableOn={@OnField(name="exportStructure", value={"MSG", "LOOSE_FILES_AND_PST"})})
    public boolean includeFolderAndPath;
    @FormField(enableOn={@OnField(name="exportStructure", value={"MSG", "LOOSE_FILES_AND_PST"})})
    public boolean friendlyName;
    @FormField(enableOn={@OnField(name="exportStructure", value={"MSG", "LOOSE_FILES_AND_PST"})})
    public boolean condensePaths;
    @FormField
    public boolean waitForCompletion = true;

    @Override
    public String getOperationName() {
        return this.iu.getString("PurviewExportReviewSetOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (!this.enableFieldOverwrite) {
            if (this.reviewSetIdentifierType == null || this.reviewSetIdentifier == null || this.reviewSetIdentifier.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("PurviewExportReviewSetOperation.Prerequisites.ReviewSetIdentifierRequired"));
            }
            if (this.exportReviewSetQuery) {
                prerequisites.add(this.iu.getString("PurviewExportReviewSetOperation.Error.ExportReviewSetQueryDeprecated"));
            }
            if (this.exportName == null || this.exportName.trim().isEmpty()) {
                prerequisites.add(this.iu.getString("PurviewExportReviewSetOperation.Prerequisites.ExportNameRequired"));
            }
        }
        prerequisites.addAll(this.getMissingRequiredOperations(PurviewUseCaseOperation.class));
        return prerequisites;
    }
}

