/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSet;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSetExport;
import com.nuix.automate.utils.models.internal.purview.ReviewSetExportStructure;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.models.internal.purview.operations.ExportOperation;
import com.nuix.automate.utils.models.internal.purview.operations.ReviewSetExportOperation;
import com.nuix.automate.workflow.core.execution.operations.PurviewExportReviewSetOperation;
import com.nuix.automate.workflow.core.utils.purview.PurviewOperationException;
import java.util.ArrayList;

public class PurviewExportReviewSetOperationImplementation
extends PurviewExportReviewSetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewExportReviewSetOperation.class);

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.reviewSetIdentifier = this.executionContext.evalParameters(this.reviewSetIdentifier, this);
            this.exportName = this.executionContext.evalParameters(this.exportName, this);
            this.exportDescription = this.executionContext.evalParameters(this.exportDescription, this);
            this.stageName = this.iu.getString("PurviewExportReviewSetOperation.Stage.GettingReviewSet");
            this.percentageComplete = 0.1;
            EDiscoveryReviewSet reviewSet = this.getReviewSet(this.reviewSetIdentifierType, this.reviewSetIdentifier);
            if (this.exportReviewSetQuery) {
                throw new PurviewOperationException(this.iu.getString("PurviewExportReviewSetOperation.Error.ExportReviewSetQueryDeprecated"));
            }
            EDiscoveryReviewSetExport export = new EDiscoveryReviewSetExport();
            export.setOutputName(this.exportName);
            export.setDescription(this.exportDescription);
            export.setExportStructure(this.exportStructure.toString());
            ArrayList<String> exportOptions = new ArrayList<String>();
            if (this.tags) {
                exportOptions.add("tags");
            }
            if (this.exportStructure != ReviewSetExportStructure.NONE) {
                if (this.text) {
                    exportOptions.add("text");
                }
                if (this.originalFiles) {
                    exportOptions.add("originalFiles");
                }
                if (this.pdfReplacement) {
                    exportOptions.add("pdfReplacement");
                }
            }
            if (this.exportStructure == ReviewSetExportStructure.MSG || this.exportStructure == ReviewSetExportStructure.LOOSE_FILES_AND_PST) {
                if (this.splitSource) {
                    exportOptions.add("splitSource");
                }
                if (this.includeFolderAndPath) {
                    exportOptions.add("includeFolderAndPath");
                }
                if (this.friendlyName) {
                    exportOptions.add("friendlyName");
                }
                if (this.condensePaths) {
                    exportOptions.add("condensePaths");
                }
            }
            export.setExportOptions(String.join((CharSequence)",", exportOptions));
            this.stageName = this.iu.getString("PurviewExportReviewSetOperation.Stage.Exporting");
            this.percentageComplete = 0.2;
            ReviewSetExportOperation exportOperation = this.purviewRestClient.exportReviewSet(this.purviewCaseId, reviewSet.getId(), export);
            this.addExecutionLog(this.iu.getFormattedString("PurviewExportReviewSetOperation.Log.ExportOperationId", (Object)exportOperation.getId()));
            if (this.waitForCompletion) {
                exportOperation = (ReviewSetExportOperation)this.waitForOperationToComplete((CaseOperation)exportOperation);
            }
            this.setExportOperationBuiltInParameters((ExportOperation)exportOperation);
        });
    }
}

