/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryCase;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryCaseStatus;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryHoldPolicy;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryHoldPolicyStatus;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.PurviewManageCaseOperation;
import com.nuix.automate.workflow.core.execution.options.purview.ManageCaseAction;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PurviewManageCaseOperationImplementation
extends PurviewManageCaseOperation {
    private static final Set<EDiscoveryCaseStatus> closedCaseStatuses = new HashSet<EDiscoveryCaseStatus>(Arrays.asList(EDiscoveryCaseStatus.CLOSING, EDiscoveryCaseStatus.CLOSED, EDiscoveryCaseStatus.CLOSED_WITH_ERROR));

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.pollingTimeout = Math.max(30, this.pollingTimeout);
            EDiscoveryCaseStatus purviewCaseStatus = EDiscoveryCaseStatus.forValue((String)this.executionContext.evalParameters("{purview_case_status}", this));
            if (purviewCaseStatus == null) {
                purviewCaseStatus = EDiscoveryCaseStatus.UNKNOWN;
            }
            this.addExecutionLog(this.iu.getFormattedString("PurviewManageCaseOperation.Log.ManageCaseAction", (Object)this.manageCaseAction.toLocalizedString()));
            if (this.manageCaseAction == ManageCaseAction.REOPEN) {
                if (purviewCaseStatus == EDiscoveryCaseStatus.ACTIVE) {
                    this.addExecutionLog(this.iu.getString("PurviewManageCaseOperation.Log.CaseAlreadyOpen"));
                } else {
                    this.stageName = this.iu.getString("PurviewManageCaseOperation.Stage.ReopeningCase");
                    this.purviewRestClient.reopenCase(this.purviewCaseId);
                    this.addExecutionLog(this.iu.getString("PurviewManageCaseOperation.Log.Reopened"));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_case_reopened}", String.valueOf(true))));
            } else if (this.manageCaseAction == ManageCaseAction.CLOSE || this.manageCaseAction == ManageCaseAction.DELETE) {
                if (purviewCaseStatus == EDiscoveryCaseStatus.PENDING_DELETE || closedCaseStatuses.contains(purviewCaseStatus)) {
                    if (this.manageCaseAction == ManageCaseAction.CLOSE) {
                        this.addExecutionLog(this.iu.getString("PurviewManageCaseOperation.Log.CaseAlreadyClosed"));
                    }
                } else {
                    EDiscoveryCase purviewCase;
                    this.stageName = this.iu.getString("PurviewManageCaseOperation.Stage.ClosingCase");
                    int closeAttempts = 0;
                    while (true) {
                        try {
                            ++closeAttempts;
                            this.purviewRestClient.closeCase(this.purviewCaseId);
                        }
                        catch (IOException e) {
                            if (closeAttempts <= 3 && e.getMessage() != null && e.getMessage().contains("failed")) {
                                Thread.sleep((long)this.operationPollingDelay * 1000L);
                                continue;
                            }
                            if (e.getMessage() != null && e.getMessage().contains("already closed or getting deleted")) break;
                            throw e;
                        }
                        break;
                    }
                    Thread.sleep(60000L);
                    long caseCloseTimeoutEpochMillis = System.currentTimeMillis() + (long)(this.pollingTimeout * 60) * 1000L;
                    do {
                        if (System.currentTimeMillis() > caseCloseTimeoutEpochMillis) {
                            this.addWarning(this.iu.getFormattedString("PurviewManageCaseOperation.Warning.TimedOutClosingCase", (Object)this.pollingTimeout));
                            break;
                        }
                        Thread.sleep((long)this.operationPollingDelay * 1000L);
                    } while ((purviewCaseStatus = (purviewCase = this.purviewRestClient.getCaseForId(this.purviewCaseId)).getStatus()) == EDiscoveryCaseStatus.CLOSING || !closedCaseStatuses.contains(purviewCaseStatus));
                    this.addExecutionLog(this.iu.getString("PurviewManageCaseOperation.Log.ClosedCase"));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_case_status}", purviewCaseStatus.getValue())));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_case_closed}", String.valueOf(true))));
            }
            if (this.manageCaseAction == ManageCaseAction.DELETE) {
                if (purviewCaseStatus == EDiscoveryCaseStatus.PENDING_DELETE) {
                    this.addExecutionLog(this.iu.getString("PurviewManageCaseOperation.Log.CasePendingDelete"));
                } else {
                    this.percentageComplete = 0.4;
                    List<EDiscoveryHoldPolicy> holdPolicies = this.purviewRestClient.getHoldPolicies(this.purviewCaseId);
                    this.addExecutionLog(this.iu.getNumeralString("PurviewManageCaseOperation.Log.FoundHoldPolicies", (long)holdPolicies.size()));
                    if (!holdPolicies.isEmpty()) {
                        this.stageName = this.iu.getString("PurviewManageCaseOperation.Stage.DeletingHoldPolicies");
                        HashSet<String> holdPolicyIdsPendingDelete = new HashSet<String>();
                        int holdPoliciesDeletedCount = 0;
                        int holdPoliciesFailedToDeleteCount = 0;
                        for (EDiscoveryHoldPolicy holdPolicy : holdPolicies) {
                            try {
                                this.purviewRestClient.deleteHoldPolicy(this.purviewCaseId, holdPolicy.getId());
                                ++holdPoliciesDeletedCount;
                                holdPolicyIdsPendingDelete.add(holdPolicy.getId());
                            }
                            catch (Exception e) {
                                this.addWarning(this.iu.getFormattedString("PurviewManageCaseOperation.Warning.CouldNotDeleteHoldPolicy", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                                ++holdPoliciesFailedToDeleteCount;
                            }
                        }
                        this.stageName = this.iu.getString("PurviewManageCaseOperation.Stage.WaitingForHoldPoliciesDelete");
                        this.percentageComplete = 0.6;
                        long holdPolicyDeleteTimeoutEpochMillis = System.currentTimeMillis() + (long)(this.pollingTimeout * 60) * 1000L;
                        while (!holdPolicyIdsPendingDelete.isEmpty()) {
                            if (System.currentTimeMillis() > holdPolicyDeleteTimeoutEpochMillis) {
                                this.addWarning(this.iu.getFormattedString("PurviewManageCaseOperation.Warning.TimedOutDeletingHoldPolicies", (Object)this.pollingTimeout));
                                holdPoliciesFailedToDeleteCount += holdPolicyIdsPendingDelete.size();
                                break;
                            }
                            Thread.sleep((long)this.operationPollingDelay * 1000L);
                            HashSet<String> holdPolicyIds = new HashSet<String>();
                            for (EDiscoveryHoldPolicy holdPolicy : this.purviewRestClient.getHoldPolicies(this.purviewCaseId)) {
                                if (holdPolicy.getStatus() == EDiscoveryHoldPolicyStatus.ERROR && holdPolicyIdsPendingDelete.remove(holdPolicy.getId())) {
                                    String errors = String.join((CharSequence)"\n", holdPolicy.getErrors());
                                    this.addWarning(this.iu.getFormattedString("PurviewManageCaseOperation.Warning.ErrorDeletingHoldPolicy", new Object[]{holdPolicy.getDisplayName(), holdPolicy.getId(), errors}));
                                    continue;
                                }
                                holdPolicyIds.add(holdPolicy.getId());
                            }
                            holdPolicyIdsPendingDelete.retainAll(holdPolicyIds);
                        }
                        if (holdPoliciesDeletedCount > 0) {
                            this.addExecutionLog(this.iu.getNumeralString("PurviewManageCaseOperation.Log.DeletedHoldPolicies", (long)holdPoliciesDeletedCount));
                        }
                        if (holdPoliciesFailedToDeleteCount > 0) {
                            this.addExecutionLog(this.iu.getNumeralString("PurviewManageCaseOperation.Log.FailedToDeleteHoldPolicies", (long)holdPoliciesFailedToDeleteCount));
                        }
                    }
                    this.stageName = this.iu.getString("PurviewManageCaseOperation.Stage.DeletingCase");
                    this.percentageComplete = 0.8;
                    this.purviewRestClient.deleteCase(this.purviewCaseId);
                    this.addExecutionLog(this.iu.getString("PurviewManageCaseOperation.Log.DeletedCase"));
                }
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_case_deleted}", String.valueOf(true))));
            }
        });
    }
}

