/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyRestException;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSet;
import com.nuix.automate.utils.models.internal.purview.EDiscoverySearch;
import com.nuix.automate.utils.models.internal.purview.ResultInfo;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperationStatus;
import com.nuix.automate.utils.models.internal.purview.operations.ExportOperation;
import com.nuix.automate.utils.models.internal.purview.operations.ReviewSetExportOperation;
import com.nuix.automate.utils.models.internal.purview.operations.SearchExportOperation;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.purview.CustodialDataSourceSubmission;
import com.nuix.automate.workflow.core.execution.options.purview.DataLocationType;
import com.nuix.automate.workflow.core.execution.options.purview.NonCustodialDataSourceSubmission;
import com.nuix.automate.workflow.core.execution.options.purview.PurviewIdentifierType;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.utils.general.OperationRunnable;
import com.nuix.automate.workflow.core.utils.purview.PurviewObjectDoesNotExistException;
import com.nuix.automate.workflow.core.utils.purview.PurviewOperationException;
import com.nuix.automate.workflow.core.utils.purview.PurviewRestClient;
import com.nuix.automate.workflow.core.utils.purview.PurviewRestException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class PurviewOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewOperation.class);
    protected transient String purviewCaseId;
    protected transient PurviewRestClient purviewRestClient;
    protected transient int operationPollingDelay;
    protected transient int parallelThreads;
    protected transient String stageName;
    protected transient double percentageComplete;

    public PurviewOperation() {
        this.requiresCase = false;
        this.operationPollingDelay = SystemUtils.getIntegerProperty((String)"automate.purview.operationPollingDelay", (Integer)15);
        this.parallelThreads = SystemUtils.getIntegerProperty((String)"automate.purview.parallelThreads", (Integer)4);
    }

    protected void initialize() throws ParameterException, GeneralSecurityException {
        this.purviewCaseId = this.executionContext.evalParameters("{purview_case_id}", this);
        this.initializePurviewRestClient();
    }

    protected void initializePurviewRestClient() throws ParameterException, GeneralSecurityException {
        String purviewServiceId = this.executionContext.evalParametersIfSet("{purview_service_id}", this);
        String schedulerUrl = this.executionContext.evalParametersIfSet("{scheduler_url}", this).trim();
        String bearerToken = this.executionContext.evalProtectedParameter("{job_bearer_token_protected}").trim();
        HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
        try {
            whitelistedCertFingerprints.addAll((Collection)SerializationUtils.fromJson((String)this.executionContext.evalParameters("{purview_whitelisted_cert_fingerprints}", this)));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        try {
            whitelistedCertFingerprints.add(this.executionContext.evalParametersIfSet("{scheduler_cert_fingerprint}", this).trim());
        }
        catch (ParameterException e) {
            LOGGER.info("Not using custom Scheduler cert fingerprint", (Throwable)e);
        }
        this.purviewRestClient = new PurviewRestClient(purviewServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
        this.purviewRestClient.setOperation(this);
    }

    @Override
    protected void runStartTriggeredThread(OperationRunnable operationRunnable) {
        this.startTriggerThread = new Thread(() -> {
            try {
                operationRunnable.run();
                this.trackFinished();
            }
            catch (ThirdPartyRestException | PurviewOperationException e) {
                LOGGER.error("Error during " + this.getOperationName(), e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    protected EDiscoverySearch getSearch(PurviewIdentifierType identifierType, String identifier) throws IOException {
        return this.getSearch(identifierType, identifier, false);
    }

    protected EDiscoverySearch getSearch(PurviewIdentifierType identifierType, String identifier, boolean throwObjectDoesNotExist) throws IOException {
        EDiscoverySearch search = null;
        try {
            switch (identifierType) {
                case ID: {
                    search = this.purviewRestClient.getSearchForId(this.purviewCaseId, identifier);
                    break;
                }
                case NAME: {
                    search = this.purviewRestClient.getSearchForName(this.purviewCaseId, identifier);
                    break;
                }
                case NAME_REGEX: {
                    search = this.purviewRestClient.getSearchForNameRegex(this.purviewCaseId, identifier);
                }
            }
            if (search != null) {
                this.addExecutionLog(this.iu.getFormattedString("PurviewOperation.Log.FoundExistingSearch", new Object[]{search.getDisplayName(), search.getId()}));
            }
            return search;
        }
        catch (PurviewObjectDoesNotExistException e) {
            if (throwObjectDoesNotExist) {
                throw e;
            }
            String errorMessage = this.iu.getFormattedString("PurviewOperation.Error.CannotFindSearchWith" + identifierType.name(), (Object)identifier);
            throw new PurviewOperationException(errorMessage);
        }
    }

    protected EDiscoveryReviewSet getReviewSet(PurviewIdentifierType identifierType, String identifier) throws IOException {
        return this.getReviewSet(identifierType, identifier, false);
    }

    protected EDiscoveryReviewSet getReviewSet(PurviewIdentifierType identifierType, String identifier, boolean throwObjectDoesNotExist) throws IOException {
        EDiscoveryReviewSet reviewSet = null;
        try {
            switch (identifierType) {
                case ID: {
                    reviewSet = this.purviewRestClient.getReviewSetForId(this.purviewCaseId, identifier);
                    break;
                }
                case NAME: {
                    reviewSet = this.purviewRestClient.getReviewSetForName(this.purviewCaseId, identifier);
                    break;
                }
                case NAME_REGEX: {
                    reviewSet = this.purviewRestClient.getReviewSetForNameRegex(this.purviewCaseId, identifier);
                }
            }
            if (reviewSet != null) {
                this.addExecutionLog(this.iu.getFormattedString("PurviewOperation.Log.FoundExistingReviewSet", new Object[]{reviewSet.getDisplayName(), reviewSet.getId()}));
            }
            return reviewSet;
        }
        catch (PurviewObjectDoesNotExistException e) {
            if (throwObjectDoesNotExist) {
                throw e;
            }
            String errorMessage = this.iu.getFormattedString("PurviewOperation.Error.CannotFindReviewSetWith" + identifierType.name(), (Object)identifier);
            throw new PurviewOperationException(errorMessage);
        }
    }

    protected ExportOperation getExportJob(PurviewIdentifierType identifierType, String identifier) throws IOException {
        ConcurrentLinkedQueue<ExportOperation> exportOperations = new ConcurrentLinkedQueue<ExportOperation>();
        Pattern namePattern = null;
        if (identifierType == PurviewIdentifierType.NAME_REGEX) {
            namePattern = Pattern.compile(identifier);
        }
        block11: for (CaseOperation caseOperation : this.purviewRestClient.getCaseOperations(this.purviewCaseId)) {
            if (caseOperation.getAction() == null) continue;
            try {
                Class<ReviewSetExportOperation> exportOperationClazz;
                switch (caseOperation.getAction()) {
                    case CONTENT_EXPORT: {
                        exportOperationClazz = ReviewSetExportOperation.class;
                        break;
                    }
                    case EXPORT_RESULT: {
                        exportOperationClazz = SearchExportOperation.class;
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                ExportOperation export = (ExportOperation)this.purviewRestClient.getCaseOperation(this.purviewCaseId, caseOperation.getId(), exportOperationClazz);
                switch (identifierType) {
                    case ID: {
                        if (export.getId().equals(identifier)) {
                            return export;
                        }
                    }
                    case NAME: {
                        if (!export.getOutputName().equals(identifier)) break;
                        exportOperations.add(export);
                        break;
                    }
                    case NAME_REGEX: {
                        if (!namePattern.matcher(export.getOutputName()).find()) break;
                        exportOperations.add(export);
                    }
                }
            }
            catch (Exception e) {
                this.addWarning("Could not get exportJob " + caseOperation.getId() + " for case " + this.purviewCaseId);
            }
        }
        if (exportOperations.size() > 1) {
            String errorMessageKey = identifierType == PurviewIdentifierType.NAME ? "PurviewRestClient.Error.MultipleExportJobsWithName" : "PurviewRestClient.Error.MultipleExportJobsMatchingRegex";
            throw new PurviewRestException(this.iu.getFormattedString(errorMessageKey, new Object[]{exportOperations.size(), identifier}));
        }
        return (ExportOperation)exportOperations.poll();
    }

    protected void setExportOperationBuiltInParameters(ExportOperation exportOperation) {
        try {
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_export_job_id}", exportOperation.getId())));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_container_url}", "")));
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_sas_token_protected}", "")));
        }
        catch (Exception e) {
            LOGGER.error("Could not get download URL for export job: " + exportOperation.getId(), (Throwable)e);
        }
    }

    protected List<NonCustodialDataSourceSubmission> readNonCustodialDataSourcesFile(String fileLocation) throws IOException {
        Path nonCustodialDataSourcesFilePath = Paths.get(fileLocation, new String[0]);
        if (!Files.exists(nonCustodialDataSourcesFilePath, new LinkOption[0])) {
            String errorMessage = this.iu.getFormattedString("PurviewOperation.Error.NonCustodialDataSourcesFileDoesNotExist", (Object)fileLocation);
            throw new PurviewOperationException(errorMessage);
        }
        ArrayList<NonCustodialDataSourceSubmission> nonCustodialDataSources = new ArrayList<NonCustodialDataSourceSubmission>();
        List dataSourceLines = FileUtils.loadVariableColumnDetectFormatFile((File)nonCustodialDataSourcesFilePath.toFile());
        int startIndex = 0;
        int valueIndex = 0;
        int typeIndex = -1;
        if (!dataSourceLines.isEmpty()) {
            String firstValue;
            Object[] line = (Object[])dataSourceLines.get(0);
            if (line.length > 0 && ((firstValue = ((String)line[0]).toLowerCase()).contains("value") || firstValue.contains("type")) && !firstValue.contains("http") && !firstValue.contains("@")) {
                startIndex = 1;
            }
            Object[] valueLine = (Object[])dataSourceLines.get(startIndex);
            if (line.length > 1) {
                try {
                    if (NonCustodialDataSourceSubmission.normalizeType((String)valueLine[0]) != null) {
                        typeIndex = 0;
                        valueIndex = 1;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        LOGGER.info("Detected non-custodial data sources file with startIndex " + startIndex + " and valueColumn " + valueIndex);
        for (int i = startIndex; i < dataSourceLines.size(); ++i) {
            Object[] dataSourceLine = (Object[])dataSourceLines.get(i);
            String value = (String)dataSourceLine[valueIndex];
            DataLocationType type = null;
            if (typeIndex == 0) {
                type = NonCustodialDataSourceSubmission.normalizeType((String)dataSourceLine[0]);
            }
            nonCustodialDataSources.add(new NonCustodialDataSourceSubmission(type, value));
        }
        return nonCustodialDataSources;
    }

    protected List<CustodialDataSourceSubmission> readCustodialDataSourcesFile(String fileLocation) throws IOException {
        Object[] line;
        Path custodialDataSourcesFilePath = Paths.get(fileLocation, new String[0]);
        if (!Files.exists(custodialDataSourcesFilePath, new LinkOption[0])) {
            String errorMessage = this.iu.getFormattedString("PurviewOperation.Error.CustodialDataSourcesFileDoesNotExist", (Object)fileLocation);
            throw new PurviewOperationException(errorMessage);
        }
        ArrayList<CustodialDataSourceSubmission> custodialDataSources = new ArrayList<CustodialDataSourceSubmission>();
        List dataSourceLines = FileUtils.loadVariableColumnDetectFormatFile((File)custodialDataSourcesFilePath.toFile());
        int startIndex = 0;
        if (!dataSourceLines.isEmpty() && (line = (Object[])dataSourceLines.get(0)).length > 0) {
            String firstValue = (String)line[0];
            if (firstValue.toLowerCase().startsWith("custodian") && !firstValue.contains("@")) {
                startIndex = 1;
            } else if (line.length > 1) {
                try {
                    if (CustodialDataSourceSubmission.normalizeType((String)line[1]) == null) {
                        startIndex = 1;
                    }
                }
                catch (IllegalArgumentException e) {
                    startIndex = 1;
                }
            }
        }
        LOGGER.info("Detected custodial data sources file with startIndex " + startIndex);
        for (int i = startIndex; i < dataSourceLines.size(); ++i) {
            custodialDataSources.add(CustodialDataSourceSubmission.build((Object[])dataSourceLines.get(i)));
        }
        return custodialDataSources;
    }

    @Override
    public String getOperationName() {
        String className = this.getClass().getSimpleName().replace("Implementation", "");
        return this.iu.getString(className + ".Property.Name");
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        return new HashSet<Feature>();
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && !this.stageName.isEmpty()) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    protected CaseOperation waitForOperationToComplete(CaseOperation caseOperation) throws IOException, InterruptedException {
        CaseOperationHandler caseOperationHandler = new CaseOperationHandler();
        double startingPercentage = Math.min(this.percentageComplete, 0.6);
        double remainingPercentage = Math.max(0.4, 1.0 - startingPercentage);
        do {
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            Thread.sleep((long)this.operationPollingDelay * 1000L);
            caseOperation = this.purviewRestClient.getCaseOperation(this.purviewCaseId, caseOperation.getId(), caseOperation.getClass());
            this.percentageComplete = startingPercentage + remainingPercentage * ((double)caseOperation.getPercentProgress().intValue() / 100.0);
        } while (caseOperationHandler.checkProgress((CaseOperation)caseOperation));
        return caseOperation;
    }

    @Override
    protected List<String> getMissingRequiredOperations(Class<?> ... requiredOperations) {
        ArrayList requiredClasses = new ArrayList(Arrays.asList(requiredOperations));
        for (Operation operation : this.executionContext.workflowExecution.getWorkflow().getOperations()) {
            requiredClasses.removeIf(clazz -> clazz.isAssignableFrom(operation.getClass()) && !operation.disabled);
            if (operation != this && !requiredClasses.isEmpty()) continue;
            break;
        }
        return requiredClasses.stream().map(clazz -> this.iu.getString("PurviewOperation.Prerequisites.Missing" + clazz.getSimpleName())).collect(Collectors.toList());
    }

    private final class CaseOperationHandler {
        private CaseOperationStatus previousOperationStatus;
        private DateTime lastPercentChange;
        private Integer lastPercent;
        private Long lastFrozenWarning;
        private String lastFrozenWarningMessage;

        private CaseOperationHandler() {
        }

        public boolean checkProgress(CaseOperation caseOperation) {
            LOGGER.info(PurviewOperation.this.getOperationName() + ": " + caseOperation.getAction().toLocalizedString() + " - " + caseOperation.getStatus().toLocalizedString() + " " + caseOperation.getPercentProgress() + "%");
            DateTime currentDateTime = DateTime.now((DateTimeZone)DateTimeZone.UTC);
            long currentMillis = currentDateTime.getMillis();
            if (caseOperation.getPercentProgress().equals(this.lastPercent)) {
                long secondsWithoutChange = (currentMillis - (this.lastFrozenWarning == null ? this.lastPercentChange.getMillis() : this.lastFrozenWarning.longValue())) / 1000L;
                if (secondsWithoutChange > 10800L) {
                    Object[] formattingValues = new Object[]{caseOperation.getPercentProgress(), FormattingUtils.dateTimeToLocalString((DateTime)this.lastPercentChange)};
                    this.lastFrozenWarningMessage = PurviewOperation.this.iu.getFormattedString("PurviewOperation.CaseOperationHandler.DetectedFrozenOperationProgress", formattingValues);
                    PurviewOperation.this.addTransientWarning(this.lastFrozenWarningMessage, false);
                    this.lastFrozenWarning = currentMillis;
                }
            } else {
                this.resolveLastFrozenTransientWarning();
                this.lastPercent = caseOperation.getPercentProgress();
                this.lastPercentChange = currentDateTime;
            }
            boolean running = true;
            if (caseOperation.getStatus() != this.previousOperationStatus) {
                this.previousOperationStatus = caseOperation.getStatus();
                String statusLog = caseOperation.getAction().toLocalizedString() + ": " + caseOperation.getStatus().toLocalizedString();
                if (!caseOperation.isRunning()) {
                    this.resolveLastFrozenTransientWarning();
                    caseOperation.setCompletedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
                    running = false;
                }
                if (caseOperation.isErrored()) {
                    ResultInfo resultInfo = caseOperation.getResultInfo();
                    if (resultInfo != null) {
                        statusLog = statusLog + " (" + resultInfo.getCode() + " [" + resultInfo.getSubcode() + "] - " + resultInfo.getMessage() + ")";
                    }
                    throw new PurviewOperationException(statusLog);
                }
                PurviewOperation.this.addExecutionLog(statusLog);
            }
            return running;
        }

        private void resolveLastFrozenTransientWarning() {
            if (this.lastFrozenWarningMessage != null) {
                PurviewOperation.this.addTransientWarning(this.lastFrozenWarningMessage, true);
            }
        }
    }
}

