/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.purview.Custodian;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.PurviewReleaseCustodiansOperation;
import com.nuix.automate.workflow.core.execution.options.purview.CustodialDataSourceSubmission;
import com.nuix.automate.workflow.core.execution.options.purview.DataSourceInputType;
import com.nuix.automate.workflow.core.utils.purview.PurviewOperationException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class PurviewReleaseCustodiansOperationImplementation
extends PurviewReleaseCustodiansOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewReleaseCustodiansOperation.class);

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.stageName = this.iu.getString("PurviewReleaseCustodiansOperation.Stage.PreparingCustodians");
            this.percentageComplete = 0.1;
            HashMap<String, String> custodianIdToEmail = new HashMap<String, String>();
            for (Custodian custodian : this.purviewRestClient.getCustodians(this.purviewCaseId)) {
                String email = custodian.getEmail();
                if (email == null) continue;
                custodianIdToEmail.put(custodian.getId(), email.trim());
            }
            int custodiansNotFoundCount = 0;
            if (this.inputType == DataSourceInputType.IDS_JSON) {
                this.custodianIdsJson = this.executionContext.evalParameters(this.custodianIdsJson, this);
                HashSet custodianIds = new HashSet((Collection)SerializationUtils.fromJson((String)this.custodianIdsJson));
                custodianIdToEmail.keySet().retainAll(custodianIds);
                custodiansNotFoundCount = custodianIds.size() - custodianIdToEmail.size();
            } else if (this.inputType == DataSourceInputType.FILE) {
                this.custodiansFileLocation = this.executionContext.evalParameters(this.custodiansFileLocation, this);
                this.addExecutionLog(this.iu.getFormattedString("PurviewReleaseCustodiansOperation.Log.CustodiansFile", (Object)this.custodiansFileLocation));
                Set custodianEmails = this.readCustodialDataSourcesFile(this.custodiansFileLocation).stream().map(CustodialDataSourceSubmission::getCustodianEmail).collect(Collectors.toSet());
                custodianIdToEmail.values().retainAll(custodianEmails);
                custodiansNotFoundCount = custodianEmails.size() - custodianIdToEmail.size();
            } else if (this.inputType == null) {
                throw new PurviewOperationException("DataSourceInputType cannot be null");
            }
            if (custodianIdToEmail.isEmpty()) {
                LOGGER.info("List of custodians is empty");
                return;
            }
            if (custodiansNotFoundCount > 0) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewReleaseCustodiansOperation.Log.CouldNotFindCustodians", (long)custodiansNotFoundCount));
            }
            this.stageName = this.iu.getString("PurviewReleaseCustodiansOperation.Stage.ReleasingCustodians");
            this.percentageComplete = 0.3;
            int failedToReleaseCustodianCount = 0;
            this.consumptionCustodianIds = new HashSet();
            for (String custodianId : custodianIdToEmail.keySet()) {
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                try {
                    this.consumptionCustodianIds.add(custodianId);
                    this.purviewRestClient.releaseCustodian(this.purviewCaseId, custodianId);
                }
                catch (IOException e) {
                    this.addWarning(this.iu.getFormattedString("PurviewReleaseCustodiansOperation.Warning.CannotProcessCustodian", new Object[]{custodianIdToEmail.get(custodianId), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    ++failedToReleaseCustodianCount;
                }
            }
            this.addExecutionLog(this.iu.getNumeralString("PurviewReleaseCustodiansOperation.Log.ReleasedCustodians", (long)custodianIdToEmail.size()));
            if (failedToReleaseCustodianCount > 0) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewReleaseCustodiansOperation.Log.FailedToReleaseCustodians", (long)failedToReleaseCustodianCount));
            }
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_released_custodian_ids}", SerializationUtils.toJson(custodianIdToEmail.keySet()))));
        });
    }
}

