/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.purview.NonCustodialDataSource;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.PurviewReleaseNonCustodialDataSourcesOperation;
import com.nuix.automate.workflow.core.execution.options.purview.DataSourceInputType;
import com.nuix.automate.workflow.core.execution.options.purview.NonCustodialDataSourceSubmission;
import com.nuix.automate.workflow.core.utils.purview.PurviewOperationException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class PurviewReleaseNonCustodialDataSourcesOperationImplementation
extends PurviewReleaseNonCustodialDataSourcesOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewReleaseNonCustodialDataSourcesOperation.class);

    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            this.initialize();
            this.stageName = this.iu.getString("PurviewReleaseNonCustodialDataSourcesOperation.Stage.PreparingNonCustodialDataSources");
            this.percentageComplete = 0.1;
            HashMap<String, String> nonCustodialDataSourceIdToValue = new HashMap<String, String>();
            for (NonCustodialDataSource nonCustodialDataSource : this.purviewRestClient.getNonCustodialDataSources(this.purviewCaseId)) {
                String value;
                if (nonCustodialDataSource.getDataSource() == null || (value = nonCustodialDataSource.getDataSource().getDataSourceValue()) == null) continue;
                nonCustodialDataSourceIdToValue.put(nonCustodialDataSource.getId(), value);
            }
            int nonCustodialDataSourcesNotFound = 0;
            if (this.inputType == DataSourceInputType.IDS_JSON) {
                this.nonCustodialDataSourceIdsJson = this.executionContext.evalParameters(this.nonCustodialDataSourceIdsJson, this);
                HashSet nonCustodialDataSourceIds = new HashSet((Collection)SerializationUtils.fromJson((String)this.nonCustodialDataSourceIdsJson));
                nonCustodialDataSourceIdToValue.keySet().retainAll(nonCustodialDataSourceIds);
                nonCustodialDataSourcesNotFound = nonCustodialDataSourceIds.size() - nonCustodialDataSourceIdToValue.size();
            } else if (this.inputType == DataSourceInputType.FILE) {
                this.nonCustodialDataSourcesFileLocation = this.executionContext.evalParameters(this.nonCustodialDataSourcesFileLocation, this);
                this.addExecutionLog(this.iu.getFormattedString("PurviewReleaseNonCustodialDataSourcesOperation.Log.nonCustodialDataSourcesFileLocation", (Object)this.nonCustodialDataSourcesFileLocation));
                Set nonCustodialDataSourceValues = this.readNonCustodialDataSourcesFile(this.nonCustodialDataSourcesFileLocation).stream().map(NonCustodialDataSourceSubmission::getValue).collect(Collectors.toSet());
                nonCustodialDataSourceIdToValue.values().retainAll(nonCustodialDataSourceValues);
                nonCustodialDataSourcesNotFound = nonCustodialDataSourceValues.size() - nonCustodialDataSourceIdToValue.size();
            } else if (this.inputType == null) {
                throw new PurviewOperationException("DataSourceInputType cannot be null");
            }
            if (nonCustodialDataSourceIdToValue.isEmpty()) {
                LOGGER.info("List of non-custodial data sources is empty");
                return;
            }
            if (nonCustodialDataSourcesNotFound > 0) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewReleaseNonCustodialDataSourcesOperation.Log.CouldNotFindCustodians", (long)nonCustodialDataSourcesNotFound));
            }
            this.stageName = this.iu.getString("PurviewReleaseNonCustodialDataSourcesOperation.Stage.ReleasingNonCustodialDataSources");
            this.percentageComplete = 0.3;
            int failedToReleaseNonCustodialDataSourcesCount = 0;
            for (String nonCustodialDataSourceId : nonCustodialDataSourceIdToValue.keySet()) {
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                try {
                    this.purviewRestClient.releaseNonCustodialDataSource(this.purviewCaseId, nonCustodialDataSourceId);
                }
                catch (IOException e) {
                    this.addWarning(this.iu.getFormattedString("PurviewReleaseNonCustodialDataSourcesOperation.Warning.CannotProcessNonCustodialDataSource", new Object[]{nonCustodialDataSourceIdToValue.get(nonCustodialDataSourceId), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    ++failedToReleaseNonCustodialDataSourcesCount;
                }
            }
            this.addExecutionLog(this.iu.getNumeralString("PurviewReleaseNonCustodialDataSourcesOperation.Log.ReleasedNonCustodialDataSources", (long)nonCustodialDataSourceIdToValue.size()));
            if (failedToReleaseNonCustodialDataSourcesCount > 0) {
                this.addExecutionLog(this.iu.getNumeralString("PurviewReleaseNonCustodialDataSourcesOperation.Log.FailedToReleaseNonCustodialDataSources", (long)failedToReleaseNonCustodialDataSourcesCount));
            }
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_released_non_custodial_data_source_ids}", SerializationUtils.toJson(nonCustodialDataSourceIdToValue.keySet()))));
        });
    }
}

