/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphObject;
import com.nuix.automate.utils.models.internal.purview.Custodian;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.models.internal.purview.operations.HoldOperation;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.PurviewRemoveHoldFromCustodiansOperation;
import com.nuix.automate.workflow.core.execution.options.purview.CustodialDataSourceSubmission;
import com.nuix.automate.workflow.core.execution.options.purview.DataSourceInputType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PurviewRemoveHoldFromCustodiansOperationImplementation
extends PurviewRemoveHoldFromCustodiansOperation {
    @Override
    public void startTriggered() {
        this.runStartTriggeredThread(() -> {
            HoldOperation removeHoldOperation;
            this.initialize();
            this.stageName = this.iu.getString("PurviewRemoveHoldFromCustodiansOperation.Stage.PreparingCustodians");
            this.percentageComplete = 0.0;
            if (this.inputType == DataSourceInputType.ALL_CASE) {
                removeHoldOperation = this.purviewRestClient.removeHoldFromCustodians(this.purviewCaseId, null);
                this.addExecutionLog(this.iu.getString("PurviewRemoveHoldFromCustodiansOperation.Log.RemovedHoldFromAllCustodians"));
            } else {
                int custodiansNotFoundCount;
                List<Custodian> caseCustodians = this.purviewRestClient.getCustodians(this.purviewCaseId);
                HashSet<String> custodianIds = new HashSet<String>();
                switch (this.inputType) {
                    case FILE: {
                        Set custodianEmails = this.readCustodialDataSourcesFile(this.custodiansFileLocation).stream().map(CustodialDataSourceSubmission::getCustodianEmail).collect(Collectors.toSet());
                        for (Custodian caseCustodian : caseCustodians) {
                            String custodianEmail = null;
                            if (caseCustodian.getEmail() != null) {
                                custodianEmail = caseCustodian.getEmail().trim();
                            }
                            if (!custodianEmails.remove(custodianEmail)) continue;
                            custodianIds.add(caseCustodian.getId());
                        }
                        custodiansNotFoundCount = custodianEmails.size();
                        break;
                    }
                    case IDS_JSON: {
                        this.custodianIdsJson = this.executionContext.evalParameters(this.custodianIdsJson, this);
                        custodianIds.addAll((Collection)SerializationUtils.fromJson((String)this.custodianIdsJson));
                        int custodianIdsSize = custodianIds.size();
                        Set caseCustodianIds = caseCustodians.stream().map(MicrosoftGraphObject::getId).collect(Collectors.toSet());
                        custodianIds.retainAll(caseCustodianIds);
                        custodiansNotFoundCount = custodianIdsSize - custodianIds.size();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Data source input type not supported");
                    }
                }
                if (custodiansNotFoundCount > 0) {
                    this.addExecutionLog(this.iu.getNumeralString("PurviewRemoveHoldFromCustodiansOperation.Log.CustodiansNotFound", (long)custodiansNotFoundCount));
                }
                this.consumptionCustodianIds = new HashSet();
                this.consumptionCustodianIds.addAll(custodianIds);
                if (custodianIds.isEmpty()) {
                    this.addWarning(this.iu.getString("PurviewRemoveHoldFromCustodiansOperation.Log.NoCustodians"));
                    return;
                }
                removeHoldOperation = this.purviewRestClient.removeHoldFromCustodians(this.purviewCaseId, custodianIds);
                this.addExecutionLog(this.iu.getNumeralString("PurviewRemoveHoldFromCustodiansOperation.Log.RemovedHoldFromCustodians", (long)custodianIds.size()));
            }
            this.stageName = this.iu.getString("PurviewRemoveHoldFromCustodiansOperation.Stage.RemovingHold");
            this.percentageComplete = 0.2;
            if (removeHoldOperation != null) {
                this.addExecutionLog(this.iu.getFormattedString("PurviewRemoveHoldFromCustodiansOperation.Log.HoldOperationId", (Object)removeHoldOperation.getId()));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{purview_remove_hold_from_custodians_job_id}", removeHoldOperation.getId())));
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                if (this.waitForCompletion) {
                    this.waitForOperationToComplete((CaseOperation)removeHoldOperation);
                }
            } else {
                this.addExecutionLog(this.iu.getString("PurviewRemoveHoldFromCustodiansOperation.Log.HoldOperationNotCreated"));
            }
        });
    }
}

