/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.ReplaceTextFromFileModifierCallback;
import java.util.Set;
import nuix.Item;
import nuix.ItemModifier;
import nuix.ItemModifierCallback;

class RedactTextItemModifierCallback
implements ItemModifierCallback {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ReplaceTextFromFileModifierCallback.class);
    private Item item;
    private String replacedText;
    Set<Item> failedItems;

    RedactTextItemModifierCallback(Item item, String replacedText, Set<Item> failedItems) {
        this.item = item;
        this.replacedText = replacedText;
        this.failedItems = failedItems;
    }

    public void execute(ItemModifier itemModifier) {
        try {
            itemModifier.replaceText(this.replacedText);
        }
        catch (Exception e) {
            this.failedItems.add(this.item);
            LOGGER.error("Cannot redact text for item with guid " + this.item.getGuid(), (Throwable)e);
        }
    }
}

