/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RedactTextItemModifierCallback;
import com.nuix.automate.workflow.core.execution.operations.RedactTextOperation;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import nuix.BulkAnnotater;
import nuix.Case;
import nuix.Item;
import nuix.ItemModifierCallback;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class RedactTextOperationImplementation
extends RedactTextOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RedactTextOperation.class);
    private transient long countItemsToProcess;
    private transient AtomicLong countItemsProcessed;
    private transient AtomicLong countItemsTextReplaced;
    private transient List<String> redactionNames;
    private transient List<Pattern> redactionPatterns;
    private transient Set<Item> failedItems;
    private transient Set<Item> redactedItems;

    @Override
    public void startTriggered() throws Exception {
        int redactionId;
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.redactionDefinitionFile = this.executionContext.evalParameters(this.redactionDefinitionFile, this);
        this.redactedItemsTag = this.executionContext.evalParameters(this.redactedItemsTag, this);
        this.failedItemsTag = this.executionContext.evalParameters(this.failedItemsTag, this);
        this.executionContext.closeAllTabs();
        this.redactionNames = new ArrayList<String>();
        this.redactionPatterns = new ArrayList<Pattern>();
        this.countItemsProcessed = new AtomicLong(0L);
        this.countItemsTextReplaced = new AtomicLong(0L);
        LOGGER.info("Read metadata file");
        this.addExecutionLog(this.iu.getFormattedString("RedactTextOperation.Log.RedactionDefinitionFile", (Object)this.redactionDefinitionFile));
        List lines = FileUtils.loadVariableColumnDetectFormatFile((File)new File(this.redactionDefinitionFile));
        String[] header = (String[])lines.get(0);
        Integer regexPosition = null;
        Integer namePosition = null;
        boolean headerPresent = header.length != 1 || header[0].equalsIgnoreCase("regex");
        if (headerPresent) {
            for (int i = 0; i < header.length; ++i) {
                if (header[i].equalsIgnoreCase("regex")) {
                    regexPosition = i;
                }
                if (!header[i].equalsIgnoreCase("name")) continue;
                namePosition = i;
            }
        }
        if (headerPresent && regexPosition == null) {
            throw new Exception(this.iu.getString("RedactTextOperation.Exception.FileMustContain"));
        }
        if (!headerPresent) {
            redactionId = 1;
            for (Object[] line : lines) {
                String regex = line[0].toString();
                this.redactionNames.add("[Redaction " + redactionId + "]");
                this.redactionPatterns.add(Pattern.compile(regex));
                ++redactionId;
            }
        } else {
            redactionId = 1;
            for (Object[] line : lines) {
                Object redactionName;
                if (line.length <= regexPosition) {
                    throw new Exception(this.iu.getFormattedString("RedactTextOperation.Exception.LineTooFewColumns", (Object)redactionId));
                }
                String regex = line[regexPosition].toString();
                if (namePosition != null) {
                    if (line.length <= namePosition) {
                        throw new Exception(this.iu.getFormattedString("RedactTextOperation.Exception.LineTooFewColumns", (Object)redactionId));
                    }
                    redactionName = line[namePosition].toString();
                } else {
                    redactionName = "[Redaction " + redactionId + "]";
                }
                this.redactionNames.add((String)redactionName);
                this.redactionPatterns.add(Pattern.compile(regex, 2));
                ++redactionId;
            }
        }
        this.addExecutionLog(this.iu.getFormattedString("RedactTextOperation.Log.RedactionCount", (Object)this.redactionNames.size()));
        this.addExecutionLog(this.iu.getFormattedString("RedactTextOperation.Log.ScopeQuery", (Object)this.scope));
        this.failedItems = Collections.newSetFromMap(new ConcurrentHashMap());
        this.redactedItems = Collections.newSetFromMap(new ConcurrentHashMap());
        this.startTriggerThread = new Thread(() -> {
            try {
                Case writableCase = this.executionContext.nuixCase;
                this.executionContext.nuixCase.withWriteAccess(() -> {
                    try {
                        LOGGER.info("Searching for items");
                        Set items = writableCase.searchUnsorted(this.scope);
                        this.countItemsToProcess = items.size();
                        this.addExecutionLog(this.iu.getNumeralString("RedactTextOperation.Log.ScopeCount", this.countItemsToProcess));
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        LOGGER.info("Redacting text");
                        FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)items, ItemsUtils.getPartitionerChunkSize(1000, this));
                        Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            while (iterator.hasNext()) {
                                if (this.stopRequested) {
                                    throw new WorkflowExecutionStopRequested();
                                }
                                Item item = (Item)iterator.next();
                                try {
                                    String originalText;
                                    String result = originalText = item.getTextObject().toString();
                                    for (int i = 0; i < this.redactionNames.size(); ++i) {
                                        result = this.redactionPatterns.get(i).matcher(result).replaceAll(this.redactionNames.get(i));
                                    }
                                    if (!originalText.equals(result)) {
                                        item.modify((ItemModifierCallback)new RedactTextItemModifierCallback(item, result, this.failedItems));
                                        this.countItemsTextReplaced.incrementAndGet();
                                        this.redactedItems.add(item);
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Cannot process item " + item.getGuid(), (Throwable)e);
                                    this.failedItems.add(item);
                                }
                                this.countItemsProcessed.incrementAndGet();
                            }
                        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                    }
                    catch (Throwable e) {
                        LOGGER.error("Operation unchecked exception", e);
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                });
                this.addExecutionLog(this.iu.getNumeralString("RedactTextOperation.Log.RedactedCount", this.countItemsTextReplaced.get()));
                BulkAnnotater bulkAnnotator = this.executionContext.nuixUtilities.getBulkAnnotater();
                if (this.redactedItemsTag.trim().length() > 0) {
                    bulkAnnotator.addTag(this.redactedItemsTag, this.redactedItems);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("RedactTextOperation.Log.Tagged", (long)this.redactedItems.size(), (Object)this.redactedItemsTag));
                }
                if (this.failedItems.size() > 0) {
                    this.addWarning(this.iu.getNumeralString("RedactTextOperation.Warning.FailedProcessing", (long)this.failedItems.size()));
                    if (this.failedItemsTag.trim().length() > 0) {
                        bulkAnnotator.addTag(this.failedItemsTag, this.failedItems);
                        this.addExecutionLog(this.iu.getNumeralFormattedString("RedactTextOperation.Log.Tagged", (long)this.failedItems.size(), (Object)this.failedItemsTag));
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.countItemsToProcess > 0L) {
            percentageComplete = (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.countItemsProcessed != null) {
            result = (String)result + this.iu.getNumeralString("RedactTextOperation.Progress.SearchedItems", this.countItemsProcessed.get());
        }
        if (this.countItemsTextReplaced != null) {
            result = (String)result + this.iu.getNumeralString("RedactTextOperation.Progress.RedactedItems", this.countItemsTextReplaced.get());
        }
        return result;
    }
}

