/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityCopyWorkspaceGroupPermissionsOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroupPermissions;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.util.List;
import java.util.Set;

public class RelativityCopyWorkspaceGroupPermissionsOperationImplementation
extends RelativityCopyWorkspaceGroupPermissionsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityCopyWorkspaceGroupPermissionsOperationImplementation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.fromWorkspaceIdentifier = this.executionContext.evalParameters(this.fromWorkspaceIdentifier, this);
                this.fromGroupIdentifier = this.executionContext.evalParameters(this.fromGroupIdentifier, this);
                this.toWorkspaceIdentifier = this.executionContext.evalParameters(this.toWorkspaceIdentifier, this);
                this.toGroupIdentifier = this.executionContext.evalParameters(this.toGroupIdentifier, this);
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                Long fromWorkspaceArtifactId = 0L;
                Long toWorkspaceArtifactId = 0L;
                Long fromGroupArtifactId = 0L;
                Long toGroupArtifactId = 0L;
                this.stageName = this.iu.getString("RelativityCopyWorkspaceGroupPermissionsOperation.Stage.GettingWorkspaceGroups");
                this.percentageComplete = 0.25;
                List<EligibleObject> eligibleFromWorkspaces = this.relativityRestClient.queryEligibleWorkspaces(this.fromWorkspaceIdentifierType, this.fromWorkspaceIdentifier);
                EligibleObject eligibleFromWorkspace = RelativityUtils.getInstance().filterAllEligibleObject(this.fromWorkspaceIdentifier, this.fromWorkspaceIdentifierType, eligibleFromWorkspaces, RelativityFieldType.WORKSPACE);
                if (eligibleFromWorkspace == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Exception.WorkspaceMissing", (Object)String.valueOf(this.fromWorkspaceIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Info.FromWorkspaceIdentifier", (Object)String.valueOf(this.fromWorkspaceIdentifier)));
                fromWorkspaceArtifactId = eligibleFromWorkspace.getArtifactId();
                List<EligibleObject> eligibleToWorkspaces = this.relativityRestClient.queryEligibleWorkspaces(this.toWorkspaceIdentifierType, this.toWorkspaceIdentifier);
                EligibleObject eligibleToWorkspace = RelativityUtils.getInstance().filterAllEligibleObject(this.toWorkspaceIdentifier, this.toWorkspaceIdentifierType, eligibleToWorkspaces, RelativityFieldType.WORKSPACE);
                if (eligibleToWorkspace == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Exception.WorkspaceMissing", (Object)String.valueOf(this.toWorkspaceIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Info.ToWorkspaceIdentifier", (Object)String.valueOf(this.toWorkspaceIdentifier)));
                toWorkspaceArtifactId = eligibleToWorkspace.getArtifactId();
                List<EligibleObject> eligibleGroups = this.relativityRestClient.queryEligibleGroups(null);
                EligibleObject eligibleFromGroup = RelativityUtils.getInstance().filterEligibleObject(this.fromGroupIdentifier, this.fromGroupIdentifierType, eligibleGroups, RelativityFieldType.GROUP);
                if (eligibleFromGroup == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Exception.MissingGroup", (Object)String.valueOf(this.fromGroupIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Info.FromGroupIdentifier", (Object)String.valueOf(this.fromGroupIdentifier)));
                fromGroupArtifactId = eligibleFromGroup.getArtifactId();
                EligibleObject eligibleToGroup = RelativityUtils.getInstance().filterEligibleObject(this.toGroupIdentifier, this.toGroupIdentifierType, eligibleGroups, RelativityFieldType.GROUP);
                if (eligibleToGroup == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Exception.MissingGroup", (Object)String.valueOf(this.toGroupIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Info.ToGroupIdentifier", (Object)String.valueOf(this.toGroupIdentifier)));
                toGroupArtifactId = eligibleToGroup.getArtifactId();
                WorkspaceGroupPermissions fromWorkspaceGroupPermissions = this.relativityRestClient.getWorkspaceGroupPermissions(fromWorkspaceArtifactId, fromGroupArtifactId);
                if (fromWorkspaceGroupPermissions == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Exception.WorkspaceGroupMissing", new Object[]{String.valueOf(this.fromGroupIdentifier), String.valueOf(this.fromWorkspaceIdentifier)}));
                }
                WorkspaceGroupPermissions toWorkspaceGroupPermissions = this.relativityRestClient.getWorkspaceGroupPermissions(toWorkspaceArtifactId, toGroupArtifactId);
                if (toWorkspaceGroupPermissions == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Exception.WorkspaceGroupMissing", new Object[]{String.valueOf(this.toGroupIdentifier), String.valueOf(this.toWorkspaceIdentifier)}));
                }
                this.stageName = this.iu.getString("RelativityCopyWorkspaceGroupPermissionsOperation.Stage.SettingPermissions");
                this.percentageComplete = 0.75;
                toWorkspaceGroupPermissions = RelativityUtils.getInstance().copyPermissions(toWorkspaceGroupPermissions, fromWorkspaceGroupPermissions);
                Set<String> missingPermissions = RelativityUtils.getInstance().resolveMissingWorkspaceGroupPermissions(toWorkspaceGroupPermissions, fromWorkspaceGroupPermissions);
                if (missingPermissions.size() > 0) {
                    for (String permissionName : missingPermissions) {
                        this.addWarning(this.iu.getFormattedString("RelativityCopyWorkspaceGroupPermissionsOperation.Warning.UnableToCopyPermission", new Object[]{permissionName, String.valueOf(this.fromGroupIdentifier)}));
                    }
                }
                this.relativityRestClient.setWorkspaceGroupPermissions(toWorkspaceArtifactId, toWorkspaceGroupPermissions);
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

