/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RelativityCreateAnalyticsIndexOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.AnalyticIndexRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.AssociatedResourcePoolType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityIndexType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RequestIdentifier;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class RelativityCreateAnalyticsIndexOperationImplementation
extends RelativityCreateAnalyticsIndexOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityCreateAnalyticsIndexOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.name = this.executionContext.evalParameters(this.name, this);
                this.savedSearchIdentifier = this.executionContext.evalParameters(this.savedSearchIdentifier, this);
                this.analyticsServerIdentifier = this.executionContext.evalParameters(this.analyticsServerIdentifier, this);
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.stageName = this.iu.getString("RelativityCreateAnalyticsIndexOperation.Stage.CreatingAnalyticIndex");
                this.percentageComplete = 0.25;
                AnalyticIndexRequest index = new AnalyticIndexRequest();
                index.setName(this.name);
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Log.Name", (Object)this.name));
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Log.IndexType", (Object)this.indexType.toString()));
                index.setOrder(this.order);
                index.setActive(true);
                List<EligibleObject> eligibleSearches = this.relativityRestClient.querySearchesForWorkspace(workspaceArtifactId);
                EligibleObject eligibleSearch = RelativityUtils.getInstance().filterEligibleObject(this.savedSearchIdentifier, this.savedSearchIdentifierType, eligibleSearches, RelativityFieldType.SAVED_SEARCH);
                if (eligibleSearch == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Exception.MissingSavedSearch", new Object[]{String.valueOf(this.savedSearchIdentifier)}));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Log.SavedSearchIdentifier", new Object[]{eligibleSearch.getName() + ":" + String.valueOf(eligibleSearch.getArtifactId())}));
                index.setSearchableSet(new RequestIdentifier(eligibleSearch.getArtifactId()));
                EligibleObject resourcePool = this.relativityRestClient.getWorkspaceResourcePoolArtifactId(workspaceArtifactId);
                List<EligibleObject> eligibleAnalyticServers = this.relativityRestClient.queryAssociatedResourcePoolObject(resourcePool.getArtifactId(), AssociatedResourcePoolType.ANALYTICS_SERVERS);
                EligibleObject eligibleAnalyticsServer = RelativityUtils.getInstance().filterEligibleObject(this.analyticsServerIdentifier, this.analyticsServerIdentifierType, eligibleAnalyticServers, RelativityFieldType.ANALYTICS_SEVER);
                if (eligibleAnalyticsServer == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Exception.MissingAnalyticsServer", (Object)String.valueOf(this.analyticsServerIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Log.AnalyticsServerIdentifier", new Object[]{eligibleAnalyticsServer.getName() + ":" + String.valueOf(eligibleAnalyticsServer.getArtifactId())}));
                index.setAnalyticsServer(new RequestIdentifier(eligibleAnalyticsServer.getArtifactId()));
                if (this.useEmailRecipients) {
                    if (this.emailRecipientsFile == null) {
                        this.emailRecipientsFile = "";
                    }
                    this.emailRecipientsFile = this.executionContext.evalParameters(this.emailRecipientsFile, this);
                    List emailRecipients = FileUtils.loadVariableColumnTsv((File)new File(this.emailRecipientsFile));
                    if (emailRecipients.size() > 0) {
                        emailRecipients.remove(0);
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Log.EmailRecipients", (Object)this.emailRecipientsFile));
                    for (Object[] row : emailRecipients) {
                        String emailRecipient = row[0].toString();
                        emailRecipient = this.executionContext.evalParameters(emailRecipient, this);
                        index.getEmailNotificationRecipients().add(emailRecipient);
                    }
                }
                if (this.indexType == RelativityIndexType.CONCEPTUAL) {
                    if (this.useStopWords) {
                        if (this.stopWordsFile == null) {
                            this.stopWordsFile = "";
                        }
                        this.stopWordsFile = this.executionContext.evalParameters(this.stopWordsFile, this);
                        List stopWords = FileUtils.loadVariableColumnTsv((File)new File(this.stopWordsFile));
                        if (stopWords.size() > 0) {
                            stopWords.remove(0);
                        }
                        this.addExecutionLog(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Log.StopWords", (Object)this.stopWordsFile));
                        ArrayList<String> words = new ArrayList<String>();
                        for (Object[] row : stopWords) {
                            String stopWord = row[0].toString();
                            stopWord = this.executionContext.evalParameters(stopWord, this);
                            words.add(stopWord);
                        }
                        index.setConceptStopWords(String.join((CharSequence)"\r", words));
                    }
                    index.setContinueIndexStepsToCompletion(this.continueIndexStepsToCompletion);
                    if (this.continueIndexStepsToCompletion) {
                        this.addExecutionLog(this.iu.getString("RelativityCreateAnalyticsIndexOperation.Log.ContinueIndexStepsToCompletion"));
                    }
                    if (this.useDimensions) {
                        index.setDimensions(this.dimensions);
                        this.addExecutionLog(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Log.Dimensions", (Object)String.valueOf(this.dimensions)));
                    }
                    index.setEnableEmailHeaderFilter(this.enableEmailHeaderFilter);
                    if (this.enableEmailHeaderFilter) {
                        this.addExecutionLog(this.iu.getString("RelativityCreateAnalyticsIndexOperation.Log.EnableEmailHeaderFilter"));
                    }
                    index.setOptimizeTrainingSet(this.optimizeTrainingSet);
                    if (this.optimizeTrainingSet) {
                        this.addExecutionLog(this.iu.getString("RelativityCreateAnalyticsIndexOperation.Log.OptimizeTrainingSet"));
                    }
                    index.setRemoveDocumentsThatErroredDuringPopulation(this.removeDocumentsThatErroredDuringPopulation);
                    if (this.removeDocumentsThatErroredDuringPopulation) {
                        this.addExecutionLog(this.iu.getString("RelativityCreateAnalyticsIndexOperation.Log.RemoveDocumentsThatErroredDuringPopulation"));
                    }
                    index.setRemoveEngSignaturesAndFooters(this.removeEnglishSignaturesAndFooters);
                    if (this.removeEnglishSignaturesAndFooters) {
                        this.addExecutionLog(this.iu.getString("RelativityCreateAnalyticsIndexOperation.Log.RemoveEnglishSignaturesAndFooters"));
                    }
                    if (this.useRepeatedContentFilters) {
                        if (this.repeatedContentFiltersFile == null) {
                            this.repeatedContentFiltersFile = "";
                        }
                        this.repeatedContentFiltersFile = this.executionContext.evalParameters(this.repeatedContentFiltersFile, this);
                        List repeatedContents = FileUtils.loadVariableColumnTsv((File)new File(this.repeatedContentFiltersFile));
                        if (repeatedContents.size() > 0) {
                            repeatedContents.remove(0);
                        }
                        this.addExecutionLog(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Log.RepeatedContentFilters", (Object)this.repeatedContentFiltersFile));
                        index.setRepeatedContentFilters(new ArrayList<RequestIdentifier>());
                        List<EligibleObject> repeatedContentFilters = this.relativityRestClient.queryRepeatedFilters(workspaceArtifactId);
                        block4: for (Object[] row : repeatedContents) {
                            String repeatedContentFilter = row[0].toString();
                            repeatedContentFilter = this.executionContext.evalParameters(repeatedContentFilter, this);
                            for (EligibleObject filter : repeatedContentFilters) {
                                if (!filter.getName().equals(repeatedContentFilter)) continue;
                                index.getRepeatedContentFilters().add(new RequestIdentifier(filter.getArtifactId()));
                                continue block4;
                            }
                        }
                    }
                    if (this.useTrainingSet) {
                        EligibleObject eligibleTrainingSearch = RelativityUtils.getInstance().filterEligibleObject(this.trainingSavedSearchIdentifier, this.trainingSavedSearchIdentifierType, eligibleSearches, RelativityFieldType.SAVED_SEARCH);
                        if (eligibleTrainingSearch == null) {
                            throw new Exception(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Exception.MissingSavedSearch", new Object[]{String.valueOf(this.trainingSavedSearchIdentifier)}));
                        }
                        this.addExecutionLog(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Log.TrainingSavedSearchIdentifier", new Object[]{eligibleTrainingSearch.getName() + ":" + String.valueOf(eligibleTrainingSearch.getArtifactId())}));
                        index.setTrainingSet(new RequestIdentifier(eligibleTrainingSearch.getArtifactId()));
                    }
                }
                long artifactId = this.relativityRestClient.createAnalyticIndex(workspaceArtifactId, index, this.indexType);
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateAnalyticsIndexOperation.Log.CreatedIndex", new Object[]{this.name + ":" + String.valueOf(artifactId)}));
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

