/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.relativity.RelativityRestVersion;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RelativityCreateFoldersOperation;
import com.nuix.automate.workflow.core.utils.relativity.RelativityRestException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class RelativityCreateFoldersOperationImplementation
extends RelativityCreateFoldersOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityCreateFoldersOperation.class);
    private transient long foldersInScope;
    private transient Set<Integer> lineIdsFailed;
    private transient AtomicInteger foldersCreated = new AtomicInteger();
    private transient String relativityWorkspaceId;
    private transient String relativityFolderId;
    private transient String relativityMetadataThreads;
    private transient File settingsFile;
    private transient ConcurrentLinkedDeque<String> folderNamesQueue;

    @Override
    public void startTriggered() throws Exception {
        this.folderListingLocation = this.executionContext.evalParameters(this.folderListingLocation, this);
        File exportLocationFile = new File(this.folderListingLocation);
        if (!exportLocationFile.exists()) {
            throw new FileNotFoundException(this.iu.getString("RelativityCreateFoldersOperation.Exception.FileNotFound"));
        }
        this.relativityWorkspaceId = this.executionContext.evalParameters("{relativity_workspace_id}", this);
        this.relativityMetadataThreads = this.executionContext.evalParameters("{wfn_relativity_metadata_threads}", this);
        this.relativityFolderId = this.executionContext.evalParameters("{relativity_folder_id}", this);
        this.foldersCreated = new AtomicInteger(0);
        this.addExecutionLog(this.iu.getFormattedString("RelativityCreateFoldersOperation.Log.FolderListingLocation", (Object)this.folderListingLocation));
        this.startTriggerThread = new Thread(() -> {
            try {
                this.folderNamesQueue = new ConcurrentLinkedDeque();
                BufferedReader reader = Files.newBufferedReader(Paths.get(this.folderListingLocation, new String[0]));
                CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.DEFAULT);
                List csvRecords = csvParser.getRecords();
                this.addExecutionLog(this.iu.getNumeralString("RelativityCreateFoldersOperation.Log.ReadCsvRecords", (long)csvRecords.size()));
                if (csvRecords.size() > 0) {
                    CSVRecord headerRecord = (CSVRecord)csvRecords.get(0);
                    if (headerRecord.size() > 1) {
                        throw new Exception("Listing file must only contain 1 column, detected " + headerRecord.size() + " columns");
                    }
                    String headerName = headerRecord.get(0);
                    if (!(headerName.toLowerCase().contains("path") || headerName.toLowerCase().contains("location") || headerName.toLowerCase().contains("folder"))) {
                        throw new Exception("Listing column header must contain \"Path\", \"Folder\" or \"Location\", detected \"" + headerName + "\"");
                    }
                    HashSet<String> uniqueFolderNames = new HashSet<String>();
                    for (CSVRecord csvRecord : csvRecords) {
                        String folderName;
                        if (csvRecord == headerRecord || (folderName = csvRecord.get(0).trim()).length() <= 0) continue;
                        uniqueFolderNames.add(folderName);
                    }
                    this.folderNamesQueue.addAll(uniqueFolderNames);
                    this.addExecutionLog(this.iu.getNumeralString("RelativityCreateFoldersOperation.Log.DetectedFolders", (long)uniqueFolderNames.size()));
                    this.foldersInScope = uniqueFolderNames.size();
                    RelativityRestVersion relativityRestVersion = RelativityRestVersion.REST_V1;
                    this.initializeRelativityClient(relativityRestVersion);
                    Integer threadCount = Integer.parseInt(this.relativityMetadataThreads);
                    ArrayList<Thread> importThreads = new ArrayList<Thread>();
                    Long workspaceId = Long.parseLong(this.relativityWorkspaceId);
                    Long rootFolderId = Long.parseLong(this.relativityFolderId);
                    for (int i = 0; i < threadCount; ++i) {
                        Thread thread = new Thread(() -> {
                            try {
                                LOGGER.info("Thread " + Thread.currentThread().getName() + " Starting");
                                while (true) {
                                    if (this.stopRequested) {
                                        return;
                                    }
                                    String folderToCreate = this.folderNamesQueue.removeFirst();
                                    try {
                                        this.relativityRestClient.getFolderArtifactIdId((long)workspaceId, (long)rootFolderId, folderToCreate, true);
                                    }
                                    catch (RelativityRestException e) {
                                        this.addWarning(this.iu.getFormattedString("RelativityCreateFoldersOperation.Warning.CannotCreateFolder", new Object[]{folderToCreate, e.getRelativityError().getMessage()}));
                                    }
                                    this.foldersCreated.incrementAndGet();
                                }
                            }
                            catch (NoSuchElementException folderToCreate) {
                            }
                            catch (Throwable e) {
                                LOGGER.error("Operation unchecked exception", e);
                                this.exception = e;
                                this.executionState = ExecutionState.ERROR;
                                this.folderNamesQueue.clear();
                            }
                            LOGGER.info("Thread " + Thread.currentThread().getName() + " Finished");
                        });
                        thread.setName("Automate - Operation " + this.getOperationName() + " - Create Folders #" + i);
                        importThreads.add(thread);
                        thread.start();
                    }
                    for (Thread importThread : importThreads) {
                        importThread.join();
                    }
                }
                if (this.stopRequested) {
                    this.trackStopped();
                    return;
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Aborting operation", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        if (this.foldersInScope == 0L) {
            return 1.0E-4;
        }
        double result = (double)this.foldersCreated.get() / (double)this.foldersInScope;
        return result;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.foldersInScope == 0L) {
            result = (String)result + this.iu.getString("RelativityCreateFoldersOperation.Progress.ParsingListing");
        } else if (this.foldersCreated != null) {
            result = (String)result + this.iu.getNumeralString("RelativityCreateFoldersOperation.Progress.CreatingFolders", (long)this.foldersCreated.get());
        }
        return result;
    }
}

