/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RelativityCreateProductionSetOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ProductionDataSource;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ProductionDataSourceImagePlaceholderType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ProductionDataSourceType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceIdentifierType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.CreateProductionSetRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.ProductionSetAttachmentRelationalField;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.ProductionSetDataSource;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.ProductionSetDetails;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.ProductionSetNumbering;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RelativityCreateProductionSetOperationImplementation
extends RelativityCreateProductionSetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityCreateProductionSetOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.name = this.executionContext.evalParameters(this.name, this);
                this.templateProductionSetIdentifier = this.executionContext.evalParameters(this.templateProductionSetIdentifier, this);
                this.productionTemplateWorkspaceIdentifier = this.executionContext.evalParameters(this.productionTemplateWorkspaceIdentifier, this);
                this.numberingPrefix = this.executionContext.evalParameters(this.numberingPrefix, this);
                this.numberingSuffix = this.executionContext.evalParameters(this.numberingSuffix, this);
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                CreateProductionSetRequest request = new CreateProductionSetRequest();
                JsonObject copyProductionSetRequest = null;
                Long createdProductionSetArtifactId = null;
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.Name", (Object)this.name));
                if (this.createProductionFromCopy) {
                    this.stageName = this.iu.getString("RelativityCreateProductionSetOperation.Stage.GettingTemplateProductionSet");
                    this.percentageComplete = 0.35;
                    this.addExecutionLog(this.iu.getString("RelativityCreateProductionSetOperation.Info.CreateFromCopy"));
                    Long queryWorkspaceArtifactId = workspaceArtifactId;
                    Long productionSetArtifactId = -1L;
                    if (this.workspaceLocation == WorkspaceIdentifierType.SPECIFIC_WORKSPACE) {
                        this.addExecutionLog(this.iu.getString("RelativityCreateProductionSetOperation.Info.ExistsInDifferentWorkspace"));
                        List<EligibleObject> eligibleWorkspaces = this.relativityRestClient.queryEligibleWorkspaces(this.productionWorkspaceIdentifierType, this.productionTemplateWorkspaceIdentifier);
                        EligibleObject eligibleWorkspace = RelativityUtils.getInstance().filterAllEligibleObject(this.productionTemplateWorkspaceIdentifier, this.productionWorkspaceIdentifierType, eligibleWorkspaces, RelativityFieldType.WORKSPACE);
                        if (eligibleWorkspace == null) {
                            throw new Exception(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Exception.MissingWorkspace", (Object)String.valueOf(this.productionTemplateWorkspaceIdentifier)));
                        }
                        queryWorkspaceArtifactId = eligibleWorkspace.getArtifactId();
                        this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.WorkspaceIdentifier", new Object[]{eligibleWorkspace.getName(), String.valueOf(eligibleWorkspace.getArtifactId())}));
                    }
                    List<EligibleObject> eligibleProductionSets = this.relativityRestClient.queryProductionSets(queryWorkspaceArtifactId, this.templateProductionSetIdentifierType, this.templateProductionSetIdentifier);
                    EligibleObject eligibleProductionSet = RelativityUtils.getInstance().filterAllEligibleObject(this.templateProductionSetIdentifier, this.templateProductionSetIdentifierType, eligibleProductionSets, RelativityFieldType.PRODUCTION_SET);
                    if (eligibleProductionSet == null) {
                        throw new Exception(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Exception.MissingTemplate", (Object)String.valueOf(this.templateProductionSetIdentifier)));
                    }
                    productionSetArtifactId = eligibleProductionSet.getArtifactId();
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.TemplateIdentifier", new Object[]{eligibleProductionSet.getName(), String.valueOf(eligibleProductionSet.getArtifactId())}));
                    copyProductionSetRequest = this.relativityRestClient.readProductionSetJson(queryWorkspaceArtifactId, productionSetArtifactId);
                    this.stageName = this.iu.getString("RelativityCreateProductionSetOperation.Stage.CreatingProductionSet");
                    this.percentageComplete = 0.5;
                    copyProductionSetRequest.remove("ProductionID");
                    copyProductionSetRequest.remove("ProductionMetadata");
                    copyProductionSetRequest.addProperty("Name", this.name);
                    copyProductionSetRequest.getAsJsonObject("Details").remove("DateProduced");
                    copyProductionSetRequest.add("DataSources", (JsonElement)new JsonArray());
                    JsonObject productionRequest = new JsonObject();
                    productionRequest.add("production", (JsonElement)copyProductionSetRequest);
                    createdProductionSetArtifactId = this.relativityRestClient.createProductionSetJsonObject(workspaceArtifactId, productionRequest);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.CreatedProductionSet", new Object[]{this.name, String.valueOf(createdProductionSetArtifactId)}));
                } else {
                    this.stageName = this.iu.getString("RelativityCreateProductionSetOperation.Stage.CreatingProductionSet");
                    this.percentageComplete = 0.75;
                    ProductionSetDetails details = new ProductionSetDetails();
                    details.setBrandingFont(this.brandingFont);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.BrandingFont", (Object)this.brandingFont));
                    details.setBrandingFontSize(this.brandingFontSize);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.BrandingFontSize", (Object)this.brandingFontSize));
                    details.setScaleBrandingFont(this.scaleBrandingFont);
                    this.addExecutionLog(this.iu.getString("RelativityCreateProductionSetOperation.Info.ScaleBrandingFont"));
                    details.setWrapBrandingText(this.wrapBrandingFont);
                    this.addExecutionLog(this.iu.getString("RelativityCreateProductionSetOperation.Info.WrapBrandingFont"));
                    ProductionSetNumbering numbering = new ProductionSetNumbering();
                    numbering.setAttachmentRelationalField(new ProductionSetAttachmentRelationalField());
                    numbering.setNumberingType(this.numberingType.getRelativityIdentifier());
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.NumberingType", (Object)this.numberingType.toString()));
                    numbering.setBatesPrefix(this.numberingPrefix);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.NumberingPrefix", (Object)this.numberingPrefix));
                    numbering.setBatesSuffix(this.numberingSuffix);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.NumberingSuffix", (Object)this.numberingSuffix));
                    numbering.setBatesStartNumber(this.numberingStartNumber);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.NumberingStartNumber", (Object)String.valueOf(this.numberingStartNumber)));
                    numbering.setNumberOfDigitsForDocumentNumbering(this.numberingDigits);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.NumberingDigits", (Object)String.valueOf(this.numberingDigits)));
                    request.setName(this.name);
                    request.setDetails(details);
                    request.setNumbering(numbering);
                    createdProductionSetArtifactId = this.relativityRestClient.createProductionSet(workspaceArtifactId, request);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.CreatedProductionSet", new Object[]{this.name, String.valueOf(createdProductionSetArtifactId)}));
                }
                this.stageName = this.iu.getString("RelativityCreateProductionSetOperation.Stage.PreparingProductionDataSources");
                this.percentageComplete = 0.75;
                ArrayList<Long> requestDataSources = new ArrayList<Long>();
                for (ProductionDataSource pds : this.productionDataSources) {
                    boolean usesAdditionalFields;
                    String name = this.executionContext.evalParameters(pds.getName(), this);
                    String savedSearchIdentifier = this.executionContext.evalParameters(pds.getSavedSearchIdentifier(), this);
                    String placeHolderIdentifier = this.executionContext.evalParameters(pds.getPlaceholderIdentifier(), this);
                    String markupSetIdentifier = this.executionContext.evalParameters(pds.getMarkupSetIdentifier(), this);
                    long savedSearchArtifactId = 0L;
                    long placeholderArtifactId = 0L;
                    long markupSetArtifactId = 0L;
                    List<EligibleObject> eligibleSavedSearches = this.relativityRestClient.querySavedSearches(workspaceArtifactId, pds.getSavedSearchIdentifierType(), savedSearchIdentifier);
                    EligibleObject eligibleSavedSearch = RelativityUtils.getInstance().filterAllEligibleObject(savedSearchIdentifier, pds.getSavedSearchIdentifierType(), eligibleSavedSearches, RelativityFieldType.SAVED_SEARCH);
                    if (eligibleSavedSearch == null) {
                        this.addWarning(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Exception.UnableToAddDatasource", new Object[]{pds.getName(), this.iu.getFormattedString("RelativityCreateProductionSetOperation.Exception.MissingSavedSearch", (Object)String.valueOf(savedSearchIdentifier))}));
                        continue;
                    }
                    savedSearchArtifactId = eligibleSavedSearch.getArtifactId();
                    boolean bl = usesAdditionalFields = pds.getProductionType() == ProductionDataSourceType.IMAGES || pds.getProductionType() == ProductionDataSourceType.IMAGES_AND_NATIVES;
                    if (usesAdditionalFields && pds.getUseImagePlaceholder() != ProductionDataSourceImagePlaceholderType.NEVER) {
                        List<EligibleObject> eligiblePlaceholders = this.relativityRestClient.queryProductionPlaceholders(workspaceArtifactId, pds.getPlaceholderIdentifierType(), placeHolderIdentifier);
                        EligibleObject eligiblePlaceholder = RelativityUtils.getInstance().filterAllEligibleObject(placeHolderIdentifier, pds.getPlaceholderIdentifierType(), eligiblePlaceholders, RelativityFieldType.PLACEHOLDER);
                        if (eligiblePlaceholder == null) {
                            this.addWarning(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Exception.UnableToAddDatasource", new Object[]{pds.getName(), this.iu.getFormattedString("RelativityCreateProductionSetOperation.Exception.MissingPlaceholder", (Object)String.valueOf(placeHolderIdentifier))}));
                            continue;
                        }
                        placeholderArtifactId = eligiblePlaceholder.getArtifactId();
                    }
                    if (usesAdditionalFields && pds.getUseImagePlaceholder() != ProductionDataSourceImagePlaceholderType.ALWAYS) {
                        List<EligibleObject> eligibleMarkupSets = this.relativityRestClient.queryMarkupSets(workspaceArtifactId, pds.getMarkupSetIdentifierType(), markupSetIdentifier);
                        EligibleObject eligibleMarkupSet = RelativityUtils.getInstance().filterAllEligibleObject(markupSetIdentifier, pds.getMarkupSetIdentifierType(), eligibleMarkupSets, RelativityFieldType.MARKUP_SET);
                        if (eligibleMarkupSet == null) {
                            this.addWarning(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Exception.UnableToAddDatasource", new Object[]{pds.getName(), this.iu.getFormattedString("RelativityCreateProductionSetOperation.Exception.MissingMarkup", (Object)String.valueOf(markupSetIdentifier))}));
                            continue;
                        }
                        markupSetArtifactId = eligibleMarkupSet.getArtifactId();
                    }
                    try {
                        ProductionSetDataSource ds = new ProductionSetDataSource(name, pds.getProductionType(), pds.getUseImagePlaceholder(), savedSearchArtifactId, placeholderArtifactId, markupSetArtifactId, pds.isBurnRedactions());
                        Long productionDataSourceArtifactId = this.relativityRestClient.createProductionDataSource(workspaceArtifactId, createdProductionSetArtifactId, ds);
                        requestDataSources.add(productionDataSourceArtifactId);
                        this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.CreatedProductionDataSource", new Object[]{name, String.valueOf(productionDataSourceArtifactId)}));
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to create production data source", (Throwable)e);
                        this.addWarning(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Exception.UnableToAddDatasource", new Object[]{pds.getName(), e.getMessage()}));
                    }
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateProductionSetOperation.Info.DatasourceCount", (Object)requestDataSources.size()));
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

