/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RelativityCreateSavedSearchOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.BooleanConditionOperator;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.DocumentField;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearch;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchRequest;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchScope;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchSortField;
import com.nuix.automate.workflow.core.utils.antlr.RelativitySearchCriteriaUtils;
import com.nuix.automate.workflow.core.utils.antlr.criteria.CriteriaCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelativityCreateSavedSearchOperationImplementation
extends RelativityCreateSavedSearchOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityCreateSavedSearchOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient int savedSearchesAdded;
    private transient int totalSavedSearches;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.savedSearchesAdded = 0;
                this.totalSavedSearches = 0;
                this.stageName = this.iu.getString("RelativityCreateSavedSearchOperation.Stage.PreparingSavedSearches");
                this.percentageComplete = 0.05;
                if (this.useSavedSearchesFile) {
                    if (this.savedSearchesFileName == null) {
                        this.savedSearchesFileName = "";
                    }
                    this.savedSearchesFileName = this.executionContext.evalParameters(this.savedSearchesFileName, this);
                    List lines = FileUtils.loadVariableColumnDetectFormatFile((File)new File(this.savedSearchesFileName));
                    lines.remove(0);
                    ArrayList savedSearchObjects = new ArrayList();
                    for (Object[] savedSearch : lines) {
                        String searchContainer = (String)savedSearch[0];
                        String name = (String)savedSearch[1];
                        String query = (String)savedSearch[2];
                        String scope = (String)savedSearch[3];
                        String scopeFolders = (String)savedSearch[4];
                        String fields = (String)savedSearch[5];
                        String sorts = (String)savedSearch[6];
                        searchContainer = this.executionContext.evalParameters(searchContainer, this);
                        name = this.executionContext.evalParameters(name, this);
                        query = this.executionContext.evalParameters(query, this);
                        scope = this.executionContext.evalParameters(scope, this);
                        scopeFolders = this.executionContext.evalParameters(scopeFolders, this);
                        fields = this.executionContext.evalParameters(fields, this);
                        sorts = this.executionContext.evalParameters(sorts, this);
                        SavedSearch savedSearchObject = new SavedSearch();
                        savedSearchObject.setSearchContainer(searchContainer);
                        savedSearchObject.setName(name);
                        savedSearchObject.setQuery(query);
                        savedSearchObject.setScope(SavedSearchScope.valueOf(scope));
                        savedSearchObject.setScopeFolder(scopeFolders);
                        savedSearchObject.setFields(fields);
                        savedSearchObject.setSorts(sorts);
                        savedSearchObjects.add(savedSearchObject);
                    }
                    this.savedSearches = savedSearchObjects;
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Info.SavedSearchesFileName", (Object)this.savedSearchesFileName));
                }
                ArrayList<SavedSearchRequest> savedSearchQueries = new ArrayList<SavedSearchRequest>();
                for (SavedSearch savedSearch : this.savedSearches) {
                    String[] fieldSplit;
                    String searchContainer = this.executionContext.evalParameters(savedSearch.getSearchContainer(), this);
                    String name = this.executionContext.evalParameters(savedSearch.getName(), this);
                    String query = this.executionContext.evalParameters(savedSearch.getQuery(), this);
                    String scopeFolders = this.executionContext.evalParameters(savedSearch.getScopeFolder(), this);
                    String fields = this.executionContext.evalParameters(savedSearch.getFields(), this);
                    String sorts = this.executionContext.evalParameters(savedSearch.getSorts(), this);
                    if (query.equals("[INVALID]")) {
                        throw new Exception(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Exception.InvalidSavedSearchQuery", (Object)name));
                    }
                    SavedSearchRequest search = new SavedSearchRequest();
                    search.setSearchContainer(searchContainer);
                    search.setName(name);
                    search.setQuery(query);
                    search.setScope(savedSearch.getScope());
                    String[] scopeFolderSplit = scopeFolders.split(",");
                    for (String f : scopeFolderSplit) {
                        if (f.trim().equals("")) continue;
                        search.getScopeFolders().add(f);
                    }
                    for (String string : fieldSplit = fields.split(",")) {
                        search.getFields().add(string.trim());
                    }
                    String[] sortSplit = sorts.split(",");
                    if (!sortSplit[0].trim().equals("")) {
                        void var17_30;
                        String[] stringArray = sortSplit;
                        int f = stringArray.length;
                        boolean bl = false;
                        while (var17_30 < f) {
                            String s = stringArray[var17_30];
                            String[] split = s.split("\\[");
                            if (split.length == 2) {
                                search.getSortingFields().add(new SavedSearchSortField(split[0].trim(), split[1].replace("]", "").trim()));
                            } else {
                                this.addWarning(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Warning.InvalidSortingField", new Object[]{name, s}));
                            }
                            ++var17_30;
                        }
                    }
                    savedSearchQueries.add(search);
                }
                this.totalSavedSearches = savedSearchQueries.size();
                this.stageName = this.iu.getString("RelativityCreateSavedSearchOperation.Stage.AddingSavedSearches");
                this.percentageComplete = 0.1;
                Map<String, DocumentField> workspaceFields = this.relativityRestClient.getDocumentSavedSearchFields(workspaceArtifactId);
                RelativitySearchCriteriaUtils utils = RelativitySearchCriteriaUtils.getInstance();
                Long rootSearchContainer = this.relativityRestClient.getSearchContainerRoot(workspaceArtifactId);
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Info.SavedSearchesCount", (Object)savedSearchQueries.size()));
                int totalSavedSearchesAdded = 0;
                int totalSavedSearchesErrored = 0;
                int totalSavedSearchesSkipped = 0;
                HashSet<String> specialFields = new HashSet<String>();
                specialFields.add("File Icon");
                specialFields.add("Edit");
                for (SavedSearchRequest savedSearch : savedSearchQueries) {
                    this.stageName = this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Stage.AddingSavedSearchesDetail", new Object[]{String.valueOf(this.savedSearchesAdded), String.valueOf(this.totalSavedSearches)});
                    this.percentageComplete = 0.1 + (double)this.savedSearchesAdded / (double)this.totalSavedSearches * 0.9;
                    try {
                        block40: {
                            Set<String> existingSavedSearches;
                            CriteriaCollection result = null;
                            if (savedSearch.getQuery().equals("")) {
                                result = new CriteriaCollection();
                                result.setBooleanOperator(BooleanConditionOperator.NONE);
                            } else {
                                result = utils.verifyAndGetSavedSearch(savedSearch.getQuery(), workspaceFields);
                            }
                            long searchContainerArtifactId = -1L;
                            if (savedSearch.getSearchContainer() != null && !savedSearch.getSearchContainer().trim().equals("")) {
                                String[] searchContainers = savedSearch.getSearchContainer().split("\\\\");
                                ArrayList searchContainerPath = new ArrayList();
                                for (String searchContainer : searchContainers) {
                                    if (searchContainer.trim().length() <= 0) continue;
                                    searchContainerPath.add(searchContainer.trim());
                                }
                                if (searchContainerPath.size() > 0) {
                                    searchContainerArtifactId = this.relativityRestClient.getOrCreateSearchContainer(workspaceArtifactId, rootSearchContainer, searchContainerPath);
                                }
                            }
                            if (searchContainerArtifactId != -1L) {
                                existingSavedSearches = this.relativityRestClient.getSearchContainerItemNames(workspaceArtifactId, searchContainerArtifactId);
                                if (existingSavedSearches.contains(savedSearch.getName())) {
                                    this.addWarning(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Warning.SavedSearchExistsDetailed", new Object[]{savedSearch.getName(), savedSearch.getSearchContainer()}));
                                    ++totalSavedSearchesSkipped;
                                    ++this.savedSearchesAdded;
                                    continue;
                                }
                            } else {
                                existingSavedSearches = this.relativityRestClient.getSearchContainerItemNames(workspaceArtifactId, rootSearchContainer);
                                if (existingSavedSearches.contains(savedSearch.getName())) {
                                    this.addWarning(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Warning.SavedSearchExists", (Object)savedSearch.getName()));
                                    ++totalSavedSearchesSkipped;
                                    ++this.savedSearchesAdded;
                                    continue;
                                }
                            }
                            ArrayList<Long> scopeFolderArtifactIds = new ArrayList<Long>();
                            if (savedSearch.getScopeFolders() != null && savedSearch.getScopeFolders().size() > 0) {
                                for (String string : savedSearch.getScopeFolders()) {
                                    String[] scopeFolders = string.split("\\\\");
                                    ArrayList<String> scopeFolderPath = new ArrayList<String>();
                                    for (String folder : scopeFolders) {
                                        scopeFolderPath.add(folder.trim());
                                    }
                                    if (scopeFolderPath.size() <= 0) continue;
                                    long scopeFolderArtifactId = this.relativityRestClient.getFolderArtifactIdId(workspaceArtifactId, scopeFolderPath, true);
                                    scopeFolderArtifactIds.add(scopeFolderArtifactId);
                                }
                                savedSearch.setScopeFolderArtifactIds(scopeFolderArtifactIds);
                            }
                            ArrayList<SavedSearchSortField> sortingFields = new ArrayList<SavedSearchSortField>();
                            if (savedSearch.getSortingFields() != null && savedSearch.getSortingFields().size() > 0) {
                                for (SavedSearchSortField sortField : savedSearch.getSortingFields()) {
                                    if (workspaceFields.containsKey(sortField.getName()) || specialFields.contains(sortField.getName())) {
                                        sortingFields.add(sortField);
                                        continue;
                                    }
                                    this.addWarning(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Warning.MissingSortingField", new Object[]{savedSearch.getName(), sortField.getName()}));
                                }
                            }
                            savedSearch.setSortingFields(sortingFields);
                            ArrayList<String> arrayList = new ArrayList<String>();
                            if (savedSearch.getFields() != null && savedSearch.getFields().size() > 0) {
                                for (String field : savedSearch.getFields()) {
                                    if (workspaceFields.containsKey(field) || specialFields.contains(field)) {
                                        arrayList.add(field);
                                        continue;
                                    }
                                    this.addWarning(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Warning.MissingField", new Object[]{savedSearch.getName(), field}));
                                }
                            }
                            savedSearch.setFields(arrayList);
                            Long savedSearchArtifactId = this.relativityRestClient.createSavedSearch(workspaceArtifactId, result, savedSearch);
                            if (searchContainerArtifactId != -1L) {
                                try {
                                    this.relativityRestClient.moveSavedSearch(workspaceArtifactId, searchContainerArtifactId, savedSearchArtifactId);
                                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Info.CreateSavedSearchInFolder", new Object[]{savedSearch.getName(), String.valueOf(savedSearchArtifactId), savedSearch.getSearchContainer()}));
                                    break block40;
                                }
                                catch (Exception e) {
                                    LOGGER.error("Cannot move saved search", (Throwable)e);
                                    ++totalSavedSearchesErrored;
                                    this.addWarning(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Warning.UnableToMoveSavedSearch", new Object[]{savedSearch.getName(), savedSearch.getSearchContainer(), e.getMessage()}));
                                    continue;
                                }
                            }
                            this.addExecutionLog(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Info.CreateSavedSearch", new Object[]{savedSearch.getName(), String.valueOf(savedSearchArtifactId)}));
                        }
                        ++totalSavedSearchesAdded;
                        ++this.savedSearchesAdded;
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot add saved search", (Throwable)e);
                        this.addWarning(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Warning.UnableToAddSavedSearch", new Object[]{savedSearch.getName(), e.getMessage()}));
                        ++totalSavedSearchesErrored;
                        ++this.savedSearchesAdded;
                    }
                }
                if (totalSavedSearchesAdded > 0) {
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Info.SavedSearchesAddedCount", (Object)totalSavedSearchesAdded));
                }
                if (totalSavedSearchesSkipped > 0) {
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Info.SavedSearchesSkippedCount", (Object)totalSavedSearchesSkipped));
                }
                if (totalSavedSearchesErrored > 0) {
                    this.addWarning(this.iu.getFormattedString("RelativityCreateSavedSearchOperation.Info.SavedSearchesErroredCount", (Object)totalSavedSearchesErrored));
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

