/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RelativityDeleteIndexOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleIndex;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityIndexType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RelativityDeleteIndexOperationImplementation
extends RelativityDeleteIndexOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityDeleteIndexOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.indexIdentifier = this.executionContext.evalParameters(this.indexIdentifier, this);
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.stageName = this.iu.getString("RelativityDeleteIndexOperation.Stage.DeletingIndex");
                this.percentageComplete = 0.25;
                this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteIndexOperation.Log.IndexType", (Object)this.indexType.toString()));
                switch (this.indexType) {
                    case CLASSIFICATION: 
                    case CONCEPTUAL: {
                        Map<RelativityIndexType, List<EligibleObject>> eligibleIndexes = this.relativityRestClient.queryAnalyticIndexes(workspaceArtifactId);
                        EligibleObject eligibleIndex = RelativityUtils.getInstance().filterEligibleObject(this.indexIdentifier, this.indexIdentifierType, eligibleIndexes.get((Object)this.indexType), RelativityFieldType.INDEX);
                        if (eligibleIndex == null) {
                            throw new Exception(this.iu.getFormattedString("RelativityDeleteIndexOperation.Exception.MissingIndex", new Object[]{this.indexType.toString(), String.valueOf(this.indexIdentifier)}));
                        }
                        this.relativityRestClient.deleteRelativityIndex(workspaceArtifactId, eligibleIndex.getArtifactId(), this.indexType);
                        this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteIndexOperation.Log.DeletedIndex", new Object[]{eligibleIndex.getName(), String.valueOf(eligibleIndex.getArtifactId())}));
                        break;
                    }
                    case DT_SEARCH: {
                        List<EligibleObject> eligibleDtSearches = this.relativityRestClient.getDtSearchIndexes(workspaceArtifactId, true);
                        EligibleObject eligibleDtIndex = RelativityUtils.getInstance().filterEligibleObject(this.indexIdentifier, this.indexIdentifierType, eligibleDtSearches, RelativityFieldType.DT_INDEX);
                        if (eligibleDtIndex == null) {
                            throw new Exception(this.iu.getFormattedString("RelativityDeleteIndexOperation.Exception.MissingIndex", new Object[]{this.indexType.toString(), String.valueOf(this.indexIdentifier)}));
                        }
                        this.relativityRestClient.deleteRelativityIndex(workspaceArtifactId, eligibleDtIndex.getArtifactId(), this.indexType);
                        this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteIndexOperation.Log.DeletedIndex", new Object[]{eligibleDtIndex.getName(), String.valueOf(eligibleDtIndex.getArtifactId())}));
                        break;
                    }
                    case ANY: {
                        ArrayList<EligibleObject> allIndexes = new ArrayList<EligibleObject>();
                        List<EligibleObject> dtIndexList = this.relativityRestClient.getDtSearchIndexes(workspaceArtifactId, true);
                        Map<RelativityIndexType, List<EligibleObject>> analyticIndexList = this.relativityRestClient.queryAnalyticIndexes(workspaceArtifactId);
                        for (EligibleObject eligibleObject : dtIndexList) {
                            allIndexes.add(new EligibleIndex(eligibleObject.getName(), eligibleObject.getArtifactId(), RelativityIndexType.DT_SEARCH));
                        }
                        for (Map.Entry entry : analyticIndexList.entrySet()) {
                            for (EligibleObject o : (List)entry.getValue()) {
                                allIndexes.add(new EligibleIndex(o.getName(), o.getArtifactId(), (RelativityIndexType)((Object)((Object)entry.getKey()))));
                            }
                        }
                        List<EligibleObject> results = RelativityUtils.getInstance().filterEligibleObjectsList(this.indexIdentifier, this.indexIdentifierType, allIndexes, RelativityFieldType.DT_INDEX);
                        if (results == null || results.size() == 0) {
                            throw new Exception(this.iu.getFormattedString("RelativityDeleteIndexOperation.Exception.MissingAnyIndex", (Object)String.valueOf(this.indexIdentifier)));
                        }
                        for (EligibleObject o : allIndexes) {
                            RelativityIndexType itemIndexType = ((EligibleIndex)o).getIndexType();
                            this.relativityRestClient.deleteRelativityIndex(workspaceArtifactId, o.getArtifactId(), itemIndexType);
                            this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteIndexOperation.Log.DeleteDetailed", new Object[]{itemIndexType.toString(), o.getName(), String.valueOf(o.getArtifactId())}));
                        }
                        break;
                    }
                    default: {
                        throw new Exception(this.iu.getFormattedString("RelativityDeleteIndexOperation.Exception.TypeNotImplemented", (Object)this.indexType.toString()));
                    }
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

