/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RelativityDeleteWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.util.List;

public class RelativityDeleteWorkspaceOperationImplementation
extends RelativityDeleteWorkspaceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityDeleteWorkspaceOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.workspaceIdentifier = this.executionContext.evalParameters(this.workspaceIdentifier, this);
                Long workspaceArtifactId = null;
                this.stageName = this.iu.getString("RelativityDeleteWorkspaceOperation.Stage.GettingWorkspace");
                this.percentageComplete = 0.25;
                List<EligibleObject> eligibleWorkspaces = this.relativityRestClient.queryEligibleWorkspaces(this.workspaceIdentifierType, this.workspaceIdentifier);
                EligibleObject eligibleWorkspace = RelativityUtils.getInstance().filterAllEligibleObject(this.workspaceIdentifier, this.workspaceIdentifierType, eligibleWorkspaces, RelativityFieldType.WORKSPACE);
                if (eligibleWorkspace == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityDeleteWorkspaceOperation.Exception.WorkspaceMissing", (Object)String.valueOf(this.workspaceIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteWorkspaceOperation.Info.WorkspaceIdentifier", (Object)String.valueOf(this.workspaceIdentifier)));
                workspaceArtifactId = eligibleWorkspace.getArtifactId();
                this.stageName = this.iu.getString("RelativityDeleteWorkspaceOperation.Stage.DeletingWorkspace");
                this.percentageComplete = 0.6;
                this.relativityRestClient.deleteWorkspace(workspaceArtifactId);
                this.addExecutionLog(this.iu.getFormattedString("RelativityDeleteWorkspaceOperation.Info.DeletedWorkspace", (Object)(String.valueOf(this.workspaceIdentifier) + ";" + String.valueOf(workspaceArtifactId))));
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

