/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityDtSearchIndexAction;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRow(name="dtSearchIndexIdentifierRow", children={"searchProviderIdentifierType", "searchProviderIdentifier"})
@OperationMetadata(alias=OperationAlias.RELATIVITY_MANAGE_DT_SEARCH, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"SEARCH", "MANAGEMENT"})})
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class RelativityDtSearchOperation
extends RelativityOperation {
    @FormField(allowedValues={"ARTIFACT_ID", "NAME", "NAME_REGEX"})
    @ExcludeFromPrintableOptions
    public RelativityIdentifierType searchProviderIdentifierType;
    @FormField
    public String searchProviderIdentifier;
    @FormField
    @ExcludeFromPrintableOptions
    public RelativityDtSearchIndexAction relativityDtSearchAction;
    @FormField
    @ExcludeFromPrintableOptions
    public Boolean waitForCompletion;

    public RelativityDtSearchOperation() {
        this.requiresCase = false;
        this.searchProviderIdentifier = "";
        this.searchProviderIdentifierType = RelativityIdentifierType.NAME;
        this.relativityDtSearchAction = RelativityDtSearchIndexAction.FULL;
        this.waitForCompletion = false;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityDtSearchOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedUseRelativityOperation = false;
        boolean detectedUseRelativityConfigureWorkspaceOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedUseRelativityOperation = true;
            }
            if (o instanceof RelativitySetWorkspaceOperation) {
                detectedUseRelativityConfigureWorkspaceOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedUseRelativityConfigureWorkspaceOperation) {
            prerequisites.add(this.iu.getString("RelativityCreateWorkspaceOperation.Prerequisites.MissingConfigureRelativityWorkspaceOperation"));
        }
        if (!detectedUseRelativityOperation) {
            prerequisites.add(this.iu.getString("RelativityCsvOverlayOperation.Prerequisites.MissingRelativityWorkspaceOperation"));
        }
        if (this.searchProviderIdentifier == null || this.searchProviderIdentifier.trim().equals("")) {
            prerequisites.add(this.iu.getString("RelativityDtSearchOperation.Prerequisites.MissingSearchProvider"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

