/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.relativity.RelativityRestVersion;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityDtSearchOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.IndexBuildProgress;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityDtSearchIndexAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.IOException;
import java.util.List;

public class RelativityDtSearchOperationImplementation
extends RelativityDtSearchOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityDtSearchOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    public RelativityDtSearchOperationImplementation() {
        this.requiresCase = false;
        this.searchProviderIdentifier = "";
        this.searchProviderIdentifierType = RelativityIdentifierType.NAME;
        this.relativityDtSearchAction = RelativityDtSearchIndexAction.FULL;
        this.waitForCompletion = false;
    }

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                RelativityRestVersion relativityRestVersion = RelativityRestVersion.valueOf((String)this.executionContext.evalParameters("{wfn_relativity_rest_version}", this));
                if (relativityRestVersion == RelativityRestVersion.RSAPI) {
                    throw new IOException(this.iu.getString("RelativityScriptOperation.Exception.CannotRunScriptRSAPI"));
                }
                this.initializeRelativityClient(relativityRestVersion);
                this.assertRelativityInstanceLicensed();
                Long relativityWorkspaceId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.searchProviderIdentifier = this.executionContext.evalParameters(this.searchProviderIdentifier, this);
                this.stageName = this.iu.getString("RelativityDtSearchOperation.Stage.GettingSearchProvider");
                long relativitySearchProviderArtifactId = -1L;
                List<EligibleObject> eligibleSearchProviders = this.relativityRestClient.getDtSearchIndexes(relativityWorkspaceId, true);
                EligibleObject eligibleSearchProvider = RelativityUtils.getInstance().filterEligibleObject(this.searchProviderIdentifier, this.searchProviderIdentifierType, eligibleSearchProviders, RelativityFieldType.DT_INDEX);
                if (eligibleSearchProvider == null) {
                    List<EligibleObject> eligibleSearchProvidersTemp = this.relativityRestClient.getDtSearchIndexes(relativityWorkspaceId, false);
                    EligibleObject eligibleSearchProviderTemp = RelativityUtils.getInstance().filterEligibleObject(this.searchProviderIdentifier, this.searchProviderIdentifierType, eligibleSearchProvidersTemp, RelativityFieldType.DT_INDEX);
                    if (eligibleSearchProviderTemp != null) {
                        throw new Exception(this.iu.getFormattedString("RelativityDtSearchOperation.Exception.NotDtSearchProvider", new Object[]{this.searchProviderIdentifier}));
                    }
                    throw new Exception(this.iu.getFormattedString("RelativityDtSearchOperation.Exception.MissingSearchProvider", new Object[]{this.searchProviderIdentifier}));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityDtSearchOperation.Log.SearchProvider", (Object)eligibleSearchProvider.getName()));
                relativitySearchProviderArtifactId = eligibleSearchProvider.getArtifactId();
                this.percentageComplete = 0.1;
                this.addExecutionLog(this.iu.getFormattedString("RelativityDtSearchOperation.Log.RunningAction", (Object)this.relativityDtSearchAction.toString()));
                switch (this.relativityDtSearchAction) {
                    default: {
                        this.stageName = this.iu.getString("RelativityDtSearchOperation.Stage.Building");
                        break;
                    }
                    case ACTIVATE: {
                        this.stageName = this.iu.getString("RelativityDtSearchOperation.Stage.Activating");
                        break;
                    }
                    case COMPRESS: {
                        this.stageName = this.iu.getString("RelativityDtSearchOperation.Stage.Compressing");
                        break;
                    }
                    case DEACTIVATE: {
                        this.stageName = this.iu.getString("RelativityDtSearchOperation.Stage.Deactivating");
                    }
                }
                this.percentageComplete = 0.33;
                this.relativityRestClient.runDtSearchIndexAction(relativityWorkspaceId, relativitySearchProviderArtifactId, this.relativityDtSearchAction);
                this.percentageComplete = 0.45;
                if (this.waitForCompletion.booleanValue()) {
                    this.addExecutionLog(this.iu.getFormattedString("RelativityDtSearchOperation.Log.WaitingForActionToFinish", (Object)this.relativityDtSearchAction));
                    IndexBuildProgress progress = null;
                    while (true) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        progress = this.relativityRestClient.getIndexBuildProgress(relativityWorkspaceId, relativitySearchProviderArtifactId);
                        if (progress != null) {
                            if (progress.getJobStage() != null) {
                                if (progress.getJobStage() == -999) break;
                                this.percentageComplete = 0.45 + (double)progress.getJobStage().intValue() * 0.125;
                            }
                            if (progress.getJobStatus() != null && !progress.getJobStatus().equals(this.stageName)) {
                                this.stageName = progress.getJobStatus();
                            }
                        }
                        Thread.sleep(1000L);
                    }
                    if (progress.getTotalIndexed() != null) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityDtSearchOperation.Log.TotalIndexed", (Object)progress.getTotalIndexed()));
                    }
                    if (progress.getTotalErrored() != null) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityDtSearchOperation.Log.TotalErrored", (Object)progress.getTotalErrored()));
                    }
                }
                this.percentageComplete = 0.99;
                this.addExecutionLog(this.iu.getFormattedString("RelativityDtSearchOperation.Log.FinishedCommand", (Object)this.relativityDtSearchAction));
                this.trackFinished();
            }
            catch (Exception e) {
                LOGGER.error("Operation unchecked exception", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

