/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ExportMetadataType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceIdentifierType;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRows(value={@FormFieldRow(name="metadataTypeIdentifierRow", children={"metadataTypeIdentifierType", "metadataTypeIdentifier"}), @FormFieldRow(name="useCustomConditionRow", children={"useCustomCondition", "customCondition"})})
@FormFieldGroup(name="outputGroup", children={"writeOutput", "outputLocation", "customOutputTemplatePath"})
@OperationMetadata(alias=OperationAlias.RELATIVITY_EXPORT_VIEW, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"EXPORT"})})
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class RelativityExportViewOperation
extends RelativityOperation {
    @FormField
    public ExportMetadataType metadataType;
    @FormField(allowedValues={"ARTIFACT_ID", "NAME", "NAME_LIKE"})
    public RelativityIdentifierType metadataTypeIdentifierType;
    @FormField
    public String metadataTypeIdentifier;
    @FormField
    public boolean useCustomCondition;
    @FormField(enableOn={@OnField(name="useCustomCondition")})
    public String customCondition;
    @FormField(allowedValues={"CURRENT_WORKSPACE", "ADMIN_WORKSPACE"})
    public WorkspaceIdentifierType metadataTypeLocation;
    @FormField
    public boolean writeOutput;
    @FormField(enableOn={@OnField(name="writeOutput")})
    public String outputLocation;
    @FormField(required=false, enableOn={@OnField(name="writeOutput")})
    public String customOutputTemplatePath;

    public boolean getDisplayOutputLocation() {
        return this.writeOutput;
    }

    public boolean getDisplayCustomOutputTemplatePath() {
        return this.writeOutput;
    }

    public RelativityExportViewOperation() {
        this.requiresCase = false;
        this.metadataType = ExportMetadataType.VIEW;
        this.metadataTypeIdentifierType = RelativityIdentifierType.NAME;
        this.metadataTypeLocation = WorkspaceIdentifierType.CURRENT_WORKSPACE;
        this.metadataTypeIdentifier = "Documents";
        this.useCustomCondition = false;
        this.customCondition = "";
        this.writeOutput = false;
        this.outputLocation = "";
        this.customOutputTemplatePath = "";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityExportViewOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureRelativityConnectionOperation = false;
        boolean detectedSetRelativityWorkspaceOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o instanceof RelativitySetWorkspaceOperation) {
                detectedSetRelativityWorkspaceOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (this.metadataTypeLocation == WorkspaceIdentifierType.ADMIN_WORKSPACE && !detectedSetRelativityWorkspaceOperation) {
            prerequisites.add(this.iu.getString("RelativitySetWorkspaceOperation.Prerequisites.Missing"));
        }
        if (this.metadataTypeIdentifier == null || this.metadataTypeIdentifier.trim().equals("")) {
            prerequisites.add(this.iu.getFormattedString("RelativityExportViewOperation.Prerequisites.MissingMetadataTypeIdentifier", (Object)this.metadataType.toString()));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

