/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.aspose.cells.Cell;
import com.aspose.cells.CellsException;
import com.aspose.cells.FindOptions;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityExportViewOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativityView;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ExportMetadataType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchDetails;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceIdentifierType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.objectmanager.ObjectManagerQuery;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.objectmanager.ObjectManagerQueryRequest;
import com.nuix.automate.workflow.core.execution.options.report.TemplateWorksheetName;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class RelativityExportViewOperationImplementation
extends RelativityExportViewOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityExportViewOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient String sheetName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.metadataTypeIdentifier = this.executionContext.evalParameters(this.metadataTypeIdentifier, this);
                this.outputLocation = this.executionContext.evalParameters(this.outputLocation, this);
                this.customOutputTemplatePath = this.executionContext.evalParameters(this.customOutputTemplatePath, this);
                this.customCondition = this.executionContext.evalParameters(this.customCondition, this);
                String workspaceName = "";
                Long workspaceArtifactId = -1L;
                if (this.metadataTypeLocation == WorkspaceIdentifierType.CURRENT_WORKSPACE) {
                    workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                    workspaceName = this.executionContext.evalParameters("{relativity_workspace_name}", this);
                }
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                this.stageName = this.iu.getString("RelativityExportViewOperation.Stage.GettingMetadataType");
                this.percentageComplete = 0.1;
                this.addExecutionLog(this.iu.getFormattedString("RelativityExportViewOperation.Info.MetadataTypeLog", (Object)this.metadataType.toString()));
                if (this.useCustomCondition) {
                    this.customCondition = this.encodeForQuery(this.customCondition);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityExportViewOperation.Info.CustomCondition", (Object)this.customCondition));
                }
                List<EligibleObject> eligibleMetadataTypes = this.relativityRestClient.getMetadataTypes(workspaceArtifactId, this.metadataTypeIdentifierType, this.metadataTypeIdentifier, this.metadataType);
                EligibleObject eligibleMetadataType = RelativityUtils.getInstance().filterAllEligibleObject(this.metadataTypeIdentifier, this.metadataTypeIdentifierType, eligibleMetadataTypes, RelativityFieldType.VIEW);
                if (eligibleMetadataType == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityExportViewOperation.Exception.MissingMetadataType", new Object[]{this.metadataType.toString(), String.valueOf(this.metadataTypeIdentifier)}));
                }
                Long metadataTypeArtifactId = eligibleMetadataType.getArtifactId();
                this.sheetName = eligibleMetadataType.getName();
                this.addExecutionLog(this.iu.getFormattedString("RelativityExportViewOperation.Info.MetadataType", new Object[]{this.metadataType.toString(), eligibleMetadataType.getName(), String.valueOf(eligibleMetadataType.getArtifactId())}));
                Long objectTypeArtifactId = 10L;
                List<String> headers = null;
                if (this.metadataType == ExportMetadataType.VIEW) {
                    RelativityView view = this.relativityRestClient.getRelativityView(workspaceArtifactId, metadataTypeArtifactId);
                    objectTypeArtifactId = view.getArtifactTypeId();
                    headers = view.getFields();
                } else {
                    SavedSearchDetails savedSearchDetails = this.relativityRestClient.readSavedSearchNoCondition(workspaceArtifactId, metadataTypeArtifactId);
                    headers = savedSearchDetails.getFieldNames();
                }
                if (this.writeOutput) {
                    int templateWorksheetIndex;
                    Object buffer;
                    this.stageName = this.iu.getFormattedString("RelativityExportViewOperation.Stage.ExportingMetadataType", (Object)this.metadataType.toString());
                    this.percentageComplete = 0.25;
                    if (this.metadataTypeLocation == WorkspaceIdentifierType.CURRENT_WORKSPACE) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityExportViewOperation.Info.ExportFromWorkspace", new Object[]{this.metadataType.toString(), workspaceName, String.valueOf(workspaceArtifactId)}));
                    }
                    int totalObjectCount = this.relativityRestClient.queryTotalMetadataTypeObjects(workspaceArtifactId, metadataTypeArtifactId, objectTypeArtifactId, this.metadataType, this.customCondition);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityExportViewOperation.Info.MetadataTypeItemCount", new Object[]{this.metadataType.toString(), String.valueOf(totalObjectCount)}));
                    Object queryCondition = "";
                    String relativityType = this.metadataType == ExportMetadataType.VIEW ? "VIEW" : "SAVEDSEARCH";
                    queryCondition = this.useCustomCondition ? this.encodeForQuery(this.customCondition) : "(('Artifact ID' IN " + relativityType + " " + metadataTypeArtifactId + "))";
                    ObjectManagerQuery query = new ObjectManagerQuery.ObjectManagerQueryBuilder().setWorkspaceArtifactId(workspaceArtifactId).setCondition((String)queryCondition).setObjectTypeId(objectTypeArtifactId).withExecutionMetadataId(this.metadataType, metadataTypeArtifactId).addFields(headers.toArray(new String[0])).build();
                    ObjectManagerQueryRequest request = new ObjectManagerQueryRequest(query, 1, 10000);
                    AsposeUtils.applyAsposeCellsLicense();
                    LoadOptions loadOptions = new LoadOptions(6);
                    File templateFile = null;
                    if (this.customOutputTemplatePath.length() > 0 && !(templateFile = new File(this.customOutputTemplatePath)).exists()) {
                        LOGGER.error("Cannot find report template file " + templateFile.getAbsolutePath());
                        this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CouldNotFindReportTemplate", (Object)templateFile.getAbsoluteFile()));
                    }
                    if (templateFile == null || !templateFile.exists()) {
                        templateFile = this.executionContext.getReportTemplate();
                        LOGGER.info("Cannot find report template file " + templateFile.getAbsolutePath() + ". Creating default file");
                        File templateFolder = templateFile.getParentFile();
                        if (!templateFolder.exists()) {
                            LOGGER.info("Creating folder " + templateFolder.getAbsolutePath());
                            templateFolder.mkdirs();
                        }
                        try (InputStream templateStream = this.getClass().getResourceAsStream("/reports/template.xlsx");
                             OutputStream outputStream = Files.newOutputStream(templateFile.toPath(), new OpenOption[0]);){
                            int bytesRead;
                            buffer = new byte[1024];
                            while ((bytesRead = templateStream.read((byte[])buffer)) != -1) {
                                outputStream.write((byte[])buffer, 0, bytesRead);
                            }
                            templateStream.close();
                            outputStream.flush();
                        }
                    }
                    Workbook workbook = new Workbook(templateFile.getAbsolutePath(), loadOptions);
                    for (int worksheetId = 0; worksheetId < workbook.getWorksheets().getCount(); ++worksheetId) {
                        Worksheet worksheet = workbook.getWorksheets().get(worksheetId);
                        LOGGER.info("Pre-processing worksheet " + worksheet.getName());
                        buffer = this.executionContext.getParameterNames().iterator();
                        while (buffer.hasNext()) {
                            String placeholder = (String)buffer.next();
                            try {
                                FindOptions findOptions = new FindOptions();
                                findOptions.setLookAtType(3);
                                findOptions.setLookInType(1);
                                Cell matchingCell = null;
                                while ((matchingCell = worksheet.getCells().find((Object)placeholder, matchingCell, findOptions)) != null) {
                                    String unpackedPlaceholder = this.executionContext.evalParameters(placeholder, this);
                                    if (placeholder.equals("{date_spreadsheet}") || placeholder.equals("{date_time_spreadsheet}")) {
                                        matchingCell.setValue((Object)Calendar.getInstance());
                                    } else if (placeholder.equals("{time_spreadsheet}")) {
                                        matchingCell.setValue((Object)new Date());
                                    } else {
                                        matchingCell.setValue((Object)unpackedPlaceholder);
                                    }
                                    LOGGER.info("Searching for " + placeholder + ", got " + String.valueOf(matchingCell));
                                }
                            }
                            catch (Exception e) {
                                LOGGER.info("Cannot unpack placeholder " + placeholder, (Throwable)e);
                            }
                        }
                    }
                    String treeSizeWorksheetName = TemplateWorksheetName.TEMPLATE_METADATA.toString();
                    HashSet<String> worksheetNames = new HashSet<String>();
                    for (Object o : workbook.getWorksheets()) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        Worksheet worksheet = (Worksheet)o;
                        worksheetNames.add(worksheet.getName());
                    }
                    try {
                        templateWorksheetIndex = workbook.getWorksheets().addCopy(treeSizeWorksheetName);
                    }
                    catch (CellsException e) {
                        this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.TemplateFileNoWorksheetNamed", (Object)treeSizeWorksheetName));
                        return;
                    }
                    Worksheet worksheet = workbook.getWorksheets().get(templateWorksheetIndex);
                    try {
                        worksheet.setName(this.sheetName);
                    }
                    catch (CellsException e) {
                        this.addWarning(this.iu.getFormattedString("ProcessingReportOperation.Warning.CannotSetSheetName", new Object[]{this.sheetName, e.getMessage()}));
                        worksheet.setName("Sheet 1");
                    }
                    int sr = 0;
                    int sc = 0;
                    FindOptions findOptions = new FindOptions();
                    findOptions.setLookAtType(0);
                    findOptions.setLookInType(1);
                    Cell matchingCell = null;
                    matchingCell = worksheet.getCells().find((Object)"__START__", matchingCell, findOptions);
                    if (matchingCell != null) {
                        sr = matchingCell.getRow();
                        sc = matchingCell.getColumn();
                    }
                    matchingCell = null;
                    matchingCell = worksheet.getCells().find((Object)"{view_name}", matchingCell, findOptions);
                    if (matchingCell != null) {
                        matchingCell.setValue((Object)this.iu.getFormattedString("RelativityExportViewOperation.Report.MetadataTypeReport", (Object)this.metadataType.toString()));
                    }
                    int rowId = 3;
                    int columnId = 0;
                    int processedItems = 0;
                    int columnsCount = headers.size();
                    if (columnsCount > 3) {
                        for (int i = 0; i < columnsCount - 3; ++i) {
                            worksheet.getCells().insertColumn(sc + 2);
                            worksheet.getCells().copyColumn(worksheet.getCells(), sc + 1, sc + 2);
                        }
                    } else if (columnsCount == 2) {
                        worksheet.getCells().deleteColumn(sc + 1);
                    } else if (columnsCount == 1) {
                        worksheet.getCells().deleteColumn(sc + 1);
                        worksheet.getCells().deleteColumn(sc + 1);
                    }
                    for (String string : headers) {
                        worksheet.getCells().get(sr, sc + columnId).setValue((Object)string);
                        ++columnId;
                    }
                    while (true) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        List<Object[]> objects = this.relativityRestClient.queryMetadataTypeObjectsPaged(request);
                        for (Object[] result : objects) {
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            worksheet.getCells().insertRow(sr + ++rowId);
                            Boolean isLastRow = processedItems == totalObjectCount - 1;
                            TemplateWorksheetName[] isFirstRow = Boolean.valueOf(processedItems == 0);
                            if (isFirstRow.booleanValue()) {
                                worksheet.getCells().copyRow(worksheet.getCells(), sr + 1, sr + rowId);
                            } else if (!isLastRow.booleanValue()) {
                                worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
                            } else {
                                worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
                            }
                            int column = 0;
                            for (Object value : result) {
                                worksheet.getCells().get(sr + rowId, sc + column++).setValue(value);
                            }
                            ++processedItems;
                        }
                        if (processedItems >= totalObjectCount) break;
                        request.setNextPage(objects.size());
                        this.stageName = this.iu.getFormattedString("RelativityExportViewOperation.Stage.ExportingMetadataTypeDetailed", new Object[]{String.valueOf(processedItems), String.valueOf(totalObjectCount)});
                        this.percentageComplete = 0.25 + (double)processedItems / (double)totalObjectCount * 0.75;
                    }
                    int n = this.relativityRestClient.queryTotalMetadataTypeObjects(workspaceArtifactId, metadataTypeArtifactId, objectTypeArtifactId, this.metadataType, this.customCondition);
                    if (totalObjectCount != n) {
                        this.addWarning(this.iu.getFormattedString("RelativityExportViewOperation.Warning.ResultsMissing", (Object)this.metadataType.toString()));
                    }
                    worksheet.getCells().deleteRow(sr + 1);
                    worksheet.getCells().deleteRow(sr + 1);
                    worksheet.getCells().deleteRow(sr + 1);
                    workbook.getBuiltInDocumentProperties().setAuthor("Automate Workflow");
                    this.outputLocation = this.executionContext.evalParameters(this.outputLocation, this);
                    File reportFile = new File(this.outputLocation);
                    this.outputLocation = reportFile.getAbsolutePath();
                    File reportFolder = reportFile.getParentFile();
                    if (!reportFolder.exists()) {
                        reportFolder.mkdirs();
                    }
                    if (reportFile.getAbsolutePath().toLowerCase().endsWith(".csv")) {
                        for (String worksheetName : worksheetNames) {
                            try {
                                workbook.getWorksheets().removeAt(worksheetName);
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot remove sheet " + worksheetName);
                            }
                        }
                    } else {
                        for (TemplateWorksheetName templateWorksheetName : TemplateWorksheetName.values()) {
                            try {
                                workbook.getWorksheets().removeAt(templateWorksheetName.toString());
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot remove sheet " + String.valueOf((Object)templateWorksheetName));
                            }
                        }
                    }
                    LOGGER.info("Saving report to " + reportFile.getAbsolutePath());
                    if (reportFile.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
                        PdfSaveOptions saveOptions = new PdfSaveOptions();
                        saveOptions.setAllColumnsInOnePagePerSheet(true);
                        workbook.save(reportFile.getAbsolutePath(), (SaveOptions)saveOptions);
                    } else if (reportFile.getAbsolutePath().toLowerCase().endsWith(".csv")) {
                        workbook.save(reportFile.getAbsolutePath(), 1);
                    } else {
                        String reportPasswordParameter = "{report_password}";
                        String reportPassword = this.executionContext.evalParameters(reportPasswordParameter, this);
                        if (!reportPassword.equals(reportPasswordParameter)) {
                            this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SettingPassword"));
                            if (reportPassword.length() == 0) {
                                this.addWarning(this.iu.getString("ProcessingReportOperation.Log.BlankPassword"));
                            }
                            workbook.setEncryptionOptions(3, 128);
                            workbook.getSettings().setPassword(reportPassword);
                        }
                        workbook.save(reportFile.getAbsolutePath());
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunScriptOperation.Info.OutputLocation", (Object)reportFile.getAbsolutePath()));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_report_file}", reportFile.getAbsolutePath())));
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    protected String encodeForQuery(String text) {
        String result = text;
        result = StringEscapeUtils.escapeJava((String)result);
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

