/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.relativity.RelativityRestVersion;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.security.WinDPAPIEncyptor;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityImagesOverlayOperation;
import com.nuix.automate.workflow.core.utils.relativity.RelativityRestException;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.NotImplementedException;

public class RelativityImagesOverlayOperationImplementation
extends RelativityImagesOverlayOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityImagesOverlayOperation.class);
    private transient long linesInScope;
    private transient Set<Integer> lineIdsFailed;
    private transient AtomicInteger imagesOverlayed = new AtomicInteger();
    private transient String relativityUsername;
    private transient String relativityPassword;
    private transient String relativityWorkspaceId;
    private transient String relativityHostname;
    private transient String relativityEndpointType;
    private transient String relativityImportThreads;
    private transient String relativityImportThreadTimeout;
    private transient String relativityImportThreadRetries;
    private transient List<File> loadfiles;
    private transient int currentLoadfileId;
    private transient boolean relativityFatalErrorEncountered;
    private transient Process relativityLoadProcess;
    private transient long identityFieldId;
    private transient Thread readStandardOutputThread;
    private transient Thread readStandardErrorThread;

    @Override
    public void startTriggered() throws Exception {
        this.loadfileLocation = this.executionContext.evalParameters(this.loadfileLocation, this);
        this.loadfiles = new ArrayList<File>();
        this.relativityUsername = this.executionContext.evalParameters("{wfn_relativity_username}", this);
        this.relativityWorkspaceId = this.executionContext.evalParameters("{relativity_workspace_id}", this);
        this.identityField = this.executionContext.evalParameters(this.identityField, this);
        this.relativityHostname = this.executionContext.evalParameters("{wfn_relativity_hostname}", this);
        this.relativityEndpointType = this.executionContext.evalParameters("{wfn_relativity_endpoint_type}", this);
        this.relativityImportThreads = this.executionContext.evalParameters("{wfn_relativity_import_threads}", this);
        this.relativityImportThreadTimeout = this.executionContext.evalParameters("{wfn_relativity_import_thread_timeout}", this);
        this.relativityImportThreadRetries = this.executionContext.evalParameters("{wfn_relativity_import_thread_retries}", this);
        this.relativityPassword = this.executionContext.evalProtectedParameter("{wfn_relativity_password}");
        File exportLocationFile = new File(this.loadfileLocation);
        if (!exportLocationFile.exists()) {
            throw new FileNotFoundException(this.iu.getFormattedString("RelativityLoadfileUploadOperation.Exception.LocationNotFound", (Object)exportLocationFile.getAbsoluteFile()));
        }
        RelativityRestVersion relativityRestVersion = RelativityRestVersion.REST_V1;
        this.startTriggerThread = new Thread(() -> {
            try {
                try {
                    this.initializeRelativityClient(relativityRestVersion);
                    switch (this.identityFieldType) {
                        case NAME: {
                            this.addExecutionLog(this.iu.getFormattedString("RelativityImagesOverlayOperation.Log.IdentifierFieldName", (Object)this.identityField));
                            this.identityFieldId = Long.parseLong(this.relativityRestClient.getFieldId(this.identityField, this.relativityWorkspaceId));
                            this.addExecutionLog(this.iu.getFormattedString("RelativityImagesOverlayOperation.Log.IdentifierFieldId", (Object)("" + this.identityFieldId)));
                            break;
                        }
                        case ARTIFACT_ID: {
                            this.addExecutionLog(this.iu.getFormattedString("RelativityImagesOverlayOperation.Log.IdentifierFieldId", (Object)this.identityField));
                            this.identityFieldId = Long.parseLong(this.identityField);
                            try {
                                String identityFieldName = this.relativityRestClient.getFieldName(this.identityField, this.relativityWorkspaceId, true);
                                this.addExecutionLog(this.iu.getFormattedString("RelativityImagesOverlayOperation.Log.IdentifierFieldName", (Object)identityFieldName));
                            }
                            catch (IOException e) {
                                this.addWarning(this.iu.getFormattedString("RelativityImagesOverlayOperation.Warning.CannotVerifyIdentifierField", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false)));
                            }
                            break;
                        }
                        default: {
                            throw new NotImplementedException("Identity field identifier type " + String.valueOf(this.identityFieldType) + " not supported");
                        }
                    }
                }
                catch (RelativityRestException re) {
                    throw new IOException(this.iu.getFormattedString("RelativityImagesOverlayOperation.Warning.CannotVerifyIdentifierField", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)re, (boolean)false)), re);
                }
                if (exportLocationFile.isFile()) {
                    this.loadfiles.add(exportLocationFile);
                } else if (exportLocationFile.isDirectory()) {
                    ArrayList<File> candidateFolders = new ArrayList<File>();
                    candidateFolders.add(exportLocationFile);
                    if (this.detectExportInParts) {
                        this.addExecutionLog(this.iu.getString("RelativityLoadfileUploadOperation.Log.DetectExportInParts"));
                        for (File folder : exportLocationFile.listFiles()) {
                            if (!folder.isDirectory() || !folder.getName().startsWith("Part")) continue;
                            candidateFolders.add(folder);
                        }
                    }
                    for (File folder : candidateFolders) {
                        File candidateLoadfile = new File(folder.getAbsolutePath() + "/loadfile.opt");
                        if (candidateLoadfile.exists()) {
                            this.addExecutionLog(this.iu.getFormattedString("RelativityLoadfileUploadOperation.Log.DetectedLoadfile", (Object)candidateLoadfile.getAbsolutePath()));
                            this.loadfiles.add(candidateLoadfile);
                        }
                        for (int loadfileId = 1; loadfileId < 999999 && (candidateLoadfile = new File(folder.getAbsolutePath() + "/loadfile_" + loadfileId + ".opt")).exists(); ++loadfileId) {
                            this.addExecutionLog(this.iu.getFormattedString("RelativityLoadfileUploadOperation.Log.DetectedLoadfile", (Object)candidateLoadfile.getAbsolutePath()));
                            this.loadfiles.add(candidateLoadfile);
                        }
                    }
                }
                if (this.loadfiles.size() == 0) {
                    this.exception = new Exception(this.iu.getFormattedString("RelativityLoadfileUploadOperation.Exception.NoLoadfilesFoundAt", (Object)exportLocationFile.getAbsoluteFile()));
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                try {
                    this.relativityPassword = new WinDPAPIEncyptor().encrypt(this.relativityPassword);
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot encrypt password", (Throwable)e);
                }
                this.currentLoadfileId = 0;
                for (File loadfile : this.loadfiles) {
                    this.imagesOverlayed = new AtomicInteger(0);
                    this.lineIdsFailed = new HashSet<Integer>();
                    this.uploadLoadfile(loadfile.getAbsolutePath());
                    if (this.lineIdsFailed.size() > 0 || this.relativityFatalErrorEncountered) {
                        if (this.relativityFatalErrorEncountered) {
                            this.addWarning(this.iu.getNumeralString("RelativityLoadfileUploadOperation.Warning.LineIdsCouldNotBeFullyLoadedIntoRelativityError", (long)this.lineIdsFailed.size()));
                        } else {
                            this.addWarning(this.iu.getNumeralString("RelativityLoadfileUploadOperation.Warning.LineIdsCouldNotBeFullyLoadedIntoRelativity", (long)this.lineIdsFailed.size()));
                        }
                    }
                    this.linesInScope = 0L;
                    ++this.currentLoadfileId;
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Aborting operation");
                this.stopLoad();
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                String message = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
                if (message != null && this.relativityPassword != null) {
                    message = message.replace(this.relativityPassword, Parameter.MASKED_VALUE);
                }
                this.exception = new Exception(message);
                this.executionState = ExecutionState.ERROR;
                return;
            }
            if (this.relativityFatalErrorEncountered) {
                this.exception = new Exception(this.iu.getFormattedString("RelativityOperation.Error.CriticalError", new Object[0]));
                this.executionState = ExecutionState.ERROR;
            } else {
                this.trackFinished();
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void readOutputStream(BufferedReader standardInputReader) throws IOException {
        String line;
        int lastObservedProgress = 0;
        boolean fatalErrorEncountered = false;
        String notMapped = "[NOT MAPPED";
        String ignoreNotMapped = "Source field [parent folder identifier]";
        Pattern progressPattern = Pattern.compile("\\[Progress Info: ?(\\d+)");
        Pattern errorLinePattern = Pattern.compile("error: line: (\\d+)");
        Pattern totalLinesPattern = Pattern.compile("Loadfile records count: (\\d+)");
        Pattern transferModePattern = Pattern.compile("Status - Created transfer client '([^\\']+)' using a best-fit strategy.");
        boolean transferModePatternPrinted = false;
        int lineNumber = 0;
        boolean enableVerboseLogging = Boolean.parseBoolean(System.getProperty("automate.relativity.verbose_logging"));
        while ((line = standardInputReader.readLine()) != null) {
            Matcher transferModeMatcher;
            Matcher totalRecordsMatcher;
            int lineId;
            Matcher errorMatcher;
            Matcher progressMatcher;
            if (enableVerboseLogging || lineNumber < 1000) {
                LOGGER.info(line);
                if (++lineNumber == 1000 && !enableVerboseLogging) {
                    LOGGER.info("Relativity verbose logging is disabled, to enable verbose logging use the command-line flag -Dautomate.relativity.verbose_logging=true");
                }
            }
            if ((progressMatcher = progressPattern.matcher(line)).find()) {
                try {
                    lastObservedProgress = Integer.parseInt(progressMatcher.group(1));
                    this.imagesOverlayed.set(Math.max(this.imagesOverlayed.get(), Integer.parseInt(progressMatcher.group(1))));
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot extract progress from line", (Throwable)e);
                }
            }
            if ((errorMatcher = errorLinePattern.matcher(line)).find()) {
                try {
                    lineId = Integer.parseInt(errorMatcher.group(1));
                    this.lineIdsFailed.add(lineId);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot extract line with error", (Throwable)e);
                }
            }
            if (line.startsWith("Unhandled Exception:") || line.startsWith("exception:") || line.contains("fatal error: ")) {
                if (!fatalErrorEncountered) {
                    lineId = lastObservedProgress;
                    while ((long)lineId < this.linesInScope) {
                        this.lineIdsFailed.add(lineId);
                        ++lineId;
                    }
                    fatalErrorEncountered = true;
                    this.relativityFatalErrorEncountered = true;
                    this.addWarning(this.iu.getFormattedString("RelativityLoadfileUploadOperation.Warning.LoadingToRelativityFatalErrors", (Object)line.substring(line.indexOf(58))));
                } else {
                    this.addWarning(line.substring(line.indexOf(58)));
                }
            }
            if (line.startsWith("Loadfile records count:") && (totalRecordsMatcher = totalLinesPattern.matcher(line)).find()) {
                try {
                    if (this.linesInScope == 0L) {
                        this.linesInScope = Long.parseLong(totalRecordsMatcher.group(1));
                        this.addExecutionLog(this.iu.getNumeralString("RelativityImagesOverlayOperation.Log.ImagesCount", this.linesInScope));
                    } else {
                        LOGGER.warn("Duplicate records in overlay found in line " + line);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot extract lines in scope", (Throwable)e);
                }
            }
            if (!transferModePatternPrinted && (transferModeMatcher = transferModePattern.matcher(line)).find()) {
                this.addExecutionLog(this.iu.getFormattedString("RelativityLoadfileUploadOperation.Log.RelativityTransferMode", (Object)transferModeMatcher.group(1)));
                transferModePatternPrinted = true;
            }
            if (!line.contains("[NOT MAPPED") || line.contains("Source field [parent folder identifier]")) continue;
            this.addTransientWarning(line, false);
        }
    }

    private void readErrorStream(BufferedReader errorReader) throws IOException {
        String line;
        while ((line = errorReader.readLine()) != null) {
            if (line.trim().length() > 0 && !line.startsWith(" ")) {
                if (line.startsWith("Unhandled Exception:") || line.startsWith("exception:") || line.contains("fatal error: ")) {
                    String message = line.substring(line.indexOf(58) + 1).trim();
                    if (!this.relativityFatalErrorEncountered) {
                        this.relativityFatalErrorEncountered = true;
                        this.addWarning(this.iu.getFormattedString("RelativityLoadfileUploadOperation.Warning.LoadingToRelativityFatalErrors", (Object)message));
                    } else {
                        this.addWarning(message);
                    }
                } else {
                    this.addWarning(line);
                }
            }
            LOGGER.warn(line);
        }
    }

    private void uploadLoadfile(String loadfileLocation) throws IOException, InterruptedException, ParameterException {
        this.addExecutionLog(this.iu.getFormattedString("RelativityImagesOverlayOperation.Log.OverlayLoadfile", (Object)loadfileLocation));
        String relativityServiceEndpoint = this.executionContext.evalParameters("{wfn_relativity_service_endpoint}", this);
        String relativityClientVersion = this.executionContext.evalParameters("{wfn_relativity_client_version}", this);
        ThirdPartyAuthenticationMethod authenticationMethod = ThirdPartyAuthenticationMethod.USERNAME_PASSWORD;
        String authenticationMethodString = this.executionContext.evalParameters("{wfn_relativity_authentication_method}", this);
        try {
            authenticationMethod = ThirdPartyAuthenticationMethod.valueOf((String)authenticationMethodString);
            if (authenticationMethod == ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE) {
                this.relativityUsername = "none";
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse authentication method with value " + String.valueOf(authenticationMethodString) + " for relativity", (Throwable)e);
        }
        CharSequence[] relativityClientCommandArray = new String[]{"\"" + RelativityUtils.getRelativityClientPath(relativityClientVersion) + "\"", "imageImport", this.relativityEndpointType + "://" + this.relativityHostname + relativityServiceEndpoint, this.relativityUsername, "\"" + this.relativityPassword + "\"", "\"none\"", "\"none\"", "\"" + loadfileLocation + "\"", this.relativityWorkspaceId, this.identityField, this.relativityImportThreads, this.relativityImportThreadTimeout, this.relativityImportThreadRetries, String.valueOf(this.stripSuffixFromFirstPage)};
        String commandLine = String.join((CharSequence)" ", relativityClientCommandArray);
        LOGGER.info("Running: " + commandLine.replace(this.relativityPassword, "[password]"));
        this.relativityLoadProcess = Runtime.getRuntime().exec((String[])relativityClientCommandArray);
        BufferedReader standardInputReader = new BufferedReader(new InputStreamReader(this.relativityLoadProcess.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.relativityLoadProcess.getErrorStream()));
        this.readStandardOutputThread = new Thread(() -> {
            try {
                this.readOutputStream(standardInputReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard output stream", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
            }
            finally {
                try {
                    standardInputReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardOutputThread.setName("Automate Relativity Standard Output Thread");
        this.readStandardOutputThread.start();
        this.readStandardErrorThread = new Thread(() -> {
            try {
                this.readErrorStream(errorReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard error stream", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
            }
            finally {
                try {
                    errorReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardErrorThread.setName("Automate Relativity Standard Error Thread");
        this.readStandardErrorThread.start();
        this.relativityLoadProcess.waitFor();
    }

    @Override
    public void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                this.stopLoad();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName() + " Stop request");
        thread.start();
    }

    private void stopLoad() {
        if (this.relativityLoadProcess != null) {
            LOGGER.info("Attempting to destroy Relativity load process");
            try {
                this.startTriggerThread.interrupt();
            }
            catch (Exception e) {
                LOGGER.error("Cannot interrupt thread", (Throwable)e);
            }
            try {
                this.relativityLoadProcess.destroyForcibly();
            }
            catch (Exception e) {
                LOGGER.error("Cannot destroy Relativity load process", (Throwable)e);
            }
            if (!this.relativityLoadProcess.isAlive()) {
                this.trackStopped();
            }
        }
    }

    private double getPartPercentageComplete() {
        if (this.linesInScope == 0L) {
            return 1.0E-4;
        }
        double result = (double)this.imagesOverlayed.get() / (double)this.linesInScope;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(result + "\tPart " + this.currentLoadfileId + "\t" + this.linesInScope + "\t" + this.imagesOverlayed.get());
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        if (this.loadfiles.size() > 0) {
            return (this.getPartPercentageComplete() + (double)this.currentLoadfileId) / (double)this.loadfiles.size();
        }
        return 0.0;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.loadfiles != null && this.loadfiles.size() > 1) {
            File currentLoadfile = this.loadfiles.get(this.currentLoadfileId);
            result = (String)result + currentLoadfile.getParentFile().getName() + " / ";
        }
        if (this.linesInScope == 0L) {
            result = (String)result + this.iu.getString("RelativityLoadfileUploadOperation.Progress.ParsingLoadfile");
        } else if (this.imagesOverlayed != null) {
            result = (String)result + this.iu.getNumeralString("RelativityImagesOverlayOperation.Progress.LoadingProcessed", (long)this.imagesOverlayed.get());
        }
        return result;
    }
}

