/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityLoadDynamicObjectsOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityBasicUser;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldValueType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelativityLoadDynamicObjectsOperationImplementation
extends RelativityLoadDynamicObjectsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityLoadDynamicObjectsOperationImplementation.class);
    private transient String stageName;
    private transient double percentageComplete;
    private RelativityUtils utils;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.utils = RelativityUtils.getInstance();
                this.objectTypeIdentifier = this.executionContext.evalParameters(this.objectTypeIdentifier, this);
                this.objectsFile = this.executionContext.evalParameters(this.objectsFile, this);
                Long relativityWorkspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                if (!this.loadObjectsInWorkspace) {
                    relativityWorkspaceArtifactId = -1L;
                }
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                Long objectTypeArtifactId = 0L;
                List<EligibleObject> eligibleObjectTypes = this.relativityRestClient.queryObjectTypes(this.objectTypeIdentifier, this.objectTypeIdentifierType, relativityWorkspaceArtifactId);
                EligibleObject eligibleObjectType = RelativityUtils.getInstance().filterAllEligibleObject(this.objectTypeIdentifier, this.objectTypeIdentifierType, eligibleObjectTypes, RelativityFieldType.OBJECT_TYPE);
                if (eligibleObjectType == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityLoadCustomObjectsOperation.Exception.ObjectTypeMissing", (Object)String.valueOf(this.objectTypeIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityLoadCustomObjectsOperation.Info.ObjectTypeIdentifier", (Object)String.valueOf(this.objectTypeIdentifier)));
                objectTypeArtifactId = this.relativityRestClient.queryObjectTypeArtifactIdFromArtifactId(relativityWorkspaceArtifactId, eligibleObjectType.getArtifactId());
                this.stageName = this.iu.getString("RelativityLoadCustomObjectsOperation.Stage.ParsingCsv");
                this.percentageComplete = 0.25;
                List objectList = new ArrayList();
                if (this.useObjectsFile) {
                    File file = new File(this.objectsFile);
                    objectList = FileUtils.loadVariableColumnTsv((File)file);
                    this.addExecutionLog(this.iu.getFormattedString("RelativityLoadCustomObjectsOperation.Info.CsvPath", (Object)this.objectsFile));
                } else {
                    objectList = FileUtils.loadVariableColumnTsv((String)this.objects);
                }
                Object[] headerObjects = (Object[])objectList.remove(0);
                String[] headers = new String[headerObjects.length];
                boolean hasNameHeader = false;
                for (int i = 0; i < headerObjects.length; ++i) {
                    headers[i] = headerObjects[i].toString();
                    if (!headers[i].equalsIgnoreCase("name")) continue;
                    hasNameHeader = true;
                }
                if (!hasNameHeader) {
                    throw new Exception(this.iu.getFormattedString("RelativityLoadCustomObjectsOperation.Exception.MissingNameHeader", (Object)"'Name'"));
                }
                this.stageName = this.iu.getString("RelativityLoadCustomObjectsOperation.Stage.GettingObjectFields");
                this.percentageComplete = 0.5;
                Map<String, RelativityFieldValueType> typeMap = this.relativityRestClient.getFieldValueTypeIdentifiers(objectTypeArtifactId, relativityWorkspaceArtifactId);
                Map<String, RelativityFieldObject> fieldMap = this.relativityRestClient.getFieldIdentifiers(objectTypeArtifactId, relativityWorkspaceArtifactId);
                HashMap<String, Map<String, EligibleObject>> possibleValues = new HashMap<String, Map<String, EligibleObject>>();
                block8: for (String header : headers) {
                    RelativityFieldValueType type = typeMap.get(header);
                    if (type == null) {
                        throw new Exception(this.iu.getFormattedString("RelativityLoadCustomObjectsOperation.Exception.InvalidFieldType", (Object)header));
                    }
                    if (type == RelativityFieldValueType.FILE) {
                        throw new Exception(this.iu.getFormattedString("RelativityLoadCustomObjectsOperation.Exception.CannotUseFiles", new Object[]{"'file'", header}));
                    }
                    switch (type) {
                        case SINGLE_CHOICE: 
                        case MULTIPLE_CHOICE: {
                            Map<String, EligibleObject> identifierPossibleChoices = this.relativityRestClient.queryChoiceValues(relativityWorkspaceArtifactId, header);
                            possibleValues.put(header, identifierPossibleChoices);
                            continue block8;
                        }
                        case SINGLE_OBJECT: 
                        case MULTIPLE_OBJECT: {
                            Long subObjectArtifactTypeId = this.relativityRestClient.retrieveFieldArtifactTypeId(relativityWorkspaceArtifactId, fieldMap.get(header).getArtifactID());
                            Map<String, EligibleObject> identifierPossibleObjects = this.relativityRestClient.queryObjectValues(relativityWorkspaceArtifactId, subObjectArtifactTypeId);
                            possibleValues.put(header, identifierPossibleObjects);
                            continue block8;
                        }
                        case USER: {
                            HashMap<String, RelativityBasicUser> identifierPossibleUsers = new HashMap<String, RelativityBasicUser>();
                            List<RelativityBasicUser> users = this.relativityRestClient.queryUsers();
                            for (RelativityBasicUser user : users) {
                                identifierPossibleUsers.put(user.getFullName(), user);
                            }
                            possibleValues.put(header, identifierPossibleUsers);
                            continue block8;
                        }
                    }
                }
                this.stageName = this.iu.getString("RelativityLoadCustomObjectsOperation.Stage.CreatingObjects");
                this.percentageComplete = 0.75;
                ArrayList<Object[]> values = new ArrayList<Object[]>();
                for (Object[] line : objectList) {
                    Object[] evaluatedLine = new Object[line.length];
                    for (int i = 0; i < line.length; ++i) {
                        Object evaluatedValue;
                        Object objectValue = line[i];
                        RelativityFieldValueType type = typeMap.get(headers[i]);
                        Map possibleFieldValues = (Map)possibleValues.get(headers[i]);
                        evaluatedLine[i] = evaluatedValue = this.utils.handleFieldTypeValue(objectValue, type, possibleFieldValues);
                    }
                    values.add(evaluatedLine);
                }
                this.relativityRestClient.massCreateDynamicObjects(objectTypeArtifactId, relativityWorkspaceArtifactId, headers, values);
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

