/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityManageAnalyticIndexOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.ExistingAnalyticJobAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityAnalyticIndexConsoleStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityAnalyticIndexStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityIndexType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.util.List;
import java.util.Map;

public class RelativityManageAnalyticIndexOperationImplementation
extends RelativityManageAnalyticIndexOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityManageAnalyticIndexOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.analyticIndexIdentifier = this.executionContext.evalParameters(this.analyticIndexIdentifier, this);
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.stageName = this.iu.getString("RelativityManageAnalyticIndexOperation.Stage.GettingAnalyticIndex");
                this.percentageComplete = 0.1;
                EligibleObject eligibleIndex = null;
                Map<RelativityIndexType, List<EligibleObject>> analyticIndexes = this.relativityRestClient.queryAnalyticIndexes(workspaceArtifactId);
                if (this.indexType == RelativityIndexType.CLASSIFICATION) {
                    eligibleIndex = RelativityUtils.getInstance().filterEligibleObject(this.analyticIndexIdentifier, this.analyticIndexIdentifierType, analyticIndexes.get((Object)RelativityIndexType.CLASSIFICATION), RelativityFieldType.ANALYTICS_INDEX);
                } else if (this.indexType == RelativityIndexType.CONCEPTUAL) {
                    eligibleIndex = RelativityUtils.getInstance().filterEligibleObject(this.analyticIndexIdentifier, this.analyticIndexIdentifierType, analyticIndexes.get((Object)RelativityIndexType.CONCEPTUAL), RelativityFieldType.ANALYTICS_INDEX);
                }
                if (eligibleIndex == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityManageAnalyticIndexOperation.Exception.MissingAnalyticIndex", new Object[]{this.indexType.toString(), String.valueOf(this.analyticIndexIdentifier)}));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityManageAnalyticIndexOperation.Log.AnalyticIndex", new Object[]{eligibleIndex.getName(), String.valueOf(eligibleIndex.getArtifactId())}));
                this.addExecutionLog(this.iu.getFormattedString("RelativityManageAnalyticIndexOperation.Log.IndexType", (Object)this.indexType.toString()));
                this.addExecutionLog(this.iu.getFormattedString("RelativityManageAnalyticIndexOperation.Log.IndexAction", (Object)this.analyticIndexAction.toString()));
                RelativityAnalyticIndexStatus indexStatusInfo = this.relativityRestClient.getAnalyticIndexJobStatus(workspaceArtifactId, eligibleIndex.getArtifactId(), this.indexType);
                if (indexStatusInfo != null) {
                    if (indexStatusInfo.getCurrentStep() != null) {
                        if (this.existingJobAction == ExistingAnalyticJobAction.SKIP) {
                            this.addExecutionLog(this.iu.getString("RelativityManageAnalyticIndexOperation.Info.JobIsRunningSkipping"));
                            this.percentageComplete = 0.99;
                            this.trackFinished();
                            return;
                        }
                        if (this.existingJobAction == ExistingAnalyticJobAction.STOP) {
                            this.addExecutionLog(this.iu.getString("RelativityManageAnalyticIndexOperation.Info.JobIsRunningStopping"));
                            this.relativityRestClient.cancelAnalyticJob(workspaceArtifactId, eligibleIndex.getArtifactId(), this.indexType);
                            this.addExecutionLog(this.iu.getString("RelativityManageAnalyticIndexOperation.Info.WaitingForJobToStop"));
                            this.stageName = this.iu.getString("RelativityManageAnalyticIndexOperation.Stage.Stopping");
                            RelativityAnalyticIndexStatus cancelStatus = null;
                            while (true) {
                                if (this.stopRequested) {
                                    throw new WorkflowExecutionStopRequested();
                                }
                                cancelStatus = this.relativityRestClient.getAnalyticIndexJobStatus(workspaceArtifactId, eligibleIndex.getArtifactId(), this.indexType);
                                if (cancelStatus != null) {
                                    boolean indexJobFinished = false;
                                    if (cancelStatus.getConsoleStatuses() != null) {
                                        for (RelativityAnalyticIndexConsoleStatus consoleStatus : cancelStatus.getConsoleStatuses()) {
                                            if (!consoleStatus.getIdentifier().equals("populateIndexFull")) continue;
                                            indexJobFinished = consoleStatus.getEnabled();
                                            break;
                                        }
                                    }
                                    if (indexJobFinished) break;
                                }
                                Thread.sleep(1000L);
                            }
                            Thread.sleep(5000L);
                        }
                    }
                    if (indexStatusInfo.getSearchableSetCount() != null && indexStatusInfo.getSearchableSetCount() != 0) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityManageAnalyticIndexOperation.Log.DocumentsInScope", (Object)indexStatusInfo.getSearchableSetCount()));
                    }
                }
                this.stageName = this.iu.getString("RelativityManageAnalyticIndexOperation.Stage.PreparingIndex");
                this.percentageComplete = 0.2;
                this.relativityRestClient.submitAnalyticIndexJob(workspaceArtifactId, eligibleIndex.getArtifactId(), this.analyticIndexAction, this.indexType);
                if (this.waitForCompletion) {
                    this.addExecutionLog(this.iu.getString("RelativityManageAnalyticIndexOperation.Log.WaitingForCompletion"));
                    boolean analyticsJobStarted = false;
                    RelativityAnalyticIndexStatus status = null;
                    while (true) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        status = this.relativityRestClient.getAnalyticIndexJobStatus(workspaceArtifactId, eligibleIndex.getArtifactId(), this.indexType);
                        if (status != null) {
                            if (status.getCurrentStep() != null) {
                                analyticsJobStarted = true;
                            }
                            if (analyticsJobStarted) {
                                this.stageName = status.getSecondaryStatusText() != null ? status.getStatusText() + " (" + status.getSecondaryStatusText() + ")" : status.getStatusText();
                                boolean indexJobFinished = false;
                                if (status.getConsoleStatuses() != null) {
                                    for (RelativityAnalyticIndexConsoleStatus consoleStatus : status.getConsoleStatuses()) {
                                        if (!consoleStatus.getIdentifier().equals("populateIndexFull")) continue;
                                        indexJobFinished = consoleStatus.getEnabled();
                                        break;
                                    }
                                }
                                if (indexJobFinished) break;
                                this.percentageComplete = 0.2 + (double)status.getCurrentStep().intValue() / (double)status.getTotalSteps().intValue() * 0.75;
                            }
                        }
                        Thread.sleep(1000L);
                    }
                    Thread.sleep(10000L);
                    if (status.getSearchableSetCount() != null) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityManageAnalyticIndexOperation.Log.DocumentsIndexed", (Object)status.getSearchableSetCount()));
                    }
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

