/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityManageGroupUsersOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityBasicUser;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityGroupAction;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class RelativityManageGroupUsersOperationImplementation
extends RelativityManageGroupUsersOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityManageGroupUsersOperationImplementation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                String warningTranslation = this.groupUserAction == RelativityGroupAction.ADD ? this.iu.getString("RelativityManageGroupUsersOperation.Property.AddToGroup") : this.iu.getString("RelativityManageGroupUsersOperation.Property.RemoveFromGroup");
                this.groupIdentifier = this.executionContext.evalParameters(this.groupIdentifier, this);
                this.stageName = this.iu.getString("RelativityManageGroupUsersOperation.Stage.SettingGroup");
                this.percentageComplete = 0.25;
                Long groupArtifactId = 0L;
                List<EligibleObject> eligibleGroups = this.relativityRestClient.queryEligibleGroups(null);
                EligibleObject eligibleGroup = RelativityUtils.getInstance().filterEligibleObject(this.groupIdentifier, this.groupIdentifierType, eligibleGroups, RelativityFieldType.GROUP);
                if (eligibleGroup == null) {
                    throw new Exception(this.iu.getFormattedString("RelativityManageGroupUsersOperation.Exception.MissingGroup", (Object)String.valueOf(this.groupIdentifier)));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityManageGroupUsersOperation.Info.GroupIdentifier", (Object)String.valueOf(this.groupIdentifier)));
                groupArtifactId = eligibleGroup.getArtifactId();
                if (this.useUserGroupsFile) {
                    if (this.userGroupsFileName == null) {
                        this.userGroupsFileName = "";
                    }
                    this.userGroupsFileName = this.executionContext.evalParameters(this.userGroupsFileName, this);
                    this.userSettings = FileUtils.loadVariableColumnTsv((File)new File(this.userGroupsFileName));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityManageGroupUsersOperation.Info.GroupUsersFile", (Object)this.userGroupsFileName));
                }
                ArrayList<RelativityBasicUser> relativityUsers = new ArrayList<RelativityBasicUser>();
                List<RelativityBasicUser> existingUsers = this.relativityRestClient.queryUsers();
                this.stageName = this.iu.getString("RelativityManageGroupUsersOperation.Stage.GettingUsers");
                this.percentageComplete = 0.5;
                boolean skippedHeader = false;
                block8: for (Object[] user : this.userSettings) {
                    String userIdentifier = (String)user[0];
                    userIdentifier = this.executionContext.evalParameters(userIdentifier, this);
                    if (!skippedHeader && (userIdentifier.equalsIgnoreCase("user identifier") || userIdentifier.equalsIgnoreCase("useridentifier"))) {
                        skippedHeader = true;
                        continue;
                    }
                    RelativityBasicUser userToAdd = null;
                    block2 : switch (this.userIdentifierType) {
                        case ARTIFACT_ID: {
                            try {
                                Long artifactId = Long.parseLong(userIdentifier);
                                for (RelativityBasicUser existingUser : existingUsers) {
                                    if (!existingUser.getArtifactId().equals(artifactId)) continue;
                                    userToAdd = existingUser;
                                    break block2;
                                }
                                break;
                            }
                            catch (Exception e) {
                                this.addWarning(this.iu.getFormattedString("RelativityManageGroupUsersOperation.Warning.InvalidArtifactId", new Object[]{warningTranslation, String.valueOf(userIdentifier)}));
                                continue block8;
                            }
                        }
                        case NAME: {
                            for (RelativityBasicUser existingUser : existingUsers) {
                                if (!existingUser.getFullName().equals(userIdentifier)) continue;
                                userToAdd = existingUser;
                                break block2;
                            }
                            break;
                        }
                        default: {
                            for (RelativityBasicUser existingUser : existingUsers) {
                                if (!existingUser.getEmail().equals(userIdentifier)) continue;
                                userToAdd = existingUser;
                                break block2;
                            }
                        }
                    }
                    if (userToAdd == null) {
                        this.addWarning(this.iu.getFormattedString("RelativityManageGroupUsersOperation.Warning.CannotFindUser", new Object[]{warningTranslation, String.valueOf(userIdentifier)}));
                        continue;
                    }
                    relativityUsers.add(userToAdd);
                }
                if (this.groupUserAction == RelativityGroupAction.ADD) {
                    this.stageName = this.iu.getString("RelativityManageGroupUsersOperation.Stage.AddingUsersToGroup");
                    this.percentageComplete = 0.75;
                    this.relativityRestClient.addUsersToGroup(groupArtifactId, relativityUsers);
                } else {
                    this.stageName = this.iu.getString("RelativityManageGroupUsersOperation.Stage.RemovingUsersFromGroup");
                    this.percentageComplete = 0.75;
                    this.relativityRestClient.removeUsersFromGroup(groupArtifactId, relativityUsers);
                }
                List<EligibleObject> groupUsers = this.relativityRestClient.queryGroupMembers(groupArtifactId);
                HashSet<Long> groupUserArtifactIds = new HashSet<Long>();
                for (EligibleObject o : groupUsers) {
                    groupUserArtifactIds.add(o.getArtifactId());
                }
                for (RelativityBasicUser user : relativityUsers) {
                    if (this.groupUserAction == RelativityGroupAction.ADD) {
                        if (groupUserArtifactIds.contains(user.getArtifactId())) {
                            this.addExecutionLog(this.iu.getFormattedString("RelativityManageGroupUsersOperation.Info.AddingUserToGroup", (Object)user.getEmail()));
                            continue;
                        }
                    } else if (!groupUserArtifactIds.contains(user.getArtifactId())) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityManageGroupUsersOperation.Info.RemovedUserFromGroup", (Object)user.getEmail()));
                        continue;
                    }
                    this.addWarning(this.iu.getFormattedString("RelativityManageGroupUsersOperation.Warning.FailedGroupAction", new Object[]{warningTranslation, user.getEmail(), eligibleGroup.getName()}));
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

