/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityManageUsersOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityBasicUser;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityUser;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityUserAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RelativityManageUsersOperationImplementation
extends RelativityManageUsersOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityManageUsersOperationImplementation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                Long relativityClientArtifactId = Long.parseLong(this.executionContext.evalProtectedParameter("{relativity_client_id}"));
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                this.stageName = this.iu.getString("RelativityCreateUsersOperation.Stage.GettingTemplateUser");
                this.percentageComplete = 0.25;
                ArrayList<RelativityBasicUser> relativityUsers = new ArrayList<RelativityBasicUser>();
                List<RelativityBasicUser> existingUsers = this.relativityRestClient.queryUsers();
                if (this.useUserSettingsFile) {
                    if (this.userSettingsFileName == null) {
                        this.userSettingsFileName = "";
                    }
                    this.userSettingsFileName = this.executionContext.evalParameters(this.userSettingsFileName, this);
                    this.userSettings = FileUtils.loadVariableColumnDetectFormatFile((File)new File(this.userSettingsFileName));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateUsersOperation.Log.UserSettingsFile", (Object)this.userSettingsFileName));
                }
                block14: for (Object[] objectArray : this.userSettings) {
                    String userIdentifier = (String)objectArray[0];
                    userIdentifier = this.executionContext.evalParameters(userIdentifier, this);
                    RelativityBasicUser userToAdd = null;
                    block3 : switch (this.userIdentifierType) {
                        case ARTIFACT_ID: {
                            try {
                                Long artifactId = Long.parseLong(userIdentifier);
                                for (RelativityBasicUser existingUser : existingUsers) {
                                    if (!existingUser.getArtifactId().equals(artifactId)) continue;
                                    userToAdd = existingUser;
                                    break block3;
                                }
                                break;
                            }
                            catch (Exception e) {
                                this.addWarning(this.iu.getFormattedString("RelativityManageUsersOperation.Warning.InvalidArtifactId", (Object)String.valueOf(userIdentifier)));
                                continue block14;
                            }
                        }
                        case NAME: {
                            for (RelativityBasicUser existingUser : existingUsers) {
                                if (!existingUser.getFullName().equals(userIdentifier)) continue;
                                userToAdd = existingUser;
                                break block3;
                            }
                            break;
                        }
                        default: {
                            for (RelativityBasicUser existingUser : existingUsers) {
                                if (!existingUser.getEmail().equals(userIdentifier)) continue;
                                userToAdd = existingUser;
                                break block3;
                            }
                        }
                    }
                    if (userToAdd == null) {
                        this.addWarning(this.iu.getFormattedString("RelativityManageUsersOperation.Warning.UnableToFindUser", (Object)String.valueOf(userIdentifier)));
                        continue;
                    }
                    relativityUsers.add(userToAdd);
                }
                switch (this.userAction) {
                    case DISABLE: {
                        this.stageName = this.iu.getString("RelativityManageUsersOperation.Stage.DisablingUsers");
                        break;
                    }
                    default: {
                        this.stageName = this.iu.getString("RelativityManageUsersOperation.Stage.EnablingUsers");
                        break;
                    }
                    case DELETE: {
                        this.stageName = this.iu.getString("RelativityManageUsersOperation.Stage.DeletingUsers");
                    }
                }
                this.percentageComplete = 0.5;
                for (RelativityBasicUser relativityBasicUser : relativityUsers) {
                    try {
                        if (this.userAction == RelativityUserAction.DELETE) {
                            this.relativityRestClient.deleteUser(relativityBasicUser.getArtifactId());
                            this.addExecutionLog(this.iu.getFormattedString("RelativityManageUsersOperation.Info.DeletedUser", (Object)relativityBasicUser.getEmail()));
                            continue;
                        }
                        RelativityUser templateUser = this.relativityRestClient.getRelativityUserProperties(relativityBasicUser.getArtifactId());
                        RelativityUser userWithClient = new RelativityUser(templateUser, true);
                        if (this.userAction == RelativityUserAction.ENABLE) {
                            userWithClient.setRelativityAccess(true);
                            this.relativityRestClient.enableUser(userWithClient);
                            this.addExecutionLog(this.iu.getFormattedString("RelativityManageUsersOperation.Info.EnabledUser", (Object)relativityBasicUser.getEmail()));
                            continue;
                        }
                        if (this.userAction != RelativityUserAction.DISABLE) continue;
                        userWithClient.setRelativityAccess(false);
                        this.relativityRestClient.disableUser(userWithClient);
                        this.addExecutionLog(this.iu.getFormattedString("RelativityManageUsersOperation.Info.DisabledUser", (Object)relativityBasicUser.getEmail()));
                    }
                    catch (IOException e) {
                        this.addWarning(this.iu.getFormattedString("RelativityManageUsersOperation.Warning.UnableToPerformActionOnUser", new Object[]{this.iu.getString("RelativityManageUsersOperation.Property." + this.userAction.name()), relativityBasicUser.getEmail(), e.getMessage()}));
                    }
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

