/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.operations.RelativityManageWorkspaceGroupsOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityGroupAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroup;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroups;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class RelativityManageWorkspaceGroupsOperationImplementation
extends RelativityManageWorkspaceGroupsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityManageWorkspaceGroupsOperationImplementation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                Long relativityWorkspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.stageName = this.iu.getString("RelativityManageWorkspaceGroupsOperation.Stage.GettingWorkspaceGroups");
                this.percentageComplete = 0.25;
                WorkspaceGroups existingWorkspaceGroups = this.relativityRestClient.getWorkspaceGroups(relativityWorkspaceArtifactId);
                if (this.useWorkspaceGroupsFile) {
                    if (this.workspaceGroupsFileName == null) {
                        this.workspaceGroupsFileName = "";
                    }
                    this.workspaceGroupsFileName = this.executionContext.evalParameters(this.workspaceGroupsFileName, this);
                    this.groupSettings = FileUtils.loadVariableColumnTsv((File)new File(this.workspaceGroupsFileName));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityManageWorkspaceGroupsOperation.Info.GroupSettingsFile", (Object)this.workspaceGroupsFileName));
                }
                boolean enabled = this.groupAction == RelativityGroupAction.ADD;
                ArrayList<WorkspaceGroup> evaluatedGroups = new ArrayList<WorkspaceGroup>();
                for (Object[] group : this.groupSettings) {
                    String groupIdentifier = (String)group[0];
                    groupIdentifier = this.executionContext.evalParameters(groupIdentifier, this);
                    WorkspaceGroup evaluatedWorkspaceGroup = new WorkspaceGroup();
                    evaluatedWorkspaceGroup.setEnabled(enabled);
                    evaluatedWorkspaceGroup.setArtifactId(0L);
                    switch (this.groupIdentifierType) {
                        default: {
                            evaluatedWorkspaceGroup.setName(groupIdentifier);
                            break;
                        }
                        case ARTIFACT_ID: {
                            try {
                                evaluatedWorkspaceGroup.setArtifactId(Long.parseLong(groupIdentifier));
                                break;
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(this.iu.getFormattedString("RelativityManageWorkspaceGroupsOperation.Warning.InvalidArtifactId", (Object)groupIdentifier));
                            }
                        }
                    }
                    evaluatedGroups.add(evaluatedWorkspaceGroup);
                }
                for (WorkspaceGroup groupToAdd : evaluatedGroups) {
                    for (WorkspaceGroup existingGroup : existingWorkspaceGroups.getWorkspaceGroups()) {
                        if (this.groupIdentifierType == RelativityIdentifierType.NAME) {
                            if (!existingGroup.getName().equals(groupToAdd.getName())) continue;
                            groupToAdd.setArtifactId(existingGroup.getArtifactId());
                            continue;
                        }
                        if (!existingGroup.getArtifactId().equals(groupToAdd.getArtifactId())) continue;
                        groupToAdd.setName(existingGroup.getName());
                    }
                }
                HashSet<Long> groupArtifactIds = new HashSet<Long>();
                this.stageName = this.iu.getString("RelativityManageWorkspaceGroupsOperation.Stage.UpdatingWorkspaceGroups");
                this.percentageComplete = 0.5;
                WorkspaceGroups updatedWorkspaceGroups = new WorkspaceGroups();
                updatedWorkspaceGroups.setLastModified(existingWorkspaceGroups.getLastModified());
                for (WorkspaceGroup evaluatedGroup : evaluatedGroups) {
                    if (evaluatedGroup.getName() == null || evaluatedGroup.getArtifactId() == 0L) {
                        Object identifier = this.groupIdentifierType == RelativityIdentifierType.NAME ? evaluatedGroup.getName() : "" + evaluatedGroup.getArtifactId();
                        this.addWarning(this.iu.getFormattedString("RelativityManageWorkspaceGroupsOperation.Warning.GroupDoesNotExist", identifier));
                        continue;
                    }
                    if (groupArtifactIds.add(evaluatedGroup.getArtifactId())) {
                        updatedWorkspaceGroups.getWorkspaceGroups().add(evaluatedGroup);
                        if (this.groupAction == RelativityGroupAction.ADD) {
                            this.addExecutionLog(this.iu.getFormattedString("RelativityManageWorkspaceGroupsOperation.Info.AddingGroup", (Object)evaluatedGroup.getName()));
                            continue;
                        }
                        this.addExecutionLog(this.iu.getFormattedString("RelativityManageWorkspaceGroupsOperation.Info.RemovingGroup", (Object)evaluatedGroup.getName()));
                        continue;
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativityManageWorkspaceGroupsOperation.Info.IgnoringDuplicateGroup", (Object)evaluatedGroup.getName()));
                }
                this.stageName = this.iu.getString("RelativityManageWorkspaceGroupsOperation.Stage.SettingWorkspaceGroups");
                this.relativityRestClient.setWorkspaceGroups(relativityWorkspaceArtifactId, updatedWorkspaceGroups);
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

