/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRows;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRows(value={@FormFieldRow(name="exportSplitRow", children={"exportSplit", "exportSplitAt"}), @FormFieldRow(name="tagFailedItemsRow", children={"tagFailedItems", "failedItemTagName", "untagSuccessfulItems"})})
@OperationMetadata(alias=OperationAlias.RELATIVITY_METADATA_OVERLAY, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"LOAD", "METADATA"})})
@OperationParameters(value={@OperationParameter(label="queryRetrieveExportFolder", parameter="{last_export_folder}"), @OperationParameter(label="queryRetrieveFailedItems", parameter="tag:\"{last_failed_items_tag_name}\"")})
@OperationLicenseModule(module=ModuleType.RELATIVITY_REVIEW)
public class RelativityMetadataOverlayOperation
extends RelativityOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityMetadataOverlayOperation.class);
    @FormField(required=false)
    public String scope = "has-production-set:1";
    @FormField(componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.METADATA_PROFILES)
    public String metadataProfile = "Default";
    @FormField(required=false)
    public String relativityMappingLocation = "";
    @FormField
    public String exportLocation = "{case_folder}/Export/{case_name} - Metadata Overlay {date_time}.dat";
    @FormField
    public Boolean exportSplit = true;
    @FormField(enableOn={@OnField(name="exportSplit")}, positionLabel=@PositionLabel(right="items"))
    @ExcludeFromPrintableOptions
    public int exportSplitAt = 100000;
    @FormField
    public Boolean tagFailedItems = true;
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public String failedItemTagName = "Automate|Failed Items|Metadata Overlay";
    @FormField(enableOn={@OnField(name="tagFailedItems")})
    @ExcludeFromPrintableOptions
    public Boolean untagSuccessfulItems = true;

    public boolean getDisplayExportSplitAt() {
        return this.exportSplit;
    }

    public boolean getDisplayFailedItemTagName() {
        return this.tagFailedItems;
    }

    public boolean getDisplayUntagSuccessfulItems() {
        return this.tagFailedItems;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityMetadataOverlayOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureRelativityConnectionOperation = false;
        boolean detectedSetRelativityWorkspaceOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o instanceof RelativitySetWorkspaceOperation) {
                detectedSetRelativityWorkspaceOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (!detectedSetRelativityWorkspaceOperation) {
            prerequisites.add(this.iu.getString("RelativitySetWorkspaceOperation.Prerequisites.Missing"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

