/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.security.WinDPAPIEncyptor;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityMetadataOverlayOperation;
import com.nuix.automate.workflow.core.utils.nuix.MetadataItemUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nuix.BulkAnnotater;
import nuix.Item;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import nuix.ProductionSetItem;
import org.apache.commons.io.FilenameUtils;

public class RelativityMetadataOverlayOperationImplementation
extends RelativityMetadataOverlayOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityMetadataOverlayOperation.class);
    private final transient String CONCORDANCE_SEPARATOR = "\u0014";
    private final transient String CONCORDANCE_QUOTES = "\u00fe";
    private transient String relativityUsername;
    private transient String relativityPassword;
    private transient String relativityWorkspaceId;
    private transient String relativityHostname;
    private transient String relativityEndpointType;
    private transient String relativityImportThreads;
    private transient String relativityImportThreadTimeout;
    private transient String relativityImportThreadRetries;
    private transient String relativityPatchInvalidEntries;
    private Writer writer;
    private List<MetadataItem> metadata;
    private transient long itemsInScope;
    private transient AtomicInteger itemsLoadedMetadata = new AtomicInteger();
    private transient AtomicInteger itemsExportedMetadata = new AtomicInteger();
    private transient AtomicInteger itemsSkippedDueToMissingDocId = new AtomicInteger();
    private transient AtomicInteger itemsWithMultipleDocIds = new AtomicInteger();
    private transient File settingsFile;
    private transient int exportPart;
    private transient double partStartPercentage;
    private transient double partSizePercentage;
    private transient Set<Item> failedItems;
    private transient Process relativityLoadProcess;
    private transient Set<String> rubyFieldNames;
    private transient Thread readStandardOutputThread;
    private transient Thread readStandardErrorThread;

    @Override
    public void startTriggered() throws Exception {
        File exportFile;
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.exportLocation = this.executionContext.evalParameters(this.exportLocation, this);
        this.failedItemTagName = this.executionContext.evalParameters(this.failedItemTagName, this);
        File exportLocationFile = new File(this.exportLocation);
        if (exportLocationFile.isDirectory()) {
            this.exportLocation = this.exportLocation + "/loadfile.dat";
        }
        if ((exportFile = new File(this.exportLocation)).exists()) {
            throw new IOException("File " + exportFile.getAbsolutePath() + " already exists");
        }
        this.relativityMappingLocation = this.executionContext.evalParameters(this.relativityMappingLocation, this);
        this.relativityUsername = this.executionContext.evalParameters("{wfn_relativity_username}", this);
        this.relativityWorkspaceId = this.executionContext.evalParameters("{relativity_workspace_id}", this);
        this.relativityMappingLocation = this.executionContext.evalParameters(this.relativityMappingLocation, this);
        this.relativityHostname = this.executionContext.evalParameters("{wfn_relativity_hostname}", this);
        this.relativityEndpointType = this.executionContext.evalParameters("{wfn_relativity_endpoint_type}", this);
        this.relativityImportThreads = this.executionContext.evalParameters("{wfn_relativity_import_threads}", this);
        this.relativityImportThreadTimeout = this.executionContext.evalParameters("{wfn_relativity_import_thread_timeout}", this);
        this.relativityImportThreadRetries = this.executionContext.evalParameters("{wfn_relativity_import_thread_retries}", this);
        this.relativityPatchInvalidEntries = this.executionContext.evalParameters("{wfn_relativity_patch_invalid_entries}", this);
        this.relativityPassword = this.executionContext.evalProtectedParameter("{wfn_relativity_password}");
        try {
            this.relativityPassword = new WinDPAPIEncyptor().encrypt(this.relativityPassword);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot encrypt password", (Throwable)e);
        }
        this.itemsLoadedMetadata = new AtomicInteger(0);
        this.itemsExportedMetadata = new AtomicInteger(0);
        String metadataProfileParameterName = "{metadata_profile}";
        String evaluatedMetadataProfileParameter = this.executionContext.evalParameters(metadataProfileParameterName, this);
        if (!metadataProfileParameterName.equals(evaluatedMetadataProfileParameter)) {
            this.metadataProfile = evaluatedMetadataProfileParameter;
            this.addExecutionLog(this.iu.getFormattedString("RelativityMetadataOverlayOperation.Log.CustomMetadataProfile", new Object[]{metadataProfileParameterName, this.metadataProfile}));
        } else {
            this.addExecutionLog(this.iu.getFormattedString("RelativityMetadataOverlayOperation.Log.MetadataProfile", (Object)this.metadataProfile));
        }
        MetadataProfile mp = NuixUtils.getMetadataProfile(this.executionContext.nuixCase, this.executionContext.nuixUtilities, this.metadataProfile);
        if (mp == null) {
            this.exception = new Exception(this.iu.getFormattedString("RelativityMetadataOverlayOperation.Warning.CannotFindMetadataProfile", (Object)this.metadataProfile));
            this.executionState = ExecutionState.ERROR;
            return;
        }
        this.startTriggerThread = new Thread(() -> {
            try {
                this.rubyFieldNames = new TreeSet<String>();
                for (MetadataItem metadataItem : mp.getMetadata()) {
                    if (!MetadataItemUtils.isRubyScript(metadataItem)) continue;
                    this.rubyFieldNames.add(metadataItem.getName());
                    LOGGER.info("Field " + metadataItem.getName() + " is scripted Ruby field");
                }
                if (this.rubyFieldNames.size() > 0) {
                    this.addWarning(this.iu.getFormattedString("MetadataExportOperation.Warning.RubyFields", (Object)String.join((CharSequence)", ", this.rubyFieldNames)));
                }
                List allItems = null;
                this.failedItems = new HashSet<Item>();
                this.partStartPercentage = 0.0;
                this.partSizePercentage = 1.0;
                allItems = this.executionContext.nuixCase.search(this.scope);
                this.itemsInScope = allItems.size();
                this.addExecutionLog(this.iu.getFormattedString("RelativityMetadataOverlayOperation.Log.ScopeQuery", (Object)this.scope));
                this.addExecutionLog(this.iu.getNumeralString("RelativityMetadataOverlayOperation.Log.ScopeCount", this.itemsInScope));
                this.metadata = mp.getMetadata();
                String overwriteMode = "Overlay";
                String relativityOverwriteModeParameterName = "{relativity_overwrite_mode}";
                String relativityOverwriteMode = this.executionContext.evalParameters(relativityOverwriteModeParameterName, this);
                if (!relativityOverwriteMode.equals(relativityOverwriteModeParameterName)) {
                    overwriteMode = relativityOverwriteMode;
                    this.addExecutionLog(this.iu.getFormattedString("RelativityLoadfileUploadOperation.Log.RelativityOverwriteMode", (Object)overwriteMode));
                }
                this.settingsFile = FileUtils.createTempFile((String)"AutomateRelativitySettings", (String)".json");
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.settingsFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                String settings = "{\"OverwriteMode\":\"" + overwriteMode + "\",\"SendEmailOnCompletion\":\"False\",\"TextFieldIsFilePath\":\"True\"}";
                LOGGER.info("Relativity settings: " + settings);
                bufferedWriter.write(settings);
                bufferedWriter.close();
                if (this.exportSplit.booleanValue() && this.itemsInScope > (long)this.exportSplitAt) {
                    LOGGER.info("Overlaying in parts");
                    int addedForExport = 0;
                    this.exportPart = 0;
                    while (addedForExport < allItems.size()) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException("Aborting");
                        }
                        ArrayList<Item> partProductionSetItems = new ArrayList<Item>();
                        this.partStartPercentage = (double)addedForExport / (double)allItems.size();
                        LOGGER.info("Overlaying in parts: " + addedForExport + " of " + allItems.size());
                        ++this.exportPart;
                        int nextItemId = Math.min(addedForExport + this.exportSplitAt, allItems.size());
                        partProductionSetItems.addAll(allItems.subList(addedForExport, nextItemId));
                        LOGGER.info("Overlaying part from " + addedForExport + " to " + (nextItemId - 1));
                        addedForExport = nextItemId;
                        LOGGER.info("Added to overlay: " + addedForExport);
                        String lastTlGuid = ((Item)partProductionSetItems.get(partProductionSetItems.size() - 1)).getTopLevelItem().getGuid();
                        LOGGER.info("Last TL Guid: " + lastTlGuid);
                        while (allItems.size() > addedForExport) {
                            Item nextItem = (Item)allItems.get(addedForExport);
                            String nextTlGuid = nextItem.getTopLevelItem().getGuid();
                            LOGGER.info("Next TL Guid: " + nextTlGuid);
                            if (!lastTlGuid.equals(nextTlGuid)) break;
                            partProductionSetItems.add(nextItem);
                            LOGGER.info("Adding to overlay, total: " + ++addedForExport + " of " + allItems.size());
                        }
                        double trancheEndPercentage = (double)addedForExport / (double)allItems.size();
                        this.partSizePercentage = trancheEndPercentage - this.partStartPercentage;
                        LOGGER.info("Exporting part " + this.exportPart);
                        String extension = FilenameUtils.getExtension((String)exportFile.getName());
                        String partExportLocation = this.exportLocation.substring(0, this.exportLocation.length() - extension.length() - 1) + "_Part" + this.exportPart + "." + extension;
                        this.exportItems(partExportLocation, partProductionSetItems);
                    }
                    LOGGER.info("Overlaying in parts: " + addedForExport + " of " + allItems.size());
                } else {
                    this.exportItems(this.exportLocation, allItems);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Skipping deletion of temporary settings file " + String.valueOf(this.settingsFile));
                }
                if (this.failedItems.size() > 0) {
                    this.addWarning(this.iu.getNumeralString("RelativityMetadataOverlayOperation.Warning.OverlayCouldNotBeFullyLoaded", (long)this.failedItems.size()));
                }
                if (this.tagFailedItems.booleanValue() && this.failedItems.size() > 0) {
                    LOGGER.info("Tagging " + this.failedItems.size() + " items with tag " + this.failedItemTagName);
                    BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                    bulkAnnotater.addTag(this.failedItemTagName, this.failedItems);
                    this.addExecutionLog(this.iu.getNumeralFormattedString("RelativityMetadataOverlayOperation.Log.TaggedFailedItems", (long)this.failedItems.size(), (Object)this.failedItemTagName));
                }
                if (this.tagFailedItems.booleanValue() && this.untagSuccessfulItems.booleanValue()) {
                    String query = NuixUtils.addAndQuery("tag:\"" + this.failedItemTagName + "\"", this.scope);
                    LOGGER.info("Searching: " + query);
                    Set previouslyTaggedItems = this.executionContext.nuixCase.searchUnsorted(query);
                    Set itemsToUntag = this.executionContext.nuixUtilities.getItemUtility().difference((Collection)previouslyTaggedItems, this.failedItems);
                    if (itemsToUntag.size() > 0) {
                        LOGGER.info("Untagging " + itemsToUntag.size() + " items with tag " + this.failedItemTagName);
                        BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                        bulkAnnotater.removeTag(this.failedItemTagName, (Collection)itemsToUntag);
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Aborting operation");
                this.stopLoad();
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                String message = ExceptionUtils.getExceptionPrintableMessage((Throwable)e);
                if (message != null && this.relativityPassword != null) {
                    message = message.replace(this.relativityPassword, Parameter.MASKED_VALUE);
                }
                this.exception = new Exception(message);
                this.executionState = ExecutionState.ERROR;
                return;
            }
            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", exportLocationFile.getParentFile().getAbsolutePath())));
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void readOutputStream(BufferedReader standardInputReader, List<Item> items) throws IOException {
        String line;
        int partItemsLoadedMetadata = this.itemsLoadedMetadata.get();
        String notMapped = "[NOT MAPPED";
        String ignoreNotMapped = "Source field [parent folder identifier]";
        Pattern progressPattern = Pattern.compile("\\[Progress Info: ?(\\d+)");
        Pattern errorLinePattern = Pattern.compile("error: line: (\\d+)");
        Pattern totalLinesPattern = Pattern.compile("Loadfile records count: (\\d+)");
        Pattern transferModePattern = Pattern.compile("Status - Created transfer client '([^\\']+)' using a best-fit strategy.");
        boolean transferModePatternPrinted = false;
        int lineNumber = 0;
        boolean enableVerboseLogging = Boolean.parseBoolean(System.getProperty("automate.relativity.verbose_logging"));
        while ((line = standardInputReader.readLine()) != null) {
            Matcher transferModeMatcher;
            Matcher errorMatcher;
            Matcher progressMatcher;
            if (enableVerboseLogging || lineNumber < 1000) {
                LOGGER.info(line);
                if (++lineNumber == 1000 && !enableVerboseLogging) {
                    LOGGER.info("Relativity verbose logging is disabled, to enable verbose logging use the command-line flag -Dautomate.relativity.verbose_logging=true");
                }
            }
            if ((progressMatcher = progressPattern.matcher(line)).find()) {
                try {
                    this.itemsLoadedMetadata.set(Math.max(this.itemsLoadedMetadata.get(), partItemsLoadedMetadata + Integer.parseInt(progressMatcher.group(1))));
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot extract progress from line", (Throwable)e);
                }
            }
            if ((errorMatcher = errorLinePattern.matcher(line)).find()) {
                try {
                    int lineId = Integer.parseInt(errorMatcher.group(1));
                    Item failedItem = items.get(lineId - 1);
                    this.failedItems.add(failedItem);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot extract line with error", (Throwable)e);
                }
            }
            if (line.startsWith("Unhandled Exception:") || line.startsWith("exception:")) {
                this.addWarning(line);
            }
            if (!transferModePatternPrinted && (transferModeMatcher = transferModePattern.matcher(line)).find()) {
                this.addExecutionLog(this.iu.getFormattedString("RelativityMetadataOverlayOperation.Log.RelativityTransferMode", (Object)transferModeMatcher.group(1)));
                transferModePatternPrinted = true;
            }
            if (!line.contains("[NOT MAPPED") || line.contains("Source field [parent folder identifier]")) continue;
            this.addTransientWarning(line, false);
        }
    }

    private void readErrorStream(BufferedReader errorReader) throws IOException {
        String line;
        while ((line = errorReader.readLine()) != null) {
            this.addWarning(line);
        }
    }

    private void exportItems(String exportFileName, List<Item> items) throws IOException, InterruptedException, ParameterException {
        this.addExecutionLog(this.iu.getFormattedString("RelativityMetadataOverlayOperation.Log.ExportLocation", (Object)exportFileName));
        this.writeHeader(exportFileName);
        for (Item item : items) {
            this.writeItem(item);
        }
        this.writer.close();
        if (this.itemsSkippedDueToMissingDocId.get() > 0) {
            this.addExecutionLog(this.iu.getNumeralString("RelativityMetadataOverlayOperation.Log.SkippedDueToMissingDocIDs", (long)this.itemsSkippedDueToMissingDocId.get()));
        }
        if (this.itemsWithMultipleDocIds.get() > 0) {
            this.addExecutionLog(this.iu.getNumeralString("RelativityMetadataOverlayOperation.Log.DocumentsWithMultipleDocIDs", (long)this.itemsWithMultipleDocIds.get()));
        }
        String relativityServiceEndpoint = this.executionContext.evalParameters("{wfn_relativity_service_endpoint}", this);
        String relativityClientVersion = this.executionContext.evalParameters("{wfn_relativity_client_version}", this);
        ThirdPartyAuthenticationMethod authenticationMethod = ThirdPartyAuthenticationMethod.USERNAME_PASSWORD;
        String authenticationMethodString = this.executionContext.evalParameters("{wfn_relativity_authentication_method}", this);
        try {
            authenticationMethod = ThirdPartyAuthenticationMethod.valueOf((String)authenticationMethodString);
            if (authenticationMethod == ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE) {
                this.relativityUsername = "none";
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse authentication method with value " + String.valueOf(authenticationMethodString) + " for relativity", (Throwable)e);
        }
        CharSequence[] relativityClientCommandArray = new String[]{"\"" + RelativityUtils.getRelativityClientPath(relativityClientVersion) + "\"", "import", this.relativityEndpointType + "://" + this.relativityHostname + relativityServiceEndpoint, this.relativityUsername, "\"" + this.relativityPassword + "\"", "\"" + (this.relativityMappingLocation.length() > 0 ? this.relativityMappingLocation : "none") + "\"", "\"" + this.settingsFile.getAbsolutePath() + "\"", "\"" + exportFileName + "\"", this.relativityWorkspaceId, "0", this.relativityImportThreads, this.relativityImportThreadTimeout, this.relativityImportThreadRetries, this.relativityPatchInvalidEntries};
        String commandLine = String.join((CharSequence)" ", relativityClientCommandArray);
        LOGGER.info("Running: " + commandLine.replace(this.relativityPassword, "[password]"));
        this.relativityLoadProcess = Runtime.getRuntime().exec((String[])relativityClientCommandArray);
        BufferedReader standardInputReader = new BufferedReader(new InputStreamReader(this.relativityLoadProcess.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.relativityLoadProcess.getErrorStream()));
        this.readStandardOutputThread = new Thread(() -> {
            try {
                this.readOutputStream(standardInputReader, items);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard output stream", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
            }
            finally {
                try {
                    standardInputReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardOutputThread.setName("Automate Relativity Standard Output Thread");
        this.readStandardOutputThread.start();
        this.readStandardErrorThread = new Thread(() -> {
            try {
                this.readErrorStream(errorReader);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard error stream", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("General.Log.ExceptionMessage", (Object)e.getLocalizedMessage()));
            }
            finally {
                try {
                    errorReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close stream", (Throwable)e);
                }
            }
        });
        this.readStandardErrorThread.setName("Automate Relativity Standard Error Thread");
        this.readStandardErrorThread.start();
        this.relativityLoadProcess.waitFor();
    }

    void writeHeader(String exportFileName) throws IOException {
        File exportFile = new File(exportFileName);
        File exportFolder = exportFile.getParentFile();
        if (!exportFolder.exists()) {
            LOGGER.info("Creating folder " + exportFolder.getAbsolutePath());
            exportFolder.mkdirs();
        }
        this.writer = new OutputStreamWriter(Files.newOutputStream(Paths.get(exportFileName, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
        StringBuilder header = new StringBuilder();
        header.append("\u00fe");
        header.append("DOCID");
        header.append("\u00fe");
        for (MetadataItem metadataItem : this.metadata) {
            if (header.length() > 0) {
                header.append("\u0014");
            }
            header.append("\u00fe");
            header.append(metadataItem.getLocalisedName());
            header.append("\u00fe");
        }
        header.append("\r\n");
        this.writer.write(header.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeItem(Item item) throws IOException {
        HashSet<String> documentIds = new HashSet<String>();
        for (ProductionSetItem productionSetItem : item.getProductionSetItems()) {
            documentIds.add(productionSetItem.getDocumentNumber().toString());
        }
        if (documentIds.size() == 0) {
            this.itemsSkippedDueToMissingDocId.incrementAndGet();
            return;
        }
        if (documentIds.size() > 1) {
            this.itemsWithMultipleDocIds.incrementAndGet();
        }
        for (String documentId : documentIds) {
            StringBuilder itemMetadataRepresentation = new StringBuilder();
            itemMetadataRepresentation.append("\u00fe");
            itemMetadataRepresentation.append(FormattingUtils.encodeForConcordance((String)documentId));
            itemMetadataRepresentation.append("\u00fe");
            boolean firstItem = false;
            for (MetadataItem metadataItem : this.metadata) {
                String metadataItemRepresentation = null;
                try {
                    metadataItemRepresentation = MetadataItemUtils.evaluate(metadataItem, item, this.rubyFieldNames);
                }
                catch (Exception e) {
                    metadataItemRepresentation = e.getMessage();
                }
                if (firstItem) {
                    firstItem = false;
                } else {
                    itemMetadataRepresentation.append("\u0014");
                }
                itemMetadataRepresentation.append("\u00fe");
                itemMetadataRepresentation.append(FormattingUtils.encodeForConcordance((String)metadataItemRepresentation));
                itemMetadataRepresentation.append("\u00fe");
            }
            itemMetadataRepresentation.append("\r\n");
            Writer writer = this.writer;
            synchronized (writer) {
                this.writer.write(itemMetadataRepresentation.toString());
            }
        }
        this.itemsExportedMetadata.incrementAndGet();
    }

    @Override
    public void resumeTriggered() {
    }

    @Override
    public void pauseTriggered() {
    }

    @Override
    public void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                this.stopLoad();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName() + " Stop request");
        thread.start();
    }

    @Override
    public void updateState() {
    }

    private void stopLoad() {
        if (this.relativityLoadProcess != null) {
            LOGGER.info("Attempting to destroy Relativity load process");
            try {
                this.relativityLoadProcess.destroyForcibly();
            }
            catch (Exception e) {
                LOGGER.error("Cannot destroy Relativity load process", (Throwable)e);
            }
            if (!this.relativityLoadProcess.isAlive()) {
                this.trackStopped();
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = ((double)this.itemsLoadedMetadata.get() * 0.5 + (double)this.itemsExportedMetadata.get() * 0.5) / (double)this.itemsInScope;
        return result;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / ";
        }
        if (this.itemsInScope == 0L) {
            result = (String)result + "Searching for items";
        } else if (this.itemsLoadedMetadata != null) {
            result = (String)result + this.iu.getNumeralString("RelativityMetadataOverlayOperation.Progress.ExportedItems", (long)this.itemsExportedMetadata.get());
            result = (String)result + this.iu.getNumeralString("RelativityMetadataOverlayOperation.Progress.LoadingItems", (long)this.itemsLoadedMetadata.get());
        }
        return result;
    }
}

