/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.ThirdPartyProduct;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.ThirdPartyLicense;
import com.nuix.automate.utils.logging.DummyLogChannel;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.relativity.EndpointType;
import com.nuix.automate.utils.models.api.relativity.RelativityRestVersion;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import com.nuix.automate.workflow.core.utils.relativity.RelativityClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class RelativityOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityOperation.class);
    protected transient RelativityClient relativityRestClient;

    public RelativityOperation() {
        this.requiresCase = false;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        return new HashSet<Feature>();
    }

    protected void initializeRelativityClient(RelativityRestVersion relativityRestVersion) throws ParameterException, IOException, GeneralSecurityException {
        this.initializeRelativityClient(relativityRestVersion, false);
    }

    protected void initializeRelativityClient(boolean supportRSApi) throws ParameterException, IOException, GeneralSecurityException {
        this.initializeRelativityClient(null, supportRSApi);
    }

    protected void initializeRelativityClient(RelativityRestVersion relativityRestVersion, boolean supportRSApi) throws ParameterException, IOException, GeneralSecurityException {
        String relativityHostname = this.executionContext.evalParameters("{wfn_relativity_hostname}", this);
        String relativityEndpointType = this.executionContext.evalParameters("{wfn_relativity_endpoint_type}", this);
        String relativityUsername = this.executionContext.evalParameters("{wfn_relativity_username}", this);
        String relativityPassword = this.executionContext.evalProtectedParameter("{wfn_relativity_password}");
        HashSet<String> whitelistedCertFingerprints = new HashSet<String>((Collection)SerializationUtils.fromJson((String)this.executionContext.evalProtectedParameter("{wfn_relativity_whitelisted_cert_fingerprints}")));
        ThirdPartyAuthenticationMethod authenticationMethod = ThirdPartyAuthenticationMethod.USERNAME_PASSWORD;
        String authenticationMethodString = this.executionContext.evalParameters("{wfn_relativity_authentication_method}", this);
        try {
            authenticationMethod = ThirdPartyAuthenticationMethod.valueOf((String)authenticationMethodString);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse authentication method with value " + String.valueOf(authenticationMethodString) + " for relativity", (Throwable)e);
        }
        if (relativityRestVersion == null) {
            relativityRestVersion = RelativityRestVersion.valueOf((String)this.executionContext.evalParameters("{wfn_relativity_rest_version}", this));
        }
        if (!supportRSApi && relativityRestVersion == RelativityRestVersion.RSAPI) {
            throw new IOException(this.iu.getString("Relativity.Exception.RSAPINotSupported"));
        }
        this.relativityRestClient = RelativityClient.getInstance(relativityRestVersion, EndpointType.valueOf((String)relativityEndpointType), relativityHostname, relativityUsername, relativityPassword, whitelistedCertFingerprints, (LogChannel)new DummyLogChannel(), authenticationMethod);
    }

    protected void assertRelativityInstanceLicensed() throws LicenseException {
        String relativityInstanceId;
        try {
            relativityInstanceId = this.executionContext.evalParameters("{wfn_relativity_instance_id}", this);
        }
        catch (ParameterException e) {
            throw new LicenseException("Could not retrieve Relativity instance ID");
        }
        try {
            LicenceInfo licenseInfo = this.executionContext.getDeployedLicenceInfo();
            if (licenseInfo.getThirdPartyLicenses() != null) {
                for (ThirdPartyLicense thirdPartyLicense : licenseInfo.getThirdPartyLicenses()) {
                    if (!thirdPartyLicense.getThirdPartyProductType().equals((Object)ThirdPartyProduct.RELATIVITY_REVIEW)) continue;
                    if (thirdPartyLicense.getId().equals("*")) {
                        return;
                    }
                    if (!thirdPartyLicense.getId().toLowerCase().contains(relativityInstanceId.toLowerCase())) continue;
                    return;
                }
            }
            throw new LicenseException("The Relativity service is not licensed for " + relativityInstanceId);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot get licenseInfo", (Throwable)e);
            throw new LicenseException("Could not validate Relativity instance license");
        }
    }
}

