/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.gson.annotations.SerializedName;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityPropertyQueryOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.rsapi.ApiField;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;

public class RelativityPropertyQueryOperationImplementation
extends RelativityPropertyQueryOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityPropertyQueryOperation.class);
    private transient int stageCount = 0;
    private transient int stageSize = 0;

    @Override
    protected void startTriggered() throws Exception {
        String relativityWorkspaceId = this.executionContext.evalParameters("{relativity_workspace_id}", this);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(true);
                this.stageSize = this.parametersToProperties.size();
                this.addExecutionLog(this.iu.getFormattedString("RelativityPropertyQuery.Log.QueryingProperties", (Object)this.stageSize));
                HashMap<String, Exception> propertyErrors = new HashMap<String, Exception>();
                for (Object[] parametersToProperty : this.parametersToProperties) {
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    ++this.stageCount;
                    String parameterName = (String)parametersToProperty[0];
                    String propertyName = (String)parametersToProperty[1];
                    String relativityPropertyValue = "";
                    try {
                        relativityPropertyValue = this.relativityRestClient.getProperty(propertyName, relativityWorkspaceId);
                        if (relativityPropertyValue != null) {
                            StaticParameter parameter = new StaticParameter(parameterName, relativityPropertyValue);
                            this.trackParameter((Parameter)parameter);
                            this.executionContext.getExecutionCustomParameters().put((Parameter)parameter);
                            continue;
                        }
                        propertyErrors.put(propertyName, new RuntimeException("Property value returned null"));
                    }
                    catch (IOException e) {
                        propertyErrors.put(propertyName, e);
                    }
                }
                if (propertyErrors.size() > 0) {
                    String errorsLog = propertyErrors.keySet().stream().map(key -> {
                        Exception e = (Exception)propertyErrors.get(key);
                        return key + ",\n" + String.valueOf(e) + ", " + e.getLocalizedMessage();
                    }).collect(Collectors.joining("\n\n"));
                    throw new NotFoundException(this.iu.getFormattedString("RelativityPropertyQuery.Error.CouldNotFindProperties", (Object)errorsLog));
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        if (this.stageSize == 0) {
            return 1.0E-4;
        }
        return (double)this.stageCount / (double)this.stageCount;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (((String)result).length() > 0) {
            result = (String)result + " / " + this.iu.getString("RelativityPropertyQuery.Progress.QueryingProperty");
        }
        return result;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class WorkspaceProperty {
        private String name;
        private String type;
        private String guids;
        private long artifactId;
        private String relativityTextIdentifier;
        private long length;
        private List<ApiField> apiFields;

        private WorkspaceProperty() {
        }

        public String getName() {
            return this.name;
        }

        @SerializedName(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        @SerializedName(value="Field Type")
        public void setType(String type) {
            this.type = type;
        }

        public String getGuids() {
            return this.guids;
        }

        @SerializedName(value="Field Guids")
        public void setGuids(String guids) {
            this.guids = guids;
        }

        public long getArtifactId() {
            return this.artifactId;
        }

        @SerializedName(value="Artifact ID")
        public void setArtifactId(long artifactId) {
            this.artifactId = artifactId;
        }

        public String getRelativityTextIdentifier() {
            return this.relativityTextIdentifier;
        }

        @SerializedName(value="Relativity Text Identifier")
        public void setRelativityTextIdentifier(String relativityTextIdentifier) {
            this.relativityTextIdentifier = relativityTextIdentifier;
        }

        public long getLength() {
            return this.length;
        }

        @SerializedName(value="Length")
        public void setLength(long length) {
            this.length = length;
        }

        public List<ApiField> getApiFields() {
            return this.apiFields;
        }

        @SerializedName(value="__Fields")
        public void setApiFields(List<ApiField> apiFields) {
            this.apiFields = apiFields;
        }
    }
}

