/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativityQueryWorkspaceOverwrittenPermissionsOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.GroupPermission;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ItemLevelPermissionObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OverwrittenPermissionTypeResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OverwrittenPermissionsResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroup;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroupPermissions;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceGroups;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.WorkspaceObjectType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;

public class RelativityQueryWorkspaceOverwrittenPermissionsOperationImplementation
extends RelativityQueryWorkspaceOverwrittenPermissionsOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityQueryWorkspaceOverwrittenPermissionsOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private long stageItems;
    private AtomicLong stageProcessedItems;
    private String stageItemName;
    private int stageId;
    private int totalStages;
    private Map<String, Set<String>> objectTypesNames = new HashMap<String, Set<String>>();
    private Set<String> objectTypesAnyName = new HashSet<String>();
    private Set<String> effectiveObjectTypes = new HashSet<String>();

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.stageItems = 0L;
                this.stageProcessedItems = new AtomicLong(0L);
                this.stageItemName = null;
                this.stageId = 0;
                this.totalStages = 2;
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.permissionsOutputFile = this.executionContext.evalParameters(this.permissionsOutputFile, this);
                this.stageName = this.iu.getString("RelativityQueryWorkspaceOverwrittenPermissionsOperation.Stage.QueryingObjectTypes");
                ++this.stageId;
                if (this.useObjectsScopeFile) {
                    if (this.objectsScopeFile == null) {
                        this.objectsScopeFile = "";
                    }
                    this.objectsScopeFile = this.executionContext.evalParameters(this.objectsScopeFile, this);
                    this.objectsScope = com.nuix.automate.utils.general.FileUtils.loadVariableColumnTsv((File)new File(this.objectsScopeFile));
                    this.addExecutionLog(this.iu.getFormattedString("RelativityQueryWorkspaceOverwrittenPermissionsOperation.Info.ObjectTypesFile", (Object)this.objectsScopeFile));
                }
                List<WorkspaceObjectType> eligibleObjectTypesList = this.relativityRestClient.queryObjectTypes(workspaceArtifactId);
                ArrayList objectTypeList = new ArrayList();
                this.objectTypesNames = new HashMap<String, Set<String>>();
                for (Object[] oType : this.objectsScope) {
                    void var7_8;
                    String identifier = (String)oType[0];
                    identifier = this.executionContext.evalParameters(identifier, this);
                    String string = "";
                    if (oType[1] != null) {
                        String string3 = ((String)oType[1]).trim();
                        string3 = this.executionContext.evalParameters(string3, this);
                    }
                    if (var7_8.length() > 0) {
                        Set<String> objectTypeNames = this.objectTypesNames.get(identifier);
                        if (objectTypeNames == null) {
                            objectTypeNames = new HashSet<String>();
                            this.objectTypesNames.put(identifier, objectTypeNames);
                        }
                        objectTypeNames.add((String)var7_8);
                    } else {
                        this.objectTypesAnyName.add(identifier);
                    }
                    this.effectiveObjectTypes.add(identifier);
                }
                for (String identifier : this.effectiveObjectTypes) {
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    Object foundType = null;
                    for (WorkspaceObjectType workspaceObjectType : eligibleObjectTypesList) {
                        if (!workspaceObjectType.getName().equals(identifier)) continue;
                        foundType = workspaceObjectType;
                        break;
                    }
                    if (foundType == null) {
                        this.addWarning(this.iu.getFormattedString("RelativityQueryWorkspaceOverwrittenPermissionsOperation.Warning.UnknownObjectType", new Object[]{String.valueOf(identifier), String.valueOf(workspaceArtifactId)}));
                        continue;
                    }
                    ++this.totalStages;
                    objectTypeList.add(foundType);
                }
                Map<Long, WorkspaceGroup> groupIdToArtifactId = this.relativityRestClient.getWorkspaceGroupsWithArtifactIds(workspaceArtifactId);
                OverwrittenPermissionsResult result = new OverwrittenPermissionsResult();
                for (WorkspaceObjectType workspaceObjectType : objectTypeList) {
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    this.stageItemName = workspaceObjectType.getName();
                    this.stageProcessedItems.set(0L);
                    this.stageItems = 0L;
                    ++this.stageId;
                    OverwrittenPermissionTypeResult typeResult = new OverwrittenPermissionTypeResult();
                    result.getResults().add(typeResult);
                    typeResult.setTypeId(workspaceObjectType.getArtifactTypeId());
                    typeResult.setTypeName(workspaceObjectType.getName());
                    Map<Long, ItemLevelPermissionObject> permissionsMap = this.relativityRestClient.getItemLevelObjectsForObjectType(workspaceObjectType.getArtifactTypeId(), workspaceArtifactId);
                    if (!this.objectTypesAnyName.contains(workspaceObjectType.getName())) {
                        Set<String> objectTypeNames = this.objectTypesNames.get(workspaceObjectType.getName());
                        HashMap<Long, ItemLevelPermissionObject> filteredPermissionsMap = new HashMap<Long, ItemLevelPermissionObject>();
                        for (Long objectArtifactId : permissionsMap.keySet()) {
                            ItemLevelPermissionObject itemLevelPermissionObject = permissionsMap.get(objectArtifactId);
                            if (!objectTypeNames.contains(itemLevelPermissionObject.getName())) continue;
                            filteredPermissionsMap.put(objectArtifactId, itemLevelPermissionObject);
                        }
                        permissionsMap = filteredPermissionsMap;
                    }
                    this.addExecutionLog(this.iu.getNumeralFormattedString("RelativityQueryWorkspaceOverwrittenPermissionsOperation.Info.ChildrenObjectResult", (long)permissionsMap.size(), new Object[]{workspaceObjectType.getName()}));
                    this.stageItems = permissionsMap.size();
                    Map<Long, Boolean> itemLevelSecurity = this.relativityRestClient.getItemLevelSecurity(workspaceArtifactId, permissionsMap.keySet());
                    for (Map.Entry<Long, ItemLevelPermissionObject> entry : permissionsMap.entrySet()) {
                        if (!itemLevelSecurity.containsKey(entry.getKey())) {
                            this.stageProcessedItems.addAndGet(1L);
                            continue;
                        }
                        boolean overwritesSecurity = itemLevelSecurity.get(entry.getKey());
                        if (overwritesSecurity) {
                            WorkspaceGroups itemGroups = this.relativityRestClient.getItemGroups(entry.getValue().getArtifactId(), workspaceArtifactId, true);
                            for (WorkspaceGroup group : itemGroups.getWorkspaceGroups()) {
                                GroupPermission groupPermission = new GroupPermission();
                                entry.getValue().getGroupPermissions().add(groupPermission);
                                WorkspaceGroup baseGroup = groupIdToArtifactId.get(group.getArtifactId());
                                if (baseGroup != null) {
                                    groupPermission.setGroupName(baseGroup.getName());
                                    groupPermission.setGroupId(baseGroup.getArtifactId());
                                }
                                groupPermission.setOverwrittenPermissions(null);
                                try {
                                    WorkspaceGroupPermissions groupPermissions = this.relativityRestClient.getItemPermissions(entry.getValue().getArtifactId(), group.getArtifactId(), workspaceArtifactId);
                                    groupPermission.setOverwrittenPermissions(groupPermissions);
                                }
                                catch (IOException e) {
                                    this.addWarning(this.iu.getFormattedString("RelativityQueryWorkspaceOverwrittenPermissionsOperation.Warning.ItemOverwritesInheritSecurityButNotOnGroup", new Object[]{workspaceObjectType.getName(), "'" + entry.getValue().getName() + "'", String.valueOf(group.getArtifactId())}));
                                }
                            }
                        } else {
                            entry.getValue().setGroupPermissions(null);
                        }
                        this.stageProcessedItems.addAndGet(1L);
                        typeResult.getObjects().add(entry.getValue());
                    }
                }
                this.stageItemName = null;
                this.stageItems = 0L;
                this.stageProcessedItems.set(0L);
                this.stageName = this.iu.getString("RelativityQueryWorkspaceOverwrittenPermissionsOperation.Stage.Exporting");
                ++this.stageId;
                String permissionsJsonString = SerializationUtils.toJson((Object)result, (boolean)true);
                this.addExecutionLog(this.iu.getFormattedString("RelativityQueryWorkspaceOverwrittenPermissionsOperation.Info.PermissionsOutputFile", (Object)this.permissionsOutputFile));
                File file = new File(this.permissionsOutputFile);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileUtils.writeStringToFile((File)file, (String)permissionsJsonString, (Charset)StandardCharsets.UTF_8);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_overwritten_permissions_file}", this.permissionsOutputFile)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_export_folder}", new File(this.permissionsOutputFile).getParentFile().getAbsolutePath())));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        if (this.stageId == 1) {
            return 0.05;
        }
        double stagePercentageComplete = 0.0;
        if (this.stageItemName != null && this.stageItems > 0L) {
            stagePercentageComplete = this.stageProcessedItems.doubleValue() / (double)this.stageItems;
        }
        double percentageComplete = 0.0;
        if (this.stageId > 0) {
            percentageComplete = ((double)this.stageId + stagePercentageComplete) / (double)this.totalStages;
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageItemName != null && this.stageItemName.length() > 0) {
            result = (String)result + " / " + this.iu.getFormattedString("RelativityQueryWorkspaceOverwrittenPermissionsOperation.Stage.GeneratingItemPermissions", (Object)this.stageItemName);
        } else if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

