/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityRunOcrSetOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.ExistingOcrSetJobAction;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OcrSetJobResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OcrSetJobStatus;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.OcrSetStopJobResult;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.util.List;

public class RelativityRunOcrSetOperationImplementation
extends RelativityRunOcrSetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityRunOcrSetOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                block19: {
                    this.initializeRelativityClient(false);
                    this.assertRelativityInstanceLicensed();
                    this.ocrSetIdentifier = this.executionContext.evalParameters(this.ocrSetIdentifier, this);
                    Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                    this.stageName = this.iu.getString("RelativityRunOcrSetOperation.Stage.GettingOcrSet");
                    this.percentageComplete = 0.1;
                    List<EligibleObject> eligibleOcrSets = this.relativityRestClient.getOcrSets(workspaceArtifactId, this.ocrSetIdentifierType, this.ocrSetIdentifier);
                    EligibleObject eligibleOcrSet = RelativityUtils.getInstance().filterAllEligibleObject(this.ocrSetIdentifier, this.ocrSetIdentifierType, eligibleOcrSets, RelativityFieldType.OCR_SET);
                    if (eligibleOcrSet == null) {
                        throw new Exception(this.iu.getFormattedString("RelativityRunOcrSetOperation.Exception.MissingOcrSet", (Object)String.valueOf(this.ocrSetIdentifier)));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunOcrSetOperation.Info.OcrSet", new Object[]{eligibleOcrSet.getName(), String.valueOf(eligibleOcrSet.getArtifactId())}));
                    Long ocrSetArtifactId = eligibleOcrSet.getArtifactId();
                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunOcrSetOperation.Info.ExistingOcrSetJobAction", (Object)this.existingOcrSetJobAction.toString()));
                    OcrSetJobStatus currentOcrJobStatus = this.relativityRestClient.getOcrSetJobStatus(workspaceArtifactId, ocrSetArtifactId);
                    boolean jobIsRunning = false;
                    if (currentOcrJobStatus != null && currentOcrJobStatus.isActive()) {
                        jobIsRunning = true;
                        if (this.existingOcrSetJobAction == ExistingOcrSetJobAction.STOP) {
                            this.addExecutionLog(this.iu.getString("RelativityRunOcrSetOperation.Info.JobIsRunningStopping"));
                            OcrSetStopJobResult stopJobResult = this.relativityRestClient.stopOcrSetJob(workspaceArtifactId, ocrSetArtifactId);
                            if (!stopJobResult.isSuccess()) {
                                if (stopJobResult.getMessage() != null && !stopJobResult.getMessage().trim().equals("")) {
                                    throw new Exception(this.iu.getFormattedString("RelativityRunOcrSetOperation.Exception.ErrorStopping", (Object)stopJobResult.getMessage()));
                                }
                                throw new Exception(this.iu.getString("RelativityRunOcrSetOperation.Exception.UnexpectedErrorStopping"));
                            }
                            this.addExecutionLog(this.iu.getString("RelativityRunOcrSetOperation.Info.StoppedOcrSetJob"));
                            jobIsRunning = false;
                        } else {
                            this.addExecutionLog(this.iu.getString("RelativityRunOcrSetOperation.Info.JobIsRunningSkipping"));
                        }
                    }
                    if (!jobIsRunning) {
                        this.stageName = this.iu.getString("RelativityRunOcrSetOperation.Stage.RunningOcrSet");
                        this.percentageComplete = 0.25;
                        OcrSetJobResult ocrSetJobResult = this.relativityRestClient.runOcrSet(workspaceArtifactId, ocrSetArtifactId);
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunOcrSetOperation.Info.OcrSetJobId", new Object[]{String.valueOf(ocrSetJobResult.getJobId())}));
                    }
                    OcrSetJobStatus status = null;
                    if (this.waitForCompletion) {
                        this.addExecutionLog(this.iu.getString("RelativityRunOcrSetOperation.Info.WaitForCompletion"));
                        int iter = 0;
                        while (true) {
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            status = this.relativityRestClient.getOcrSetJobStatus(workspaceArtifactId, ocrSetArtifactId);
                            if (status != null) {
                                if (status.getStatus().equalsIgnoreCase("pending") || status.getStatus().equalsIgnoreCase("waiting")) {
                                    Thread.sleep(1000L);
                                    continue;
                                }
                                if (iter == 0) {
                                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunOcrSetOperation.Info.DocumentsCount", (Object)status.getTotalDocumentCount()));
                                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunOcrSetOperation.Info.ImagesCount", (Object)status.getTotalImageCount()));
                                }
                                if (!status.isActive()) {
                                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunOcrSetOperation.Info.CompletedWithState", (Object)status.getStatus()));
                                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunOcrSetOperation.Info.DocumentsProcessedCount", (Object)status.getDocumentsImportedCount()));
                                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunOcrSetOperation.Info.ImagesProcessedCount", (Object)status.getImagesRecognizedCount()));
                                    if (status.getDocumentsWithImportErrorCount() > 0) {
                                        this.addWarning(this.iu.getNumeralString("RelativityRunOcrSetOperation.Warning.ErrorDocumentsCount", (long)status.getDocumentsWithImportErrorCount().intValue()));
                                    }
                                    if (status.getImagesWithErrorCount() > 0) {
                                        this.addWarning(this.iu.getNumeralString("RelativityRunOcrSetOperation.Warning.ErrorImagesCount", (long)status.getImagesWithErrorCount().intValue()));
                                    }
                                    break block19;
                                }
                                int totalDocumentsProcessed = status.getDocumentsImportedCount() + status.getDocumentsWithImportErrorCount();
                                int totalImagesProcessed = status.getImagesRecognizedCount() + status.getImagesWithErrorCount();
                                int totalProcessed = totalDocumentsProcessed + totalImagesProcessed;
                                int totalItems = status.getTotalDocumentCount() + status.getTotalImageCount();
                                double totalPercentage = (double)totalProcessed / (double)totalItems * 0.75;
                                this.stageName = this.iu.getFormattedString("RelativityRunOcrSetOperation.Stage.RunningOcrSetCount", new Object[]{totalDocumentsProcessed, status.getTotalDocumentCount(), totalImagesProcessed, status.getTotalImageCount()});
                                this.percentageComplete = 0.25 + totalPercentage;
                                ++iter;
                            }
                            Thread.sleep(1000L);
                        }
                    }
                    status = this.relativityRestClient.getOcrSetJobStatus(workspaceArtifactId, ocrSetArtifactId);
                    if (status != null) {
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunOcrSetOperation.Info.DocumentsCount", (Object)status.getTotalDocumentCount()));
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunOcrSetOperation.Info.ImagesCount", (Object)status.getTotalImageCount()));
                    }
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

