/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.RelativityIdentifierType;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureRelativityConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RelativityOperation;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.productions.RunProductionSetActionType;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRow(name="productionSetIdentifierRow", children={"productionSetIdentifierType", "productionSetIdentifier"})
@OperationMetadata(alias=OperationAlias.RELATIVITY_RUN_PRODUCTION_SET, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"RELATIVITY"}), @OperationTag(name="Category", value={"EXPORT"})})
@OperationLicenseModule(module=ModuleType.RELATIVITY_ADVANCED)
public class RelativityRunProductionSetOperation
extends RelativityOperation {
    @FormField(allowedValues={"NAME", "ARTIFACT_ID", "NAME_LIKE"})
    public RelativityIdentifierType productionSetIdentifierType;
    @FormField
    public String productionSetIdentifier;
    @FormField
    public RunProductionSetActionType runProductionSetActionType;
    @FormField
    public boolean waitForCompletion;

    public RelativityRunProductionSetOperation() {
        this.requiresCase = false;
        this.runProductionSetActionType = RunProductionSetActionType.STAGE_AND_RUN;
        this.productionSetIdentifierType = RelativityIdentifierType.ARTIFACT_ID;
        this.productionSetIdentifier = "";
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RelativityRunProductionSetOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureRelativityConnectionOperation = false;
        boolean detectedSetRelativityWorkspaceOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureRelativityConnectionOperation) {
                detectedConfigureRelativityConnectionOperation = true;
            }
            if (o instanceof RelativitySetWorkspaceOperation) {
                detectedSetRelativityWorkspaceOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureRelativityConnectionOperation) {
            prerequisites.add(this.iu.getString("ConfigureRelativityConnectionOperation.Prerequisites.Missing"));
        }
        if (!detectedSetRelativityWorkspaceOperation) {
            prerequisites.add(this.iu.getString("RelativitySetWorkspaceOperation.Prerequisites.Missing"));
        }
        if (this.productionSetIdentifier == null || this.productionSetIdentifier.trim().equals("")) {
            prerequisites.add(this.iu.getString("RelativityRunProductionSetOperation.Prerequisites.MissingProductionIdentifier"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

