/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.aspose.cells.Cell;
import com.aspose.cells.CellsException;
import com.aspose.cells.FindOptions;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.aspose.cells.Worksheet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.RelativityRunSavedSearchOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RunSavedSearchOption;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchDetails;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.SavedSearchRunResult;
import com.nuix.automate.workflow.core.execution.options.report.TemplateWorksheetName;
import com.nuix.automate.workflow.core.utils.general.AsposeUtils;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelativityRunSavedSearchOperationImplementation
extends RelativityRunSavedSearchOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativityRunSavedSearchOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                this.assertRelativityInstanceLicensed();
                this.searchContainerIdentifier = this.executionContext.evalParameters(this.searchContainerIdentifier, this);
                this.savedSearchIdentifier = this.executionContext.evalParameters(this.savedSearchIdentifier, this);
                Long workspaceArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_workspace_id}", this));
                this.stageName = this.iu.getString("RelativityRunSavedSearchOperation.Stage.GettingSavedSearches");
                this.percentageComplete = 0.1;
                this.addExecutionLog(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Log.RunType", (Object)this.runOptions.toString()));
                ArrayList<SavedSearchRunResult> runResults = new ArrayList<SavedSearchRunResult>();
                ArrayList<EligibleObject> savedSearches = new ArrayList<EligibleObject>();
                switch (this.runOptions) {
                    case WORKSPACE: 
                    case SINGLE: {
                        List<EligibleObject> eligibleSearches = this.relativityRestClient.querySearchesForWorkspace(workspaceArtifactId);
                        if (this.runOptions == RunSavedSearchOption.WORKSPACE) {
                            this.addExecutionLog(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Log.SavedSearchesCount", (Object)eligibleSearches.size()));
                            savedSearches.addAll(eligibleSearches);
                            break;
                        }
                        EligibleObject eligibleSearch = RelativityUtils.getInstance().filterEligibleObject(this.savedSearchIdentifier, this.savedSearchIdentifierType, eligibleSearches, RelativityFieldType.SAVED_SEARCH);
                        if (eligibleSearch == null) {
                            throw new Exception(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Exception.MissingSavedSearch", new Object[]{String.valueOf(this.savedSearchIdentifier)}));
                        }
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Log.SavedSearchIdentifier", new Object[]{eligibleSearch.getName(), String.valueOf(eligibleSearch.getArtifactId())}));
                        savedSearches.add(eligibleSearch);
                        break;
                    }
                    case SEARCH_CONTAINER: {
                        List<EligibleObject> eligibleSearchContainers = this.relativityRestClient.querySearchContainersForWorkspace(workspaceArtifactId);
                        EligibleObject eligibleSearchContainer = RelativityUtils.getInstance().filterEligibleObject(this.searchContainerIdentifier, this.searchContainerIdentifierType, eligibleSearchContainers, RelativityFieldType.SEARCH_CONTAINER);
                        if (eligibleSearchContainer == null) {
                            throw new Exception(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Exception.MissingSearchContainer", new Object[]{String.valueOf(this.searchContainerIdentifier)}));
                        }
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Log.SearchContainerIdentifier", new Object[]{eligibleSearchContainer.getName(), String.valueOf(eligibleSearchContainer.getArtifactId())}));
                        Set<Long> children = this.relativityRestClient.getSearchContainerChildren(workspaceArtifactId, eligibleSearchContainer.getArtifactId(), new HashSet<Long>());
                        List<EligibleObject> eligibleSearchContainerSavedSearches = this.relativityRestClient.getAllSearchContainerSavedSearches(workspaceArtifactId, children);
                        this.addExecutionLog(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Log.SavedSearchesCount", (Object)eligibleSearchContainerSavedSearches.size()));
                        savedSearches.addAll(eligibleSearchContainerSavedSearches);
                    }
                }
                Map<Long, String> absoluteContainerPaths = this.relativityRestClient.resolveSearchContainerPaths(workspaceArtifactId);
                this.stageName = this.iu.getString("RelativityRunSavedSearchOperation.Stage.RunningSavedSearches");
                this.percentageComplete = 0.25;
                int totalSavedSearches = savedSearches.size();
                int totalSearchesProcessed = 0;
                int totalSearchesAdded = 0;
                int totalSearchesErrored = 0;
                for (EligibleObject eligibleSearch : savedSearches) {
                    try {
                        long hits = this.relativityRestClient.runSavedSearch(workspaceArtifactId, eligibleSearch.getArtifactId());
                        SavedSearchDetails savedSearch = this.relativityRestClient.readSavedSearch(workspaceArtifactId, eligibleSearch.getArtifactId(), absoluteContainerPaths);
                        SavedSearchRunResult savedSearchRunResult = new SavedSearchRunResult();
                        savedSearchRunResult.setQuery(savedSearch.getSavedSearchQuery());
                        savedSearchRunResult.setFolder(savedSearch.getFolder());
                        savedSearchRunResult.setName(eligibleSearch.getName());
                        savedSearchRunResult.setHits(hits);
                        runResults.add(savedSearchRunResult);
                        ++totalSearchesAdded;
                    }
                    catch (Exception e) {
                        this.addWarning(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Warning.FailedToRun", new Object[]{eligibleSearch.getName(), String.valueOf(eligibleSearch.getArtifactId()), e.getMessage()}));
                        ++totalSearchesErrored;
                    }
                    this.stageName = this.iu.getFormattedString("RelativityRunSavedSearchOperation.Stage.RunningSavedSearchesDetailed", new Object[]{String.valueOf(++totalSearchesProcessed), String.valueOf(totalSavedSearches)});
                    this.percentageComplete = 0.25 + (double)totalSearchesProcessed / (double)totalSavedSearches * 0.65;
                }
                if (totalSearchesAdded > 0) {
                    this.addExecutionLog(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Log.RunCount", (Object)totalSearchesAdded));
                }
                if (totalSearchesErrored > 0) {
                    this.addWarning(this.iu.getNumeralString("RelativityRunSavedSearchOperation.Warning.FailedCount", (long)totalSearchesErrored));
                }
                this.stageName = this.iu.getString("RelativityRunSavedSearchOperation.Stage.GeneratingJson");
                this.percentageComplete = 0.9;
                JsonObject json = new JsonObject();
                JsonArray array = new JsonArray();
                json.add("results", (JsonElement)array);
                for (SavedSearchRunResult result : runResults) {
                    JsonObject rowObject = new JsonObject();
                    if (result.getFolder() != null) {
                        rowObject.add("Folder", (JsonElement)new JsonPrimitive(result.getFolder()));
                    } else {
                        rowObject.add("Folder", (JsonElement)new JsonPrimitive(""));
                    }
                    if (result.getQuery() != null) {
                        rowObject.add("Query", (JsonElement)new JsonPrimitive(result.getQuery()));
                    } else {
                        rowObject.add("Query", (JsonElement)new JsonPrimitive(""));
                    }
                    rowObject.add("Name", (JsonElement)new JsonPrimitive(result.getName()));
                    rowObject.add("Hits", (JsonElement)new JsonPrimitive((Number)result.getHits()));
                    array.add((JsonElement)rowObject);
                }
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_run_saved_search_results_json}", SerializationUtils.toJson((Object)json))));
                this.addExecutionLog(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Log.WroteJsonResults", (Object)"{relativity_run_saved_search_results_json}"));
                System.out.println(SerializationUtils.toJson((Object)json));
                if (this.writeReport) {
                    this.stageName = this.iu.getString("RelativityRunSavedSearchOperation.Stage.WritingReport");
                    this.writeReport(runResults);
                }
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void writeReport(List<SavedSearchRunResult> lines) throws Exception {
        int templateWorksheetIndex;
        Object buffer;
        lines.sort(Comparator.comparing(SavedSearchRunResult::getName, String.CASE_INSENSITIVE_ORDER));
        lines.sort(Comparator.comparing(SavedSearchRunResult::getFolder, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER)));
        AsposeUtils.applyAsposeCellsLicense();
        LoadOptions loadOptions = new LoadOptions(6);
        File templateFile = null;
        if (this.customReportTemplatePath.length() > 0 && !(templateFile = new File(this.customReportTemplatePath)).exists()) {
            LOGGER.error("Cannot find report template file " + templateFile.getAbsolutePath());
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.CouldNotFindReportTemplate", (Object)templateFile.getAbsoluteFile()));
        }
        if (templateFile == null || !templateFile.exists()) {
            templateFile = this.executionContext.getReportTemplate();
            LOGGER.info("Cannot find report template file " + templateFile.getAbsolutePath() + ". Creating default file");
            File templateFolder = templateFile.getParentFile();
            if (!templateFolder.exists()) {
                LOGGER.info("Creating folder " + templateFolder.getAbsolutePath());
                templateFolder.mkdirs();
            }
            try (InputStream templateStream = this.getClass().getResourceAsStream("/reports/template.xlsx");
                 OutputStream outputStream = Files.newOutputStream(templateFile.toPath(), new OpenOption[0]);){
                int bytesRead;
                buffer = new byte[1024];
                while ((bytesRead = templateStream.read((byte[])buffer)) != -1) {
                    outputStream.write((byte[])buffer, 0, bytesRead);
                }
                templateStream.close();
                outputStream.flush();
            }
        }
        Workbook workbook = new Workbook(templateFile.getAbsolutePath(), loadOptions);
        for (int worksheetId = 0; worksheetId < workbook.getWorksheets().getCount(); ++worksheetId) {
            Worksheet worksheet = workbook.getWorksheets().get(worksheetId);
            LOGGER.info("Pre-processing worksheet " + worksheet.getName());
            buffer = this.executionContext.getParameterNames().iterator();
            while (buffer.hasNext()) {
                String placeholder = (String)buffer.next();
                try {
                    FindOptions findOptions = new FindOptions();
                    findOptions.setLookAtType(3);
                    findOptions.setLookInType(1);
                    Cell matchingCell = null;
                    while ((matchingCell = worksheet.getCells().find((Object)placeholder, matchingCell, findOptions)) != null) {
                        String unpackedPlaceholder = this.executionContext.evalParameters(placeholder, this);
                        if (placeholder.equals("{date_spreadsheet}") || placeholder.equals("{date_time_spreadsheet}")) {
                            matchingCell.setValue((Object)Calendar.getInstance());
                        } else if (placeholder.equals("{time_spreadsheet}")) {
                            matchingCell.setValue((Object)new Date());
                        } else {
                            matchingCell.setValue((Object)unpackedPlaceholder);
                        }
                        LOGGER.info("Searching for " + placeholder + ", got " + String.valueOf(matchingCell));
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Cannot unpack placeholder " + placeholder, (Throwable)e);
                }
            }
        }
        String treeSizeWorksheetName = TemplateWorksheetName.TEMPLATE_RELATIVITY_RUN_SAVED_SEARCH.toString();
        try {
            templateWorksheetIndex = workbook.getWorksheets().addCopy(treeSizeWorksheetName);
        }
        catch (CellsException e) {
            this.addWarning(this.iu.getFormattedString("SearchAndTagOperation.Warning.TemplateFileNoWorksheetNamed", (Object)treeSizeWorksheetName));
            return;
        }
        Worksheet worksheet = workbook.getWorksheets().get(templateWorksheetIndex);
        worksheet.setName(this.iu.getString("RelativityRunSavedSearchOperation.Report.SavedSearchRunReport"));
        int sr = 0;
        int sc = 0;
        FindOptions findOptions = new FindOptions();
        findOptions.setLookAtType(0);
        findOptions.setLookInType(1);
        Cell matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"__START__", matchingCell, findOptions);
        if (matchingCell != null) {
            sr = matchingCell.getRow();
            sc = matchingCell.getColumn();
        }
        matchingCell = null;
        matchingCell = worksheet.getCells().find((Object)"{view_name}", matchingCell, findOptions);
        if (matchingCell != null) {
            matchingCell.setValue((Object)this.iu.getString("RelativityRunSavedSearchOperation.Report.SavedSearchRunReport"));
        }
        int rowId = 3;
        int columnId = 0;
        int processedItems = 0;
        String[] headers = new String[]{this.iu.getString("RelativityRunSavedSearchOperation.Report.FolderHeader"), this.iu.getString("RelativityRunSavedSearchOperation.Report.NameHeader"), this.iu.getString("RelativityRunSavedSearchOperation.Report.QueryHeader"), this.iu.getString("RelativityRunSavedSearchOperation.Report.HitsHeader")};
        for (String header : headers) {
            worksheet.getCells().get(sr, sc + columnId).setValue((Object)header);
            ++columnId;
        }
        for (SavedSearchRunResult result : lines) {
            boolean isFirstRow;
            if (this.stopRequested) {
                throw new WorkflowExecutionStopRequested();
            }
            worksheet.getCells().insertRow(sr + ++rowId);
            int isLastRow = processedItems == lines.size() - 1 ? 1 : 0;
            boolean bl = isFirstRow = processedItems == 0;
            if (isFirstRow) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 1, sr + rowId);
            } else if (isLastRow == 0) {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 2, sr + rowId);
            } else {
                worksheet.getCells().copyRow(worksheet.getCells(), sr + 3, sr + rowId);
            }
            worksheet.getCells().get(sr + rowId, sc).setValue((Object)result.getFolder());
            worksheet.getCells().get(sr + rowId, sc + 1).setValue((Object)result.getName());
            worksheet.getCells().get(sr + rowId, sc + 2).setValue((Object)result.getQuery());
            worksheet.getCells().get(sr + rowId, sc + 3).setValue((Object)result.getHits());
            ++processedItems;
        }
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        worksheet.getCells().deleteRow(sr + 1);
        for (TemplateWorksheetName templateWorksheetName : TemplateWorksheetName.values()) {
            try {
                workbook.getWorksheets().removeAt(templateWorksheetName.toString());
            }
            catch (Exception e) {
                LOGGER.error("Cannot remove sheet " + String.valueOf((Object)templateWorksheetName));
            }
        }
        workbook.getBuiltInDocumentProperties().setAuthor("Automate Workflow");
        this.reportLocation = this.executionContext.evalParameters(this.reportLocation, this);
        File reportFile = new File(this.reportLocation);
        this.reportLocation = reportFile.getAbsolutePath();
        File reportFolder = reportFile.getParentFile();
        if (!reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        LOGGER.info("Saving report to " + reportFile.getAbsolutePath());
        if (reportFile.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
            PdfSaveOptions saveOptions = new PdfSaveOptions();
            saveOptions.setAllColumnsInOnePagePerSheet(true);
            workbook.save(reportFile.getAbsolutePath(), (SaveOptions)saveOptions);
        } else {
            String reportPasswordParameter = "{report_password}";
            String reportPassword = this.executionContext.evalParameters(reportPasswordParameter, this);
            if (!reportPassword.equals(reportPasswordParameter)) {
                this.addExecutionLog(this.iu.getString("ProcessingReportOperation.Log.SettingPassword"));
                if (reportPassword.length() == 0) {
                    this.addWarning(this.iu.getString("ProcessingReportOperation.Log.BlankPassword"));
                }
                workbook.setEncryptionOptions(3, 128);
                workbook.getSettings().setPassword(reportPassword);
            }
            workbook.save(reportFile.getAbsolutePath());
        }
        this.addExecutionLog(this.iu.getFormattedString("RelativityRunSavedSearchOperation.Log.ReportLocation", (Object)reportFile.getAbsolutePath()));
        this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{last_report_file}", reportFile.getAbsolutePath())));
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

