/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetClientOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.util.List;

public class RelativitySetClientOperationImplementation
extends RelativitySetClientOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativitySetClientOperation.class);
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                if (this.createClientIfNotExists.booleanValue()) {
                    this.assertRelativityInstanceLicensed();
                }
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                this.clientIdentifier = this.executionContext.evalParameters(this.clientIdentifier, this);
                this.clientNumber = this.executionContext.evalParameters(this.clientNumber, this);
                this.keywords = this.executionContext.evalParameters(this.keywords, this);
                this.clientNotes = this.executionContext.evalParameters(this.clientNotes, this);
                if (this.enableStatus.booleanValue()) {
                    this.statusIdentifier = this.executionContext.evalParameters(this.statusIdentifier, this);
                }
                this.percentageComplete = 0.25;
                this.stageName = this.iu.getString("RelativityCreateClientOperation.Stage.CreatingClient");
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateClientOperation.Log.ClientIdentifier", new Object[]{LocalizableEnumUtils.getLocalizedString((Enum)this.clientIdentifierType), this.clientIdentifier}));
                LOGGER.info("Client identifier " + this.clientIdentifier);
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateClientOperation.Log.CreateIfNotExists", (Object)this.createClientIfNotExists));
                LOGGER.info("Create client if not exists " + this.createClientIfNotExists);
                List<EligibleObject> eligibleClients = this.relativityRestClient.queryEligibleClients(this.clientIdentifierType, this.clientIdentifier);
                EligibleObject eligibleClient = RelativityUtils.getInstance().filterAllEligibleObject(this.clientIdentifier, this.clientIdentifierType, eligibleClients, RelativityFieldType.CLIENT);
                if (eligibleClient != null) {
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateClientOperation.Log.ExistingClient", new Object[]{eligibleClient.getName(), String.valueOf(eligibleClient.getArtifactId())}));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_client_name}", eligibleClient.getName())));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_client_id}", String.valueOf(eligibleClient.getArtifactId()))));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_client_created}", String.valueOf(false))));
                    this.trackFinished();
                    return;
                }
                if (!this.createClientIfNotExists.booleanValue()) {
                    throw new Exception(this.iu.getFormattedString("RelativityCreateClientOperation.Exception.ClientDoesNotExist", new Object[]{LocalizableEnumUtils.getLocalizedString((Enum)this.clientIdentifierType), this.clientIdentifier}));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateClientOperation.Log.ClientNumber", (Object)this.clientNumber));
                LOGGER.info("Client number " + this.clientNumber);
                if (this.keywords != null && !this.keywords.trim().equals("")) {
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateClientOperation.Log.Keywords", (Object)this.keywords));
                    LOGGER.info("Keywords " + this.keywords);
                }
                if (this.clientNotes != null && !this.clientNotes.trim().equals("")) {
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateClientOperation.Log.Notes", (Object)this.clientNotes));
                    LOGGER.info("Notes " + this.clientNotes);
                }
                Long statusArtifactId = -1L;
                List<EligibleObject> eligibleStatuses = this.relativityRestClient.queryEligibleStatusesClients();
                EligibleObject eligibleStatus = null;
                if (this.enableStatus.booleanValue()) {
                    eligibleStatus = RelativityUtils.getInstance().filterEligibleObject(this.statusIdentifier, this.statusIdentifierType, eligibleStatuses, RelativityFieldType.STATUS);
                    if (eligibleStatus == null) {
                        throw new Exception(this.iu.getFormattedString("RelativityCreateWorkspaceOperation.Exception.MissingDefinedStatus", new Object[]{this.statusIdentifier}));
                    }
                } else if (eligibleStatuses != null && eligibleStatuses.size() > 0) {
                    eligibleStatus = eligibleStatuses.get(0);
                }
                if (eligibleStatus == null) {
                    throw new Exception(this.iu.getString("RelativityCreateWorkspaceOperation.Exception.NoStatusesExist"));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateClientOperation.Log.Status", (Object)this.statusIdentifier));
                LOGGER.info("Getting status using identifier type " + String.valueOf(this.statusIdentifierType) + " and identifier " + this.statusIdentifier);
                statusArtifactId = eligibleStatus.getArtifactId();
                Long createdClientArtifactId = this.relativityRestClient.createClient(this.clientIdentifier, this.clientNumber, this.keywords, this.clientNotes, statusArtifactId);
                this.percentageComplete = 0.99;
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateClientOperation.Log.CreatedClient", (Object)String.valueOf(createdClientArtifactId)));
                LOGGER.info("Created client with artifact ID " + createdClientArtifactId);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_client_name}", this.clientIdentifier)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_client_id}", String.valueOf(createdClientArtifactId))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_client_created}", String.valueOf(true))));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

