/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetMatterOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.util.List;

public class RelativitySetMatterOperationImplementation
extends RelativitySetMatterOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativitySetMatterOperation.class);
    private transient double percentageComplete;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeRelativityClient(false);
                if (this.createMatterIfNotExists.booleanValue()) {
                    this.assertRelativityInstanceLicensed();
                }
                if (this.executionContext.evalParameters("{case_or_workspace_name}", this).equals("{case_or_workspace_name}")) {
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", "Admin Workspace")));
                }
                this.matterIdentifier = this.executionContext.evalParameters(this.matterIdentifier, this);
                this.matterNumber = this.executionContext.evalParameters(this.matterNumber, this);
                this.keywords = this.executionContext.evalParameters(this.keywords, this);
                this.matterNotes = this.executionContext.evalParameters(this.matterNotes, this);
                if (this.enableStatus.booleanValue()) {
                    this.statusIdentifier = this.executionContext.evalParameters(this.statusIdentifier, this);
                }
                this.percentageComplete = 0.25;
                this.stageName = this.iu.getString("RelativityCreateMatterOperation.Stage.CreatingMatter");
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateMatterOperation.Log.MatterName", (Object)this.matterIdentifier));
                LOGGER.info("Matter name " + this.matterIdentifier);
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateMatterOperation.Log.CreateIfNotExists", (Object)this.createMatterIfNotExists));
                LOGGER.info("Create matter if not exists " + this.createMatterIfNotExists);
                List<EligibleObject> eligibleMatters = this.relativityRestClient.queryEligibleMattersNoWorkspace(this.matterIdentifierType, this.matterIdentifier);
                EligibleObject eligibleMatter = RelativityUtils.getInstance().filterAllEligibleObject(this.matterIdentifier, this.matterIdentifierType, eligibleMatters, RelativityFieldType.MATTER);
                if (eligibleMatter != null) {
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateMatterOperation.Log.ExistingMatter", new Object[]{eligibleMatter.getName(), String.valueOf(eligibleMatter.getArtifactId())}));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_matter_name}", eligibleMatter.getName())));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_matter_id}", String.valueOf(eligibleMatter.getArtifactId()))));
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_matter_created}", String.valueOf(false))));
                    this.trackFinished();
                    return;
                }
                if (!this.createMatterIfNotExists.booleanValue()) {
                    throw new Exception(this.iu.getFormattedString("RelativityCreateMatterOperation.Exception.MatterDoesNotExist", (Object)this.matterIdentifier));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateMatterOperation.Log.MatterNumber", (Object)this.matterNumber));
                LOGGER.info("Matter number " + this.matterNumber);
                if (this.keywords != null && !this.keywords.trim().equals("")) {
                    this.addExecutionLog(this.iu.getFormattedString("RelativityCreateMatterOperation.Log.Keywords", (Object)this.keywords));
                    LOGGER.info("Keywords " + this.keywords);
                }
                if (this.matterNotes != null && !this.matterNotes.trim().equals("")) {
                    this.addExecutionLog(this.iu.getFormattedString("RelativityMatterClientOperation.Log.Notes", (Object)this.matterNotes));
                    LOGGER.info("Notes " + this.matterNotes);
                }
                Long statusArtifactId = -1L;
                List<EligibleObject> eligibleStatuses = this.relativityRestClient.queryEligibleStatusesMatters();
                EligibleObject eligibleStatus = null;
                if (this.enableStatus.booleanValue()) {
                    eligibleStatus = RelativityUtils.getInstance().filterEligibleObject(this.statusIdentifier, this.statusIdentifierType, eligibleStatuses, RelativityFieldType.STATUS);
                    if (eligibleStatus == null) {
                        throw new Exception(this.iu.getFormattedString("RelativityCreateWorkspaceOperation.Exception.MissingDefinedStatus", new Object[]{this.statusIdentifier}));
                    }
                } else if (eligibleStatuses != null && eligibleStatuses.size() > 0) {
                    eligibleStatus = eligibleStatuses.get(0);
                }
                if (eligibleStatus == null) {
                    throw new Exception(this.iu.getString("RelativityCreateWorkspaceOperation.Exception.NoStatusesExist"));
                }
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateMatterOperation.Log.Status", (Object)this.statusIdentifier));
                LOGGER.info("Getting status using identifier type " + String.valueOf(this.statusIdentifierType) + " and identifier " + this.statusIdentifier);
                statusArtifactId = eligibleStatus.getArtifactId();
                Long relativityClientArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_client_id}", this));
                this.assertRelativityInstanceLicensed();
                Long createMatterArtifactId = this.relativityRestClient.createMatter(this.matterIdentifier, this.matterNumber, this.keywords, this.matterNotes, relativityClientArtifactId, statusArtifactId);
                this.percentageComplete = 0.99;
                this.addExecutionLog(this.iu.getFormattedString("RelativityCreateMatterOperation.Log.CreatedMatter", (Object)String.valueOf(createMatterArtifactId)));
                LOGGER.info("Created matter with artifact ID " + createMatterArtifactId);
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_matter_name}", this.matterIdentifier)));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_matter_id}", String.valueOf(createMatterArtifactId))));
                this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_matter_created}", String.valueOf(true))));
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

