/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.relativity.RelativityRestVersion;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.RelativitySetWorkspaceOperation;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.EligibleObject;
import com.nuix.automate.workflow.core.execution.options.relativity.restv1.RelativityFieldType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityRestException;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RelativitySetWorkspaceOperationImplementation
extends RelativitySetWorkspaceOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RelativitySetWorkspaceOperation.class);
    private transient RelativityRestVersion relativityRestVersion;
    private transient Long folderArtifactId;
    private transient String stageName;
    private transient double percentageComplete;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                long workspaceArtifactId;
                block42: {
                    this.workspaceIdentifier = this.executionContext.evalParameters(this.workspaceIdentifier, this);
                    this.folderPath = this.executionContext.evalParameters(this.folderPath, this);
                    this.clonedWorkspaceName = this.executionContext.evalParameters(this.clonedWorkspaceName, this);
                    this.workspaceTemplate = this.executionContext.evalParameters(this.workspaceTemplate, this);
                    this.resourcePool = this.executionContext.evalParameters(this.resourcePool, this);
                    this.databaseLocation = this.executionContext.evalParameters(this.databaseLocation, this);
                    this.defaultFileRepository = this.executionContext.evalParameters(this.defaultFileRepository, this);
                    this.defaultCacheLocation = this.executionContext.evalParameters(this.defaultCacheLocation, this);
                    this.workspaceStatus = this.executionContext.evalParameters(this.workspaceStatus, this);
                    this.workspaceSqlFullTextLanguage = this.executionContext.evalParameters(this.workspaceSqlFullTextLanguage, this);
                    this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_relativity_folder_path}", this.folderPath)));
                    this.relativityRestVersion = RelativityRestVersion.valueOf((String)this.executionContext.evalParameters("{wfn_relativity_rest_version}", this));
                    this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.RestVersion", (Object)this.relativityRestVersion));
                    this.stageName = this.iu.getFormattedString("UseRelativityWorkspaceOperation.Stage.InitializingRestClient", (Object)this.relativityRestVersion);
                    this.initializeRelativityClient(this.relativityRestVersion, true);
                    if (this.cloneIfNotExists.booleanValue()) {
                        this.assertRelativityInstanceLicensed();
                    }
                    this.stageName = this.iu.getString("UseRelativityWorkspaceOperation.Stage.GettingWorkspace");
                    workspaceArtifactId = -1L;
                    try {
                        List<EligibleObject> eligibleWorkspaces = this.relativityRestClient.queryEligibleWorkspaces(this.workspaceIdentifierType, this.workspaceIdentifier);
                        EligibleObject eligibleWorkspace = RelativityUtils.getInstance().filterAllEligibleObject(this.workspaceIdentifier, this.workspaceIdentifierType, eligibleWorkspaces, RelativityFieldType.WORKSPACE);
                        if (eligibleWorkspace != null) {
                            this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.ExistingWorkspace", new Object[]{eligibleWorkspace.getName(), String.valueOf(eligibleWorkspace.getArtifactId())}));
                            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_workspace_name}", eligibleWorkspace.getName())));
                            this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", eligibleWorkspace.getName())));
                            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_workspace_id}", String.valueOf(eligibleWorkspace.getArtifactId()))));
                            this.executionContext.getExecutionBuiltInParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_workspace_created}", String.valueOf(false))));
                            workspaceArtifactId = eligibleWorkspace.getArtifactId();
                        } else if (!this.cloneIfNotExists.booleanValue()) {
                            throw new IOException(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Exception.WorkspaceDoesNotExist", new Object[]{LocalizableEnumUtils.getLocalizedString((Enum)this.workspaceIdentifierType), this.workspaceIdentifier}));
                        }
                    }
                    catch (RelativityRestException re) {
                        if (this.relativityRestVersion == RelativityRestVersion.RSAPI) {
                            throw new IOException(this.iu.getString("Relativity.Warning.RSAPI"), re);
                        }
                        if (!this.cloneIfNotExists.booleanValue()) {
                            throw re;
                        }
                    }
                    catch (IOException e) {
                        if (this.cloneIfNotExists.booleanValue()) break block42;
                        throw e;
                    }
                }
                if (workspaceArtifactId == -1L && this.cloneIfNotExists.booleanValue()) {
                    long workspaceTemplateArtifactId = -1L;
                    long resourcePoolArtifactId = -1L;
                    long defaultDatabaseLocationArtifactId = -1L;
                    long defaultFileRepositoryArtifactId = -1L;
                    long defaultCacheLocationArtifactId = -1L;
                    long statusArtifactId = -1L;
                    this.addExecutionLog(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Log.CreatingWorkspace", (Object)this.workspaceIdentifier));
                    this.stageName = this.iu.getString("RelativitySetWorkspaceOperation.Stage.CreatingWorkspace");
                    List<EligibleObject> eligibleWorkspaceTemplates = this.relativityRestClient.queryEligibleWorkspaceTemplates(this.workspaceTemplateIdentifierType, this.workspaceTemplate);
                    EligibleObject eligibleWorkspaceTemplate = RelativityUtils.getInstance().filterAllEligibleObject(this.workspaceTemplate, this.workspaceTemplateIdentifierType, eligibleWorkspaceTemplates, RelativityFieldType.WORKSPACE_TEMPLATE);
                    if (eligibleWorkspaceTemplate == null) {
                        throw new IOException(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Exception.MissingWorkspaceTemplate", new Object[]{this.workspaceTemplate}));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Log.WorkspaceTemplate", (Object)eligibleWorkspaceTemplate.getName()));
                    workspaceTemplateArtifactId = eligibleWorkspaceTemplate.getArtifactId();
                    List<EligibleObject> eligibleResourcePools = this.relativityRestClient.queryEligibleResourcePools();
                    EligibleObject eligibleResourcePool = null;
                    if (this.enableResourcePool.booleanValue()) {
                        eligibleResourcePool = RelativityUtils.getInstance().filterEligibleObject(this.resourcePool, this.resourcePoolIdentifierType, eligibleResourcePools, RelativityFieldType.RESOURCE_POOL);
                        if (eligibleResourcePool == null) {
                            throw new IOException(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Exception.MissingDefinedResourcePool", new Object[]{this.resourcePool}));
                        }
                    } else if (eligibleResourcePools != null && eligibleResourcePools.size() > 0) {
                        eligibleResourcePool = eligibleResourcePools.get(0);
                    }
                    if (eligibleResourcePool == null) {
                        throw new IOException(this.iu.getString("RelativitySetWorkspaceOperation.Exception.NoResourcePoolsExist"));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Log.ResourcePoolName", (Object)eligibleResourcePool.getName()));
                    resourcePoolArtifactId = eligibleResourcePool.getArtifactId();
                    List<EligibleObject> eligibleDatabaseLocations = this.relativityRestClient.queryEligibleSQLServers(resourcePoolArtifactId);
                    EligibleObject eligibleDatabaseLocation = null;
                    if (this.enableResourcePool.booleanValue() && this.enableDatabaseLocation.booleanValue()) {
                        eligibleDatabaseLocation = RelativityUtils.getInstance().filterEligibleObject(this.databaseLocation, this.databaseLocationIdentifierType, eligibleDatabaseLocations, RelativityFieldType.SQL_SERVER);
                        if (eligibleDatabaseLocation == null) {
                            throw new IOException(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Exception.MissingDefinedDatabaseLocation", new Object[]{this.databaseLocation}));
                        }
                    } else if (eligibleDatabaseLocations != null && eligibleDatabaseLocations.size() > 0) {
                        eligibleDatabaseLocation = eligibleDatabaseLocations.get(0);
                    }
                    if (eligibleDatabaseLocation == null) {
                        throw new IOException(this.iu.getString("RelativitySetWorkspaceOperation.Exception.NoDatabaseLocationsExist"));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Log.DatabaseLocationName", (Object)eligibleDatabaseLocation.getName()));
                    defaultDatabaseLocationArtifactId = eligibleDatabaseLocation.getArtifactId();
                    List<EligibleObject> eligibleFileRepositories = this.relativityRestClient.queryEligibleFileRepositories(resourcePoolArtifactId);
                    EligibleObject eligibleFileRepository = null;
                    if (this.enableResourcePool.booleanValue() && this.enableDefaultFileRepository.booleanValue()) {
                        eligibleFileRepository = RelativityUtils.getInstance().filterEligibleObject(this.defaultFileRepository, this.defaultFileRepositoryIdentifierType, eligibleFileRepositories, RelativityFieldType.FILE_REPOSITORY);
                        if (eligibleFileRepository == null) {
                            throw new IOException(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Exception.MissingDefinedFileRepository", new Object[]{this.defaultFileRepository}));
                        }
                    } else if (eligibleFileRepositories != null && eligibleFileRepositories.size() > 0) {
                        eligibleFileRepository = eligibleFileRepositories.get(0);
                    }
                    if (eligibleFileRepository == null) {
                        throw new IOException(this.iu.getString("RelativitySetWorkspaceOperation.Exception.NoFileRepositoriesExist"));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Log.FileRepositoryName", (Object)eligibleFileRepository.getName()));
                    defaultFileRepositoryArtifactId = eligibleFileRepository.getArtifactId();
                    List<EligibleObject> eligibleCacheLocations = this.relativityRestClient.queryEligibleCacheLocations(resourcePoolArtifactId);
                    EligibleObject eligibleCacheLocation = null;
                    if (this.enableResourcePool.booleanValue() && this.enableDefaultCacheLocation.booleanValue()) {
                        eligibleCacheLocation = RelativityUtils.getInstance().filterEligibleObject(this.defaultCacheLocation, this.defaultCacheLocationIdentifierType, eligibleCacheLocations, RelativityFieldType.CACHE_LOCATION);
                        if (eligibleCacheLocation == null) {
                            throw new IOException(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Exception.MissingDefinedCacheLocation", new Object[]{this.defaultCacheLocation}));
                        }
                    } else if (eligibleCacheLocations != null && eligibleCacheLocations.size() > 0) {
                        eligibleCacheLocation = eligibleCacheLocations.get(0);
                    }
                    if (eligibleCacheLocation == null) {
                        throw new IOException(this.iu.getString("RelativitySetWorkspaceOperation.Exception.NoCacheLocationsExist"));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Log.CacheLocationName", (Object)eligibleCacheLocation.getName()));
                    defaultCacheLocationArtifactId = eligibleCacheLocation.getArtifactId();
                    List<EligibleObject> eligibleStatuses = this.relativityRestClient.queryEligibleStatusesWorkspaces();
                    EligibleObject eligibleStatus = null;
                    if (this.enableStatus.booleanValue()) {
                        eligibleStatus = RelativityUtils.getInstance().filterEligibleObject(this.workspaceStatus, this.workspaceStatusIdentifierType, eligibleStatuses, RelativityFieldType.STATUS);
                        if (eligibleStatus == null) {
                            throw new IOException(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Exception.MissingDefinedStatus", new Object[]{this.workspaceStatus}));
                        }
                    } else if (eligibleStatuses != null && eligibleStatuses.size() > 0) {
                        eligibleStatus = eligibleStatuses.get(0);
                    }
                    if (eligibleStatus == null) {
                        throw new IOException(this.iu.getString("RelativitySetWorkspaceOperation.Exception.NoStatusesExist"));
                    }
                    this.addExecutionLog(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Log.StatusName", (Object)eligibleStatus.getName()));
                    statusArtifactId = eligibleStatus.getArtifactId();
                    long sqlFullTextLanguageArtifactId = 1033L;
                    if (this.enableSqlFullTextLanguage.booleanValue()) {
                        List<EligibleObject> eligibleSqlFullTextLanguagees = this.relativityRestClient.queryEligibleSqlLanguages();
                        EligibleObject eligibleSqlFullTextLanguage = null;
                        eligibleSqlFullTextLanguage = RelativityUtils.getInstance().filterEligibleObject(this.workspaceSqlFullTextLanguage, this.workspaceSqlFullTextLanguageIdentifierType, eligibleSqlFullTextLanguagees, RelativityFieldType.STATUS);
                        if (eligibleSqlFullTextLanguage == null) {
                            throw new IOException(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Exception.MissingDefinedSqlFullTextLanguage", new Object[]{this.workspaceSqlFullTextLanguage}));
                        }
                        this.addExecutionLog(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Log.SqlFullTextLanguageName", (Object)eligibleSqlFullTextLanguage.getName()));
                        sqlFullTextLanguageArtifactId = eligibleSqlFullTextLanguage.getArtifactId();
                        if (eligibleSqlFullTextLanguage == null) {
                            throw new IOException(this.iu.getString("RelativitySetWorkspaceOperation.Exception.NoSqlFullTextLanguagesExist"));
                        }
                    }
                    Long relativityMatterArtifactId = Long.parseLong(this.executionContext.evalParameters("{relativity_matter_id}", this));
                    Map<String, Object> workspaceMap = this.relativityRestClient.createRelativityWorkspace(this.clonedWorkspaceName, relativityMatterArtifactId, workspaceTemplateArtifactId, resourcePoolArtifactId, defaultFileRepositoryArtifactId, defaultDatabaseLocationArtifactId, defaultCacheLocationArtifactId, statusArtifactId, sqlFullTextLanguageArtifactId);
                    this.addExecutionLog(this.iu.getFormattedString("RelativitySetWorkspaceOperation.Log.CreatedWorkspace", workspaceMap.get("name")));
                    String workspaceNameTemplate = (String)workspaceMap.get("name");
                    workspaceArtifactId = Long.parseLong(String.valueOf(workspaceMap.get("artifactId")));
                    this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.WorkspaceName", (Object)workspaceNameTemplate));
                    this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.WorkspaceId", (Object)("" + workspaceArtifactId)));
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_workspace_name}", workspaceNameTemplate)));
                    this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{case_or_workspace_name}", workspaceNameTemplate)));
                }
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_workspace_id}", String.valueOf(workspaceArtifactId))));
                String[] folders = this.folderPath.split("\\\\");
                ArrayList<String> folderPath = new ArrayList<String>();
                for (String folder : folders) {
                    if (folder.trim().length() <= 0) continue;
                    folderPath.add(folder.trim());
                }
                this.percentageComplete = 0.5;
                this.stageName = this.iu.getString("UseRelativityWorkspaceOperation.Stage.GettingFolder");
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.FolderPath", (Object)this.folderPath));
                this.folderArtifactId = this.relativityRestClient.getFolderArtifactIdId(workspaceArtifactId, folderPath, this.createPathIfNotExists);
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{relativity_folder_id}", String.valueOf(this.folderArtifactId))));
                this.addExecutionLog(this.iu.getFormattedString("UseRelativityWorkspaceOperation.Log.FolderId", (Object)("" + this.folderArtifactId)));
                LOGGER.info("Folder artifact ID: " + this.folderArtifactId);
                this.trackFinished();
            }
            catch (Exception e) {
                LOGGER.error("Operation unchecked exception", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private String getEligibleObjectsMessage(List<EligibleObject> eligibleObjects) {
        if (eligibleObjects == null) {
            return "";
        }
        ArrayList<String> eligibleNames = new ArrayList<String>();
        for (EligibleObject o : eligibleObjects) {
            eligibleNames.add(o.toString());
        }
        return String.join((CharSequence)", ", eligibleNames);
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

