/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.services.metrics.Activity;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionSubType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.operations.ProcessorMimeTypeVolumesUtilizationOperation;
import com.nuix.automate.workflow.core.execution.operations.WorkerBasedOperation;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixWorkerUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import nuix.BatchLoadDetails;
import nuix.Item;
import nuix.LicenceException;
import nuix.ProcessedItem;
import nuix.ProcessingJob;
import nuix.SimpleCase;
import org.joda.time.ReadableInstant;

public class ReloadItemsOperationImplementation
extends ProcessorMimeTypeVolumesUtilizationOperation
implements WorkerBasedOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ReloadItemsOperationImplementation.class);
    public String scope;
    public boolean deleteEncryptedInaccessible;
    @ExcludeFromPrintableOptions
    public boolean excludeOriginalEncryptedDocuments;
    @ExcludeFromPrintableOptions
    public String exclusionName;
    private transient String stageName;
    private transient AtomicLong processedItems;
    private transient long stageTotalItems;
    private transient int stageId;
    private transient int stageCount;
    private transient boolean isPaused;
    private transient String utilizationScopeQuery;
    private transient AtomicInteger addedWorkerCount = new AtomicInteger(0);
    private transient long itemsVolumeRemoved;

    private Item getItemEncryptedSource(Item item) {
        Item encryptedSource;
        for (encryptedSource = (Item)item.getParent(); encryptedSource != null && encryptedSource.getType().getName().equals("filesystem/directory"); encryptedSource = (Item)encryptedSource.getParent()) {
        }
        return encryptedSource;
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.exclusionName = this.executionContext.evalParameters(this.exclusionName, this);
        this.timeZoneId = this.executionContext.evalParameters(this.timeZoneId, this);
        this.addExecutionLog(this.iu.getFormattedString("ReloadItemsOperation.Log.ScopeQuery", (Object)this.scope));
        this.setWorkerSettings();
        NuixWorkerUtils.verifyWorkerSettings(this.executionContext, this);
        this.executionContext.jobBrokerIp = null;
        this.executionContext.closeAllTabs();
        ReloadItemsOperationImplementation currentOperation = this;
        this.startTriggerThread = new Thread(() -> {
            try {
                this.initializeProcessingProfileBuilder();
                this.stageCount = 1;
                this.stageId = 0;
                this.stageName = this.iu.getString("ReloadItemsOperation.Stage.IdentifyingItems");
                this.processedItems = new AtomicLong(0L);
                Set items = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.stageTotalItems = items.size();
                long itemsInScopeCount = items.size();
                this.addExecutionLog(this.iu.getNumeralString("ReloadItemsOperation.Log.ScopeCount", itemsInScopeCount));
                this.itemsVolumeRemoved = this.executionContext.nuixCase.getStatistics().getAuditSize(this.scope);
                if (itemsInScopeCount == 0L) {
                    this.addWarning(this.iu.getString("ReloadItemsOperation.Warning.ZeroScopeItems"));
                }
                Set itemsToReload = this.deleteEncryptedInaccessible ? new HashSet() : items;
                HashSet itemsToDelete = new HashSet();
                if (this.deleteEncryptedInaccessible) {
                    this.addExecutionLog(this.iu.getString("ReloadItemsOperation.Log.DeleteEncryptedInaccessible"));
                    for (Item item : items) {
                        if (item.getType().getName().equals("filesystem/inaccessible")) {
                            Item encryptedSource = this.getItemEncryptedSource(item);
                            itemsToReload.add(encryptedSource);
                            itemsToDelete.addAll(encryptedSource.getChildren());
                        } else {
                            itemsToReload.add(item);
                        }
                        this.processedItems.incrementAndGet();
                    }
                }
                this.processedItems = new AtomicLong(0L);
                this.stageTotalItems = itemsToDelete.size();
                this.stageName = this.iu.getString("ReloadItemsOperation.Stage.DeletingItems");
                AtomicLong itemsFailedDeletion = new AtomicLong(0L);
                this.executionContext.nuixCase.withWriteAccess(() -> {
                    LOGGER.info("Deleting items");
                    for (Item item : itemsToDelete) {
                        LOGGER.info("Deleting item " + item.getGuid() + "\t" + item.getName());
                        try {
                            item.removeItemAndDescendants();
                        }
                        catch (IOException e) {
                            itemsFailedDeletion.incrementAndGet();
                            LOGGER.error("Cannot delete item " + item.getGuid(), (Throwable)e);
                        }
                        this.processedItems.incrementAndGet();
                    }
                });
                this.processedItems = new AtomicLong(0L);
                this.stageTotalItems = itemsToReload.size();
                this.stageName = this.iu.getString("ReloadItemsOperation.Stage.ReloadingItems");
                try {
                    SimpleCase simpleCase = NuixUtils.getSimpleCase(this.executionContext.nuixCase);
                    this.processor = simpleCase.createProcessor();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot create processor", (Throwable)e);
                    this.exception = new Exception(this.iu.getString("ReloadItemsOperation.Exception.CannotAccessNuixProcessor"));
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                try {
                    this.setConfigurationProfileSettings();
                    this.setProcessingProfileSettingsToProcessor(new HashMap<String, Object>());
                    this.setWorkerParallelSettings();
                    this.applyProcessingProfileAsProcessorSettings();
                    long memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    LOGGER.info("Memory used before start: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                    this.processor.whenItemProcessed(this::itemProcessed);
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    this.setDecryptionSettings();
                    this.processor.reloadItemsFromSourceData((Collection)itemsToReload);
                    this.processor.getProcessingSettings().put("calculateAuditedSize", true);
                    this.loadProcessingJob = this.processor.processAsync();
                    NuixWorkerUtils.addRemoteWorkers(this.executionContext, this, (ProcessingJob)this.loadProcessingJob, this.addedWorkerCount);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot start processing", (Throwable)e);
                    this.exception = new Exception(this.iu.getString("AddEvidenceOperation.Exception.CannotStartProcessing"), e);
                    this.executionState = ExecutionState.ERROR;
                    try {
                        if (this.loadProcessingJob != null) {
                            LOGGER.info("Attempting to stop job");
                            this.loadProcessingJob.stop();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Cannot stop job", (Throwable)ex);
                    }
                    return;
                }
                NuixUtils.waitForProcessingJobToComplete((ProcessingJob)this.loadProcessingJob);
                if (this.executionState == ExecutionState.STOPPING) {
                    this.trackStopped();
                }
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void resumeTriggered() {
        try {
            this.loadProcessingJob.resume();
        }
        catch (Exception e) {
            LOGGER.error("resumeTriggered() triggered", (Throwable)e);
        }
    }

    @Override
    public void pauseTriggered() {
        try {
            this.loadProcessingJob.pause();
        }
        catch (Exception e) {
            LOGGER.error("resumeTriggered() triggered", (Throwable)e);
        }
    }

    @Override
    protected void stopTriggered() {
        LOGGER.info("Stop triggered");
        Thread thread = new Thread(() -> {
            while (this.executionState == ExecutionState.STOPPING) {
                try {
                    if (this.loadProcessingJob != null) {
                        LOGGER.info("Sending stop command");
                        this.loadProcessingJob.stop();
                    }
                }
                catch (LicenceException e) {
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot stop job", (Throwable)e);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        thread.setName("Automate - Operation " + this.getOperationName());
        thread.start();
    }

    @Override
    public synchronized void updateState() {
        if (this.loadProcessingJob != null) {
            if (!this.isPaused && this.loadProcessingJob.hasPaused()) {
                this.isPaused = true;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", false);
            }
            if (this.isPaused && !this.loadProcessingJob.hasPaused()) {
                this.isPaused = false;
                this.addTransientWarning(this.getOperationName() + " temporarily halted due to insufficient free disk space.", true);
            }
            if (this.executionState == ExecutionState.RUNNING || this.executionState == ExecutionState.PAUSING) {
                if (this.loadProcessingJob.hasFinished()) {
                    try {
                        long memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        LOGGER.info("Memory used after finish: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                        try {
                            this.executionContext.nuixCase.getBatchLoads();
                        }
                        catch (Exception e) {
                            LOGGER.error("Cannot get batchloads", (Throwable)e);
                            NuixUtils.reopenCase(this.executionContext);
                        }
                        BatchLoadDetails lastBatchLoad = null;
                        for (BatchLoadDetails batchLoadDetails : this.executionContext.nuixCase.getBatchLoads()) {
                            if (lastBatchLoad != null && !batchLoadDetails.getLoaded().isAfter((ReadableInstant)lastBatchLoad.getLoaded())) continue;
                            lastBatchLoad = batchLoadDetails;
                        }
                        this.addExecutionLog(this.iu.getNumeralString("ReloadItemsOperation.Log.ReloadedCount", this.loadProcessingJob.getItemsProcessed()));
                        if (this.excludeOriginalEncryptedDocuments) {
                            try {
                                LOGGER.info("Searching for encrypted documents with decrypted descendants");
                                Set encryptedDocuments = this.executionContext.nuixCase.searchUnsorted("batch-load-guid:" + this.loadProcessingJob.getJobGuid() + " AND flag:encrypted AND kind:document");
                                HashSet<Item> documentsToExclude = new HashSet<Item>();
                                for (Item item : encryptedDocuments) {
                                    boolean itemHasDecryptedFile = false;
                                    for (Item descendant : item.getDescendants()) {
                                        if (descendant.isEncrypted() || !descendant.getName().equals(item.getName())) continue;
                                        itemHasDecryptedFile = true;
                                        break;
                                    }
                                    if (!itemHasDecryptedFile) continue;
                                    documentsToExclude.add(item);
                                }
                                this.addExecutionLog(this.iu.getNumeralString("ReloadItemsOperation.Log.ExcludeOriginalEncrypted", (long)documentsToExclude.size()));
                                this.executionContext.nuixUtilities.getBulkAnnotater().exclude(this.exclusionName, documentsToExclude);
                            }
                            catch (IOException e) {
                                LOGGER.warn("Cannot exclude original encrypted documents", (Throwable)e);
                                this.addWarning(ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                            }
                        }
                        System.gc();
                        memoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                        LOGGER.info("Memory used after clean-up: " + FormattingUtils.sizeToDisplaySize((long)memoryUsed));
                        if (this.startTriggerThread != null && this.startTriggerThread.isAlive()) {
                            LOGGER.info("Interrupting startTriggerThread");
                            this.startTriggerThread.interrupt();
                        }
                        if (this.startTriggerThread != null) {
                            try {
                                LOGGER.info("Waiting 60s for startTriggerThread to complete");
                                this.startTriggerThread.join(60000L);
                            }
                            catch (InterruptedException e) {
                                LOGGER.warn("Could not wait for startTriggerThread to finish", (Throwable)e);
                            }
                        }
                        try {
                            this.utilizationScopeQuery = "batch-load-guid:" + this.loadProcessingJob.getJobGuid();
                            this.addExecutionLog(this.iu.getFormattedString("AddEvidenceOperation.Log.BatchLoadGuid", (Object)this.loadProcessingJob.getJobGuid()));
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot log last batchload guid", (Throwable)e);
                        }
                        this.trackFinished();
                    }
                    catch (Exception e) {
                        this.exception = e;
                        this.executionState = ExecutionState.ERROR;
                        return;
                    }
                }
            } else if (this.executionState == ExecutionState.STOPPING && this.loadProcessingJob.hasFinished()) {
                this.trackStopped();
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.processedItems != null) {
            stageProgress = (double)this.processedItems.get() / (double)this.stageTotalItems;
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.processedItems != null && this.processedItems.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("ReloadItemsOperation.Progress.ItemsProcessed", this.processedItems.get());
        }
        return result;
    }

    public void itemProcessed(ProcessedItem processedItem) {
        this.processedItems.incrementAndGet();
        if (this.loadProcessingJob != null) {
            try {
                this.trackVolumeProcessed(this.loadProcessingJob.getBytesProcessed());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addOperationRunningLog(this.iu.getFormattedString("OperationStats.Processed", (Object)String.join((CharSequence)"/", processedItem.getPath())));
        this.trackItemProcessedIrregular(processedItem.getMimeType(), processedItem.isCorrupted(), processedItem.isEncrypted(), processedItem.isDeleted());
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("ReloadItemsOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.RELOAD_ITEMS;
    }

    @Override
    public String getUtilizationScopeQuery() {
        return this.utilizationScopeQuery;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.LOAD;
    }

    @Override
    public Activity getActivity() {
        return Activity.LOAD;
    }

    @Override
    public String getProcessingJobGuid() {
        if (this.loadProcessingJob != null) {
            return this.loadProcessingJob.getJobGuid();
        }
        return null;
    }

    @Override
    protected ConsumptionSubType getConsumptionSubType() {
        return ConsumptionSubType.RELOAD;
    }

    @Override
    public Consumption getOperationConsumption() {
        Consumption consumption = super.getOperationConsumption();
        ConsumptionEvent reloadAddedEvent = null;
        List consumptionEvents = consumption.getConsumptionEvents();
        for (ConsumptionEvent consumptionEvent : consumptionEvents) {
            if (!consumptionEvent.getConsumptionSubType().equals((Object)ConsumptionSubType.RELOAD)) continue;
            reloadAddedEvent = consumptionEvent;
        }
        if (reloadAddedEvent != null) {
            ConsumptionEvent reloadRemovedEvent = reloadAddedEvent.clone();
            reloadRemovedEvent.setConsumptionEventId(UidUtils.getRandom());
            reloadRemovedEvent.setConsumptionType(ConsumptionType.DATA_REMOVED);
            reloadRemovedEvent.setUnits(-this.itemsVolumeRemoved);
            consumption.add(reloadRemovedEvent);
        }
        return consumption;
    }
}

