/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RemoveCustomMetadataOperation;
import com.nuix.automate.workflow.core.execution.options.general.ToInclude;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import nuix.BulkAnnotater;

public class RemoveCustomMetadataOperationImplementation
extends RemoveCustomMetadataOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RemoveCustomMetadataOperation.class);
    private transient int fieldsToRemoveCount;
    private transient int fieldsRemovedCount;
    private transient int fieldsAttemptedToRemoveCount;
    private transient String stageName;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                TreeSet<String> customMetadataFields;
                this.executionContext.closeAllTabs();
                this.scope = this.executionContext.evalParameters(this.scope, this);
                this.addExecutionLog(this.iu.getFormattedString("RemoveCustomMetadataOperation.Log.ScopeQuery", (Object)this.scope));
                Set items = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.addExecutionLog(this.iu.getNumeralString("RemoveCustomMetadataOperation.Log.ScopeCount", (long)items.size()));
                this.addExecutionLog(this.iu.getFormattedString("RemoveCustomMetadataOperation.Log.CustomMetadataFields", (Object)this.getJoinedCustomMetadataFieldNames(true)));
                this.stageName = this.iu.getString("RemoveCustomMetadataOperation.Stage.RemovingCustomMetadataFields");
                AtomicLong failedCount = new AtomicLong();
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                if (this.customMetadataFieldsToRemove == ToInclude.ALL) {
                    customMetadataFields = new TreeSet<String>();
                    NavigableSet metadataFields = this.executionContext.nuixCase.getCustomMetadataFields(new String[]{"user"});
                    for (String metadataField : metadataFields) {
                        customMetadataFields.add(metadataField);
                    }
                    this.fieldsToRemoveCount = customMetadataFields.size();
                    for (String customMetadataFieldName : customMetadataFields) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        bulkAnnotater.removeCustomMetadata(customMetadataFieldName, (Collection)items, itemEventInfo -> {
                            if (itemEventInfo.getFailure() != null) {
                                failedCount.incrementAndGet();
                            }
                        });
                        ++this.fieldsRemovedCount;
                        ++this.fieldsAttemptedToRemoveCount;
                    }
                } else {
                    customMetadataFields = new TreeSet();
                    try {
                        NavigableSet metadataFields = this.executionContext.nuixCase.getCustomMetadataFields(new String[]{"user"});
                        for (String metadataField : metadataFields) {
                            customMetadataFields.add(metadataField);
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Cannot get custom metadata fields", t);
                        customMetadataFields = null;
                    }
                    this.fieldsToRemoveCount = this.customMetadataFieldNames.size();
                    for (Object[] customMetadataField : this.customMetadataFieldNames) {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        String customMetadataFieldName = (String)customMetadataField[0];
                        if ((customMetadataFieldName = this.executionContext.evalParameters(customMetadataFieldName, this)).trim().length() > 0) {
                            if (customMetadataFields == null || customMetadataFields.contains(customMetadataFieldName)) {
                                bulkAnnotater.removeCustomMetadata(customMetadataFieldName, (Collection)items, itemEventInfo -> {
                                    if (itemEventInfo.getFailure() != null) {
                                        failedCount.incrementAndGet();
                                    }
                                });
                                ++this.fieldsRemovedCount;
                            } else {
                                this.addWarning(this.iu.getFormattedString("RemoveCustomMetadataOperation.Warning.CustomMetadataFieldNotFound", (Object)customMetadataFieldName));
                            }
                        }
                        ++this.fieldsAttemptedToRemoveCount;
                    }
                }
                this.addExecutionLog(this.iu.getNumeralFormattedString("RemoveCustomMetadataOperation.Log.RemovedCustomMetadataFields", (long)this.fieldsRemovedCount, (Object)this.iu.getNumeralString("RemoveCustomMetadataOperation.Log.CountedItems", (long)items.size())));
                long failedToRemoveCount = failedCount.get();
                if (failedToRemoveCount > 0L) {
                    this.addExecutionLog(this.iu.getNumeralString("RemoveCustomMetadataOperation.Log.FailedMetadataFields", failedToRemoveCount));
                }
                this.trackFinished();
            }
            catch (ParameterException e) {
                LOGGER.error("Error evaluating parameter", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private String getJoinedCustomMetadataFieldNames(boolean evalParameters) {
        ArrayList<String> names = new ArrayList<String>();
        for (Object[] customMetadaFieldName : this.customMetadataFieldNames) {
            String name = (String)customMetadaFieldName[0];
            if (evalParameters) {
                try {
                    name = this.executionContext.evalParameters(name, this);
                }
                catch (ParameterException e) {
                    LOGGER.error("Error evaluating parameter", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                }
            }
            if (name.trim().length() <= 0) continue;
            names.add(name);
        }
        return this.customMetadataFieldsToRemove == ToInclude.ALL ? "All" : String.join((CharSequence)"; ", names);
    }

    @Override
    public String getPrintablePercentageComplete() {
        double percentageComplete = this.getNormalizedPercentageComplete();
        Object result = String.format("%.2f%%", percentageComplete * 100.0);
        if (this.stageName != null) {
            result = (String)result + " / " + FormattingUtils.stageToString((String)this.stageName);
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.fieldsToRemoveCount > 0) {
            percentageComplete = (double)this.fieldsAttemptedToRemoveCount / (double)this.fieldsToRemoveCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }
}

