/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.RemoveTextItemModifierCallback;
import com.nuix.automate.workflow.core.execution.operations.RemoveTextOperation;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Case;
import nuix.Item;
import nuix.ItemModifierCallback;

public class RemoveTextOperationImplementation
extends RemoveTextOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(RemoveTextOperation.class);
    private transient long countItemsToProcess;
    private transient AtomicLong countItemsProcessed;

    private String getHash(Item item) {
        Object originalMd5Digest;
        String md5 = item.getDigests().getMd5();
        if ((md5 == null || md5.length() == 0) && (originalMd5Digest = item.getProperties().get("Original MD5 Digest")) != null) {
            md5 = originalMd5Digest.toString();
        }
        return md5;
    }

    @Override
    public void startTriggered() throws Exception {
        LOGGER.info("Starting execution");
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.addExecutionLog(this.iu.getFormattedString("RemoveTextOperation.Log.ScopeQuery", (Object)this.scope));
        this.executionContext.closeAllTabs();
        this.countItemsProcessed = new AtomicLong(0L);
        this.startTriggerThread = new Thread(() -> {
            Case writableCase = this.executionContext.nuixCase;
            this.executionContext.nuixCase.withWriteAccess(() -> {
                try {
                    Set items = writableCase.searchUnsorted(this.scope);
                    this.countItemsToProcess = items.size();
                    this.addExecutionLog(this.iu.getNumeralString("RemoveTextOperation.Log.ScopeCount", this.countItemsToProcess));
                    items.parallelStream().forEach(item -> {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        try {
                            item.modify((ItemModifierCallback)new RemoveTextItemModifierCallback((Item)item));
                        }
                        catch (Throwable e) {
                            LOGGER.error("Cannot process item " + item.getGuid(), e);
                        }
                        this.countItemsProcessed.incrementAndGet();
                    });
                }
                catch (Throwable e) {
                    LOGGER.error("Operation unchecked exception", e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
            });
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.countItemsProcessed != null) {
            result = (String)result + this.iu.getNumeralString("RemoveTextOperation.Progress.ItemsProcessed", this.countItemsProcessed.get());
        }
        return result;
    }

    @Override
    protected double getPercentageComplete() {
        if (this.countItemsToProcess > 0L) {
            return (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        return 0.0;
    }
}

