/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.WorkerBasedOperation;
import java.util.List;

@FormFieldGroup(name="matchItemsByGroup", children={"matchItemsByMD5", "matchItemsByGUID"}, styled=false, positionLabel=@PositionLabel(left="matchItemsBy"))
@FormFieldRow(name="tagMatchedItemsRow", children={"tagMatchedItems", "tagName"})
@OperationMetadata(alias=OperationAlias.REPLACE_ITEMS, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"LOAD", "MANAGEMENT"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class ReplaceItemsOperation
extends Operation
implements WorkerBasedOperation {
    @FormField(enableOn={@OnField(name="sourceFolder", value={"__DUMMY_ALWAYS_DISABLED__"})})
    public boolean matchItemsByMD5 = true;
    @FormField(enableOn={@OnField(name="sourceFolder", value={"__DUMMY_ALWAYS_DISABLED__"})})
    public boolean matchItemsByGUID = true;
    @FormField
    public boolean tagMatchedItems = false;
    @FormField(enableOn={@OnField(name="tagMatchedItems")})
    public String tagName = "Replace Items|Matched Items";
    @FormField
    public String sourceFolder = "";
    @FormField
    public boolean keepOriginal = false;

    @Override
    public String getOperationName() {
        return this.iu.getString("ReplaceItemsOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.REPLACE_ITEMS;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        Version requiredNuixVersion;
        int requiredVersionSatisfied;
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.sourceFolder.trim().length() == 0) {
            prerequisites.add(this.iu.getString("ReplaceItemsOperation.Prerequisites.SourceFolderMustBeSpecified"));
        }
        if ((activity == Operation.PrerequisitesActivity.RUN_INTERACTIVE || activity == Operation.PrerequisitesActivity.RUN_UNATTENDED) && (requiredVersionSatisfied = this.executionContext.nuixVersion.compareTo(requiredNuixVersion = new Version("7.2.0"))) < 0) {
            prerequisites.add(this.iu.getString("ReplaceItemsOperation.Prerequisites.UpdateNuixToUseFeature"));
        }
        if (!this.matchItemsByMD5 && !this.matchItemsByGUID) {
            prerequisites.add(this.iu.getString("ReplaceItemsOperation.Prerequisites.AtLeastOneMatchMustBeSelected"));
        }
        return prerequisites;
    }

    @Override
    public String getProcessingJobGuid() {
        return null;
    }
}

