/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.ReplaceTextFromFileModifierCallback;
import com.nuix.automate.workflow.core.execution.operations.ReplaceTextOperation;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Case;
import nuix.ItemModifierCallback;

public class ReplaceTextOperationImplementation
extends ReplaceTextOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ReplaceTextOperation.class);
    private transient long countItemsToProcess;
    private transient AtomicLong countItemsProcessed;
    private transient AtomicLong countItemsTextReplaced;
    private transient Map<String, File> textFiles;

    private void scanTextFiles(File location) {
        if (this.stopRequested) {
            this.trackStopped();
            return;
        }
        if (this.textFiles == null) {
            this.textFiles = new HashMap<String, File>();
        }
        for (File file : location.listFiles()) {
            if (file.isFile()) {
                if (!file.getName().toLowerCase().endsWith(".txt")) continue;
                this.textFiles.put(file.getName().substring(0, file.getName().length() - 4).toLowerCase(), file);
                continue;
            }
            this.scanTextFiles(file);
        }
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.sourceTextFilesFolder = this.executionContext.evalParameters(this.sourceTextFilesFolder, this);
        this.executionContext.closeAllTabs();
        this.countItemsProcessed = new AtomicLong(0L);
        this.countItemsTextReplaced = new AtomicLong(0L);
        this.addExecutionLog(this.iu.getFormattedString("ReplaceTextOperation.Log.ScopeQuery", (Object)this.scope));
        this.startTriggerThread = new Thread(() -> {
            Case writableCase = this.executionContext.nuixCase;
            LOGGER.info("Scanning for text files");
            this.scanTextFiles(new File(this.sourceTextFilesFolder));
            this.executionContext.nuixCase.withWriteAccess(() -> {
                try {
                    Object matchBy;
                    LOGGER.info("Searching for items");
                    Set items = writableCase.searchUnsorted(this.scope);
                    this.countItemsToProcess = items.size();
                    this.addExecutionLog(this.iu.getNumeralString("ReplaceTextOperation.Log.ScopeCount", this.countItemsToProcess));
                    if (this.stopRequested) {
                        this.trackStopped();
                        return;
                    }
                    Object object = matchBy = this.matchItemsByMD5 ? "MD5" : "";
                    if (((String)matchBy).length() > 0) {
                        matchBy = (String)matchBy + (this.matchItemsByGUID ? ";GUID" : "");
                    }
                    this.addExecutionLog(this.iu.getFormattedString("ReplaceTextOperation.Log.MatchBy", matchBy));
                    LOGGER.info("Assigning text");
                    items.parallelStream().forEach(item -> {
                        if (this.stopRequested) {
                            this.trackStopped();
                            return;
                        }
                        try {
                            String replacementTextFileCandidateName;
                            String md5;
                            ArrayList<String> replacementTextFileCandidateNames = new ArrayList<String>();
                            if (this.matchItemsByMD5 && (md5 = item.getDigests().getMd5()) != null) {
                                replacementTextFileCandidateNames.add(md5);
                            }
                            if (this.matchItemsByGUID) {
                                replacementTextFileCandidateNames.add(item.getGuid());
                                replacementTextFileCandidateNames.add(item.getGuid().replace("-", ""));
                            }
                            File textFileMatch = null;
                            Iterator iterator = replacementTextFileCandidateNames.iterator();
                            while (iterator.hasNext() && (textFileMatch = this.textFiles.get((replacementTextFileCandidateName = (String)iterator.next()).toLowerCase())) == null) {
                            }
                            if (textFileMatch != null) {
                                item.modify((ItemModifierCallback)new ReplaceTextFromFileModifierCallback(textFileMatch, StandardCharsets.UTF_8));
                                this.countItemsTextReplaced.incrementAndGet();
                            } else if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Cannot find text replacement match for item with guid " + item.getGuid());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Cannot process item " + item.getGuid(), (Throwable)e);
                        }
                        this.countItemsProcessed.incrementAndGet();
                    });
                    this.addExecutionLog(this.iu.getNumeralString("ReplaceTextOperation.Log.MatchedCount", this.countItemsTextReplaced.get()));
                }
                catch (Throwable e) {
                    LOGGER.error("Operation unchecked exception", e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
            });
            this.trackFinished();
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.countItemsToProcess > 0L) {
            percentageComplete = (double)this.countItemsProcessed.get() / (double)this.countItemsToProcess;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.countItemsTextReplaced != null) {
            result = (String)result + this.iu.getNumeralString("ReplaceTextOperation.Progress.ReplacedTextFor", this.countItemsTextReplaced.get());
        }
        return result;
    }
}

