/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OperationMetadata(alias=OperationAlias.RUN_EXTERNAL_APPLICATION, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_AUTOMATE"}), @OperationTag(name="Category", value={"EXTERNAL_COMMAND"})})
@OperationParameter(label="queryRetrieveExitCode", parameter="{last_exit_code}")
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class RunExternalApplicationOperation
extends Operation {
    @FormField
    public String applicationLocation = "";
    @FormField(required=false)
    public String applicationArguments = "";
    @FormField
    public String applicationWorkingDirectory = "";
    @FormField(required=false, columnFields={@FormFieldColumn(label="validExitValue")})
    public List<String> validExitValues;

    public RunExternalApplicationOperation() {
        this.requiresCase = false;
        this.validExitValues = new ArrayList<String>();
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("RunExternalApplicationOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.RUN_EXTERNAL_APPLICATION;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.applicationLocation == null || this.applicationLocation.equals("") || this.applicationLocation.equals(" ")) {
            prerequisites.add(this.iu.getString("RunExternalApplicationOperation.Prerequisites.ApplicationLocationMustBeSpecified"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }

    @Override
    public void normalize() {
        super.normalize();
        ArrayList<String> normalizedValidExitValues = new ArrayList<String>();
        for (String validExitValue : this.validExitValues) {
            String value = validExitValue.trim();
            if (value.length() <= 0) continue;
            normalizedValidExitValues.add(value);
        }
        this.validExitValues = normalizedValidExitValues;
    }
}

